<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParagraphType StructType
 * @subpackage Structs
 */
class ParagraphType extends AbstractStructBase
{
    /**
     * The ListItem
     * Meta information extracted from the WSDL
     * - choice: ListItem | Text
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ListItem
     */
    public $ListItem;
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - choice: ListItem | Text
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FormattedTextTextType
     */
    public $Text;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * Constructor method for ParagraphType
     * @uses ParagraphType::setListItem()
     * @uses ParagraphType::setText()
     * @uses ParagraphType::setName()
     * @param \StructType\ListItem $listItem
     * @param \StructType\FormattedTextTextType $text
     * @param string $name
     */
    public function __construct(\StructType\ListItem $listItem = null, \StructType\FormattedTextTextType $text = null, $name = null)
    {
        $this
            ->setListItem($listItem)
            ->setText($text)
            ->setName($name);
    }
    /**
     * Get ListItem value
     * @return \StructType\ListItem|null
     */
    public function getListItem()
    {
        return isset($this->ListItem) ? $this->ListItem : null;
    }
    /**
     * This method is responsible for validating the value passed to the setListItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setListItem method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateListItemForChoiceConstraintsFromSetListItem($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Text',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ListItem can\'t be set as the property %s is already set. Only one property must be set among these properties: ListItem, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ListItem value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ListItem $listItem
     * @return \StructType\ParagraphType
     */
    public function setListItem(\StructType\ListItem $listItem = null)
    {
        // validation for constraint: choice(ListItem, Text)
        if ('' !== ($listItemChoiceErrorMessage = self::validateListItemForChoiceConstraintsFromSetListItem($listItem))) {
            throw new \InvalidArgumentException($listItemChoiceErrorMessage, __LINE__);
        }
        if (is_null($listItem) || (is_array($listItem) && empty($listItem))) {
            unset($this->ListItem);
        } else {
            $this->ListItem = $listItem;
        }
        return $this;
    }
    /**
     * Get Text value
     * @return \StructType\FormattedTextTextType|null
     */
    public function getText()
    {
        return isset($this->Text) ? $this->Text : null;
    }
    /**
     * This method is responsible for validating the value passed to the setText method
     * This method is willingly generated in order to preserve the one-line inline validation within the setText method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTextForChoiceConstraintsFromSetText($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ListItem',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Text can\'t be set as the property %s is already set. Only one property must be set among these properties: Text, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Text value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\FormattedTextTextType $text
     * @return \StructType\ParagraphType
     */
    public function setText(\StructType\FormattedTextTextType $text = null)
    {
        // validation for constraint: choice(ListItem, Text)
        if ('' !== ($textChoiceErrorMessage = self::validateTextForChoiceConstraintsFromSetText($text))) {
            throw new \InvalidArgumentException($textChoiceErrorMessage, __LINE__);
        }
        if (is_null($text) || (is_array($text) && empty($text))) {
            unset($this->Text);
        } else {
            $this->Text = $text;
        }
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\ParagraphType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ParagraphType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
