<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MemberPreferences StructType
 * @subpackage Structs
 */
class MemberPreferences extends AbstractStructBase
{
    /**
     * The AdditionalReward
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AdditionalReward[]
     */
    public $AdditionalReward;
    /**
     * The Offer
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Offer[]
     */
    public $Offer;
    /**
     * The Awareness
     * @var string
     */
    public $Awareness;
    /**
     * The PromotionCode
     * @var string
     */
    public $PromotionCode;
    /**
     * The PromotionVendorCode
     * @var string[]
     */
    public $PromotionVendorCode;
    /**
     * The AwardsPreference
     * @var string
     */
    public $AwardsPreference;
    /**
     * Constructor method for MemberPreferences
     * @uses MemberPreferences::setAdditionalReward()
     * @uses MemberPreferences::setOffer()
     * @uses MemberPreferences::setAwareness()
     * @uses MemberPreferences::setPromotionCode()
     * @uses MemberPreferences::setPromotionVendorCode()
     * @uses MemberPreferences::setAwardsPreference()
     * @param \StructType\AdditionalReward[] $additionalReward
     * @param \StructType\Offer[] $offer
     * @param string $awareness
     * @param string $promotionCode
     * @param string[] $promotionVendorCode
     * @param string $awardsPreference
     */
    public function __construct(array $additionalReward = array(), array $offer = array(), $awareness = null, $promotionCode = null, array $promotionVendorCode = array(), $awardsPreference = null)
    {
        $this
            ->setAdditionalReward($additionalReward)
            ->setOffer($offer)
            ->setAwareness($awareness)
            ->setPromotionCode($promotionCode)
            ->setPromotionVendorCode($promotionVendorCode)
            ->setAwardsPreference($awardsPreference);
    }
    /**
     * Get AdditionalReward value
     * @return \StructType\AdditionalReward[]|null
     */
    public function getAdditionalReward()
    {
        return $this->AdditionalReward;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalReward method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalReward method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalRewardForArrayConstraintsFromSetAdditionalReward(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $memberPreferencesAdditionalRewardItem) {
            // validation for constraint: itemType
            if (!$memberPreferencesAdditionalRewardItem instanceof \StructType\AdditionalReward) {
                $invalidValues[] = is_object($memberPreferencesAdditionalRewardItem) ? get_class($memberPreferencesAdditionalRewardItem) : sprintf('%s(%s)', gettype($memberPreferencesAdditionalRewardItem), var_export($memberPreferencesAdditionalRewardItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdditionalReward property can only contain items of type \StructType\AdditionalReward, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdditionalReward value
     * @throws \InvalidArgumentException
     * @param \StructType\AdditionalReward[] $additionalReward
     * @return \StructType\MemberPreferences
     */
    public function setAdditionalReward(array $additionalReward = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalRewardArrayErrorMessage = self::validateAdditionalRewardForArrayConstraintsFromSetAdditionalReward($additionalReward))) {
            throw new \InvalidArgumentException($additionalRewardArrayErrorMessage, __LINE__);
        }
        $this->AdditionalReward = $additionalReward;
        return $this;
    }
    /**
     * Add item to AdditionalReward value
     * @throws \InvalidArgumentException
     * @param \StructType\AdditionalReward $item
     * @return \StructType\MemberPreferences
     */
    public function addToAdditionalReward(\StructType\AdditionalReward $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AdditionalReward) {
            throw new \InvalidArgumentException(sprintf('The AdditionalReward property can only contain items of type \StructType\AdditionalReward, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AdditionalReward[] = $item;
        return $this;
    }
    /**
     * Get Offer value
     * @return \StructType\Offer[]|null
     */
    public function getOffer()
    {
        return $this->Offer;
    }
    /**
     * This method is responsible for validating the values passed to the setOffer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOffer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOfferForArrayConstraintsFromSetOffer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $memberPreferencesOfferItem) {
            // validation for constraint: itemType
            if (!$memberPreferencesOfferItem instanceof \StructType\Offer) {
                $invalidValues[] = is_object($memberPreferencesOfferItem) ? get_class($memberPreferencesOfferItem) : sprintf('%s(%s)', gettype($memberPreferencesOfferItem), var_export($memberPreferencesOfferItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Offer property can only contain items of type \StructType\Offer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Offer value
     * @throws \InvalidArgumentException
     * @param \StructType\Offer[] $offer
     * @return \StructType\MemberPreferences
     */
    public function setOffer(array $offer = array())
    {
        // validation for constraint: array
        if ('' !== ($offerArrayErrorMessage = self::validateOfferForArrayConstraintsFromSetOffer($offer))) {
            throw new \InvalidArgumentException($offerArrayErrorMessage, __LINE__);
        }
        $this->Offer = $offer;
        return $this;
    }
    /**
     * Add item to Offer value
     * @throws \InvalidArgumentException
     * @param \StructType\Offer $item
     * @return \StructType\MemberPreferences
     */
    public function addToOffer(\StructType\Offer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Offer) {
            throw new \InvalidArgumentException(sprintf('The Offer property can only contain items of type \StructType\Offer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Offer[] = $item;
        return $this;
    }
    /**
     * Get Awareness value
     * @return string|null
     */
    public function getAwareness()
    {
        return $this->Awareness;
    }
    /**
     * Set Awareness value
     * @param string $awareness
     * @return \StructType\MemberPreferences
     */
    public function setAwareness($awareness = null)
    {
        // validation for constraint: string
        if (!is_null($awareness) && !is_string($awareness)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($awareness, true), gettype($awareness)), __LINE__);
        }
        $this->Awareness = $awareness;
        return $this;
    }
    /**
     * Get PromotionCode value
     * @return string|null
     */
    public function getPromotionCode()
    {
        return $this->PromotionCode;
    }
    /**
     * Set PromotionCode value
     * @param string $promotionCode
     * @return \StructType\MemberPreferences
     */
    public function setPromotionCode($promotionCode = null)
    {
        // validation for constraint: string
        if (!is_null($promotionCode) && !is_string($promotionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promotionCode, true), gettype($promotionCode)), __LINE__);
        }
        $this->PromotionCode = $promotionCode;
        return $this;
    }
    /**
     * Get PromotionVendorCode value
     * @return string[]|null
     */
    public function getPromotionVendorCode()
    {
        return $this->PromotionVendorCode;
    }
    /**
     * This method is responsible for validating the values passed to the setPromotionVendorCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPromotionVendorCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePromotionVendorCodeForArrayConstraintsFromSetPromotionVendorCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $memberPreferencesPromotionVendorCodeItem) {
            // validation for constraint: itemType
            if (!is_string($memberPreferencesPromotionVendorCodeItem)) {
                $invalidValues[] = is_object($memberPreferencesPromotionVendorCodeItem) ? get_class($memberPreferencesPromotionVendorCodeItem) : sprintf('%s(%s)', gettype($memberPreferencesPromotionVendorCodeItem), var_export($memberPreferencesPromotionVendorCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PromotionVendorCode property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PromotionVendorCode value
     * @throws \InvalidArgumentException
     * @param string[] $promotionVendorCode
     * @return \StructType\MemberPreferences
     */
    public function setPromotionVendorCode(array $promotionVendorCode = array())
    {
        // validation for constraint: array
        if ('' !== ($promotionVendorCodeArrayErrorMessage = self::validatePromotionVendorCodeForArrayConstraintsFromSetPromotionVendorCode($promotionVendorCode))) {
            throw new \InvalidArgumentException($promotionVendorCodeArrayErrorMessage, __LINE__);
        }
        $this->PromotionVendorCode = $promotionVendorCode;
        return $this;
    }
    /**
     * Add item to PromotionVendorCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\MemberPreferences
     */
    public function addToPromotionVendorCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PromotionVendorCode property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PromotionVendorCode[] = $item;
        return $this;
    }
    /**
     * Get AwardsPreference value
     * @return string|null
     */
    public function getAwardsPreference()
    {
        return $this->AwardsPreference;
    }
    /**
     * Set AwardsPreference value
     * @param string $awardsPreference
     * @return \StructType\MemberPreferences
     */
    public function setAwardsPreference($awardsPreference = null)
    {
        // validation for constraint: string
        if (!is_null($awardsPreference) && !is_string($awardsPreference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($awardsPreference, true), gettype($awardsPreference)), __LINE__);
        }
        $this->AwardsPreference = $awardsPreference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MemberPreferences
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
