<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelDescriptiveInfos StructType
 * @subpackage Structs
 */
class HotelDescriptiveInfos extends AbstractStructBase
{
    /**
     * The HotelDescriptiveInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\HotelDescriptiveInfo[]
     */
    public $HotelDescriptiveInfo;
    /**
     * The LangRequested
     * @var string
     */
    public $LangRequested;
    /**
     * Constructor method for HotelDescriptiveInfos
     * @uses HotelDescriptiveInfos::setHotelDescriptiveInfo()
     * @uses HotelDescriptiveInfos::setLangRequested()
     * @param \StructType\HotelDescriptiveInfo[] $hotelDescriptiveInfo
     * @param string $langRequested
     */
    public function __construct(array $hotelDescriptiveInfo = array(), $langRequested = null)
    {
        $this
            ->setHotelDescriptiveInfo($hotelDescriptiveInfo)
            ->setLangRequested($langRequested);
    }
    /**
     * Get HotelDescriptiveInfo value
     * @return \StructType\HotelDescriptiveInfo[]|null
     */
    public function getHotelDescriptiveInfo()
    {
        return $this->HotelDescriptiveInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setHotelDescriptiveInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelDescriptiveInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelDescriptiveInfoForArrayConstraintsFromSetHotelDescriptiveInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelDescriptiveInfosHotelDescriptiveInfoItem) {
            // validation for constraint: itemType
            if (!$hotelDescriptiveInfosHotelDescriptiveInfoItem instanceof \StructType\HotelDescriptiveInfo) {
                $invalidValues[] = is_object($hotelDescriptiveInfosHotelDescriptiveInfoItem) ? get_class($hotelDescriptiveInfosHotelDescriptiveInfoItem) : sprintf('%s(%s)', gettype($hotelDescriptiveInfosHotelDescriptiveInfoItem), var_export($hotelDescriptiveInfosHotelDescriptiveInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HotelDescriptiveInfo property can only contain items of type \StructType\HotelDescriptiveInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HotelDescriptiveInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelDescriptiveInfo[] $hotelDescriptiveInfo
     * @return \StructType\HotelDescriptiveInfos
     */
    public function setHotelDescriptiveInfo(array $hotelDescriptiveInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelDescriptiveInfoArrayErrorMessage = self::validateHotelDescriptiveInfoForArrayConstraintsFromSetHotelDescriptiveInfo($hotelDescriptiveInfo))) {
            throw new \InvalidArgumentException($hotelDescriptiveInfoArrayErrorMessage, __LINE__);
        }
        $this->HotelDescriptiveInfo = $hotelDescriptiveInfo;
        return $this;
    }
    /**
     * Add item to HotelDescriptiveInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelDescriptiveInfo $item
     * @return \StructType\HotelDescriptiveInfos
     */
    public function addToHotelDescriptiveInfo(\StructType\HotelDescriptiveInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HotelDescriptiveInfo) {
            throw new \InvalidArgumentException(sprintf('The HotelDescriptiveInfo property can only contain items of type \StructType\HotelDescriptiveInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HotelDescriptiveInfo[] = $item;
        return $this;
    }
    /**
     * Get LangRequested value
     * @return string|null
     */
    public function getLangRequested()
    {
        return $this->LangRequested;
    }
    /**
     * Set LangRequested value
     * @param string $langRequested
     * @return \StructType\HotelDescriptiveInfos
     */
    public function setLangRequested($langRequested = null)
    {
        // validation for constraint: string
        if (!is_null($langRequested) && !is_string($langRequested)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($langRequested, true), gettype($langRequested)), __LINE__);
        }
        $this->LangRequested = $langRequested;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelDescriptiveInfos
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
