<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentType StructType
 * @subpackage Structs
 */
class DocumentType extends AbstractStructBase
{
    /**
     * The DocHolderFormattedName
     * Meta information extracted from the WSDL
     * - choice: DocHolderFormattedName | DocHolderName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PersonNameType
     */
    public $DocHolderFormattedName;
    /**
     * The DocHolderName
     * Meta information extracted from the WSDL
     * - choice: DocHolderFormattedName | DocHolderName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocHolderName;
    /**
     * The DocLimitations
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $DocLimitations;
    /**
     * The AdditionalPersonNames
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $AdditionalPersonNames;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DocumentType_TPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The DocIssueAuthority
     * @var string
     */
    public $DocIssueAuthority;
    /**
     * The DocIssueLocation
     * @var string
     */
    public $DocIssueLocation;
    /**
     * The DocID
     * @var string
     */
    public $DocID;
    /**
     * The DocType
     * @var string
     */
    public $DocType;
    /**
     * The Gender
     * @var string
     */
    public $Gender;
    /**
     * The BirthDate
     * @var string
     */
    public $BirthDate;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * The ExpireDateExclusiveInd
     * @var bool
     */
    public $ExpireDateExclusiveInd;
    /**
     * The DocIssueStateProv
     * @var string
     */
    public $DocIssueStateProv;
    /**
     * The DocIssueCountry
     * @var string
     */
    public $DocIssueCountry;
    /**
     * The BirthCountry
     * @var string
     */
    public $BirthCountry;
    /**
     * The BirthPlace
     * @var string
     */
    public $BirthPlace;
    /**
     * The DocHolderNationality
     * @var string
     */
    public $DocHolderNationality;
    /**
     * The ContactName
     * @var string
     */
    public $ContactName;
    /**
     * The HolderType
     * @var string
     */
    public $HolderType;
    /**
     * The Remark
     * @var string
     */
    public $Remark;
    /**
     * The PostalCode
     * @var string
     */
    public $PostalCode;
    /**
     * Constructor method for DocumentType
     * @uses DocumentType::setDocHolderFormattedName()
     * @uses DocumentType::setDocHolderName()
     * @uses DocumentType::setDocLimitations()
     * @uses DocumentType::setAdditionalPersonNames()
     * @uses DocumentType::setTPA_Extensions()
     * @uses DocumentType::setShareSynchInd()
     * @uses DocumentType::setShareMarketInd()
     * @uses DocumentType::setDocIssueAuthority()
     * @uses DocumentType::setDocIssueLocation()
     * @uses DocumentType::setDocID()
     * @uses DocumentType::setDocType()
     * @uses DocumentType::setGender()
     * @uses DocumentType::setBirthDate()
     * @uses DocumentType::setEffectiveDate()
     * @uses DocumentType::setExpireDate()
     * @uses DocumentType::setExpireDateExclusiveInd()
     * @uses DocumentType::setDocIssueStateProv()
     * @uses DocumentType::setDocIssueCountry()
     * @uses DocumentType::setBirthCountry()
     * @uses DocumentType::setBirthPlace()
     * @uses DocumentType::setDocHolderNationality()
     * @uses DocumentType::setContactName()
     * @uses DocumentType::setHolderType()
     * @uses DocumentType::setRemark()
     * @uses DocumentType::setPostalCode()
     * @param \StructType\PersonNameType $docHolderFormattedName
     * @param string $docHolderName
     * @param string[] $docLimitations
     * @param \ArrayType\ArrayOfString $additionalPersonNames
     * @param \StructType\DocumentType_TPA_ExtensionsType $tPA_Extensions
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $docIssueAuthority
     * @param string $docIssueLocation
     * @param string $docID
     * @param string $docType
     * @param string $gender
     * @param string $birthDate
     * @param string $effectiveDate
     * @param string $expireDate
     * @param bool $expireDateExclusiveInd
     * @param string $docIssueStateProv
     * @param string $docIssueCountry
     * @param string $birthCountry
     * @param string $birthPlace
     * @param string $docHolderNationality
     * @param string $contactName
     * @param string $holderType
     * @param string $remark
     * @param string $postalCode
     */
    public function __construct(\StructType\PersonNameType $docHolderFormattedName = null, $docHolderName = null, array $docLimitations = array(), \ArrayType\ArrayOfString $additionalPersonNames = null, \StructType\DocumentType_TPA_ExtensionsType $tPA_Extensions = null, $shareSynchInd = null, $shareMarketInd = null, $docIssueAuthority = null, $docIssueLocation = null, $docID = null, $docType = null, $gender = null, $birthDate = null, $effectiveDate = null, $expireDate = null, $expireDateExclusiveInd = null, $docIssueStateProv = null, $docIssueCountry = null, $birthCountry = null, $birthPlace = null, $docHolderNationality = null, $contactName = null, $holderType = null, $remark = null, $postalCode = null)
    {
        $this
            ->setDocHolderFormattedName($docHolderFormattedName)
            ->setDocHolderName($docHolderName)
            ->setDocLimitations($docLimitations)
            ->setAdditionalPersonNames($additionalPersonNames)
            ->setTPA_Extensions($tPA_Extensions)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setDocIssueAuthority($docIssueAuthority)
            ->setDocIssueLocation($docIssueLocation)
            ->setDocID($docID)
            ->setDocType($docType)
            ->setGender($gender)
            ->setBirthDate($birthDate)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setExpireDateExclusiveInd($expireDateExclusiveInd)
            ->setDocIssueStateProv($docIssueStateProv)
            ->setDocIssueCountry($docIssueCountry)
            ->setBirthCountry($birthCountry)
            ->setBirthPlace($birthPlace)
            ->setDocHolderNationality($docHolderNationality)
            ->setContactName($contactName)
            ->setHolderType($holderType)
            ->setRemark($remark)
            ->setPostalCode($postalCode);
    }
    /**
     * Get DocHolderFormattedName value
     * @return \StructType\PersonNameType|null
     */
    public function getDocHolderFormattedName()
    {
        return isset($this->DocHolderFormattedName) ? $this->DocHolderFormattedName : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDocHolderFormattedName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocHolderFormattedName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDocHolderFormattedNameForChoiceConstraintsFromSetDocHolderFormattedName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'DocHolderName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DocHolderFormattedName can\'t be set as the property %s is already set. Only one property must be set among these properties: DocHolderFormattedName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DocHolderFormattedName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PersonNameType $docHolderFormattedName
     * @return \StructType\DocumentType
     */
    public function setDocHolderFormattedName(\StructType\PersonNameType $docHolderFormattedName = null)
    {
        // validation for constraint: choice(DocHolderFormattedName, DocHolderName)
        if ('' !== ($docHolderFormattedNameChoiceErrorMessage = self::validateDocHolderFormattedNameForChoiceConstraintsFromSetDocHolderFormattedName($docHolderFormattedName))) {
            throw new \InvalidArgumentException($docHolderFormattedNameChoiceErrorMessage, __LINE__);
        }
        if (is_null($docHolderFormattedName) || (is_array($docHolderFormattedName) && empty($docHolderFormattedName))) {
            unset($this->DocHolderFormattedName);
        } else {
            $this->DocHolderFormattedName = $docHolderFormattedName;
        }
        return $this;
    }
    /**
     * Get DocHolderName value
     * @return string|null
     */
    public function getDocHolderName()
    {
        return isset($this->DocHolderName) ? $this->DocHolderName : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDocHolderName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocHolderName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDocHolderNameForChoiceConstraintsFromSetDocHolderName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'DocHolderFormattedName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DocHolderName can\'t be set as the property %s is already set. Only one property must be set among these properties: DocHolderName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DocHolderName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $docHolderName
     * @return \StructType\DocumentType
     */
    public function setDocHolderName($docHolderName = null)
    {
        // validation for constraint: string
        if (!is_null($docHolderName) && !is_string($docHolderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docHolderName, true), gettype($docHolderName)), __LINE__);
        }
        // validation for constraint: choice(DocHolderFormattedName, DocHolderName)
        if ('' !== ($docHolderNameChoiceErrorMessage = self::validateDocHolderNameForChoiceConstraintsFromSetDocHolderName($docHolderName))) {
            throw new \InvalidArgumentException($docHolderNameChoiceErrorMessage, __LINE__);
        }
        if (is_null($docHolderName) || (is_array($docHolderName) && empty($docHolderName))) {
            unset($this->DocHolderName);
        } else {
            $this->DocHolderName = $docHolderName;
        }
        return $this;
    }
    /**
     * Get DocLimitations value
     * @return string[]|null
     */
    public function getDocLimitations()
    {
        return $this->DocLimitations;
    }
    /**
     * This method is responsible for validating the values passed to the setDocLimitations method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocLimitations method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocLimitationsForArrayConstraintsFromSetDocLimitations(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $documentTypeDocLimitationsItem) {
            // validation for constraint: itemType
            if (!is_string($documentTypeDocLimitationsItem)) {
                $invalidValues[] = is_object($documentTypeDocLimitationsItem) ? get_class($documentTypeDocLimitationsItem) : sprintf('%s(%s)', gettype($documentTypeDocLimitationsItem), var_export($documentTypeDocLimitationsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DocLimitations property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DocLimitations value
     * @throws \InvalidArgumentException
     * @param string[] $docLimitations
     * @return \StructType\DocumentType
     */
    public function setDocLimitations(array $docLimitations = array())
    {
        // validation for constraint: array
        if ('' !== ($docLimitationsArrayErrorMessage = self::validateDocLimitationsForArrayConstraintsFromSetDocLimitations($docLimitations))) {
            throw new \InvalidArgumentException($docLimitationsArrayErrorMessage, __LINE__);
        }
        $this->DocLimitations = $docLimitations;
        return $this;
    }
    /**
     * Add item to DocLimitations value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\DocumentType
     */
    public function addToDocLimitations($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The DocLimitations property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DocLimitations[] = $item;
        return $this;
    }
    /**
     * Get AdditionalPersonNames value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getAdditionalPersonNames()
    {
        return $this->AdditionalPersonNames;
    }
    /**
     * Set AdditionalPersonNames value
     * @param \ArrayType\ArrayOfString $additionalPersonNames
     * @return \StructType\DocumentType
     */
    public function setAdditionalPersonNames(\ArrayType\ArrayOfString $additionalPersonNames = null)
    {
        $this->AdditionalPersonNames = $additionalPersonNames;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \StructType\DocumentType_TPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \StructType\DocumentType_TPA_ExtensionsType $tPA_Extensions
     * @return \StructType\DocumentType
     */
    public function setTPA_Extensions(\StructType\DocumentType_TPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \StructType\DocumentType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareSynchInd, true), gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \StructType\DocumentType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareMarketInd, true), gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get DocIssueAuthority value
     * @return string|null
     */
    public function getDocIssueAuthority()
    {
        return $this->DocIssueAuthority;
    }
    /**
     * Set DocIssueAuthority value
     * @param string $docIssueAuthority
     * @return \StructType\DocumentType
     */
    public function setDocIssueAuthority($docIssueAuthority = null)
    {
        // validation for constraint: string
        if (!is_null($docIssueAuthority) && !is_string($docIssueAuthority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docIssueAuthority, true), gettype($docIssueAuthority)), __LINE__);
        }
        $this->DocIssueAuthority = $docIssueAuthority;
        return $this;
    }
    /**
     * Get DocIssueLocation value
     * @return string|null
     */
    public function getDocIssueLocation()
    {
        return $this->DocIssueLocation;
    }
    /**
     * Set DocIssueLocation value
     * @param string $docIssueLocation
     * @return \StructType\DocumentType
     */
    public function setDocIssueLocation($docIssueLocation = null)
    {
        // validation for constraint: string
        if (!is_null($docIssueLocation) && !is_string($docIssueLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docIssueLocation, true), gettype($docIssueLocation)), __LINE__);
        }
        $this->DocIssueLocation = $docIssueLocation;
        return $this;
    }
    /**
     * Get DocID value
     * @return string|null
     */
    public function getDocID()
    {
        return $this->DocID;
    }
    /**
     * Set DocID value
     * @param string $docID
     * @return \StructType\DocumentType
     */
    public function setDocID($docID = null)
    {
        // validation for constraint: string
        if (!is_null($docID) && !is_string($docID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docID, true), gettype($docID)), __LINE__);
        }
        $this->DocID = $docID;
        return $this;
    }
    /**
     * Get DocType value
     * @return string|null
     */
    public function getDocType()
    {
        return $this->DocType;
    }
    /**
     * Set DocType value
     * @param string $docType
     * @return \StructType\DocumentType
     */
    public function setDocType($docType = null)
    {
        // validation for constraint: string
        if (!is_null($docType) && !is_string($docType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docType, true), gettype($docType)), __LINE__);
        }
        $this->DocType = $docType;
        return $this;
    }
    /**
     * Get Gender value
     * @return string|null
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @param string $gender
     * @return \StructType\DocumentType
     */
    public function setGender($gender = null)
    {
        // validation for constraint: string
        if (!is_null($gender) && !is_string($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gender, true), gettype($gender)), __LINE__);
        }
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \StructType\DocumentType
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthDate, true), gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\DocumentType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \StructType\DocumentType
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get ExpireDateExclusiveInd value
     * @return bool|null
     */
    public function getExpireDateExclusiveInd()
    {
        return $this->ExpireDateExclusiveInd;
    }
    /**
     * Set ExpireDateExclusiveInd value
     * @param bool $expireDateExclusiveInd
     * @return \StructType\DocumentType
     */
    public function setExpireDateExclusiveInd($expireDateExclusiveInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($expireDateExclusiveInd) && !is_bool($expireDateExclusiveInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($expireDateExclusiveInd, true), gettype($expireDateExclusiveInd)), __LINE__);
        }
        $this->ExpireDateExclusiveInd = $expireDateExclusiveInd;
        return $this;
    }
    /**
     * Get DocIssueStateProv value
     * @return string|null
     */
    public function getDocIssueStateProv()
    {
        return $this->DocIssueStateProv;
    }
    /**
     * Set DocIssueStateProv value
     * @param string $docIssueStateProv
     * @return \StructType\DocumentType
     */
    public function setDocIssueStateProv($docIssueStateProv = null)
    {
        // validation for constraint: string
        if (!is_null($docIssueStateProv) && !is_string($docIssueStateProv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docIssueStateProv, true), gettype($docIssueStateProv)), __LINE__);
        }
        $this->DocIssueStateProv = $docIssueStateProv;
        return $this;
    }
    /**
     * Get DocIssueCountry value
     * @return string|null
     */
    public function getDocIssueCountry()
    {
        return $this->DocIssueCountry;
    }
    /**
     * Set DocIssueCountry value
     * @param string $docIssueCountry
     * @return \StructType\DocumentType
     */
    public function setDocIssueCountry($docIssueCountry = null)
    {
        // validation for constraint: string
        if (!is_null($docIssueCountry) && !is_string($docIssueCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docIssueCountry, true), gettype($docIssueCountry)), __LINE__);
        }
        $this->DocIssueCountry = $docIssueCountry;
        return $this;
    }
    /**
     * Get BirthCountry value
     * @return string|null
     */
    public function getBirthCountry()
    {
        return $this->BirthCountry;
    }
    /**
     * Set BirthCountry value
     * @param string $birthCountry
     * @return \StructType\DocumentType
     */
    public function setBirthCountry($birthCountry = null)
    {
        // validation for constraint: string
        if (!is_null($birthCountry) && !is_string($birthCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthCountry, true), gettype($birthCountry)), __LINE__);
        }
        $this->BirthCountry = $birthCountry;
        return $this;
    }
    /**
     * Get BirthPlace value
     * @return string|null
     */
    public function getBirthPlace()
    {
        return $this->BirthPlace;
    }
    /**
     * Set BirthPlace value
     * @param string $birthPlace
     * @return \StructType\DocumentType
     */
    public function setBirthPlace($birthPlace = null)
    {
        // validation for constraint: string
        if (!is_null($birthPlace) && !is_string($birthPlace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthPlace, true), gettype($birthPlace)), __LINE__);
        }
        $this->BirthPlace = $birthPlace;
        return $this;
    }
    /**
     * Get DocHolderNationality value
     * @return string|null
     */
    public function getDocHolderNationality()
    {
        return $this->DocHolderNationality;
    }
    /**
     * Set DocHolderNationality value
     * @param string $docHolderNationality
     * @return \StructType\DocumentType
     */
    public function setDocHolderNationality($docHolderNationality = null)
    {
        // validation for constraint: string
        if (!is_null($docHolderNationality) && !is_string($docHolderNationality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docHolderNationality, true), gettype($docHolderNationality)), __LINE__);
        }
        $this->DocHolderNationality = $docHolderNationality;
        return $this;
    }
    /**
     * Get ContactName value
     * @return string|null
     */
    public function getContactName()
    {
        return $this->ContactName;
    }
    /**
     * Set ContactName value
     * @param string $contactName
     * @return \StructType\DocumentType
     */
    public function setContactName($contactName = null)
    {
        // validation for constraint: string
        if (!is_null($contactName) && !is_string($contactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactName, true), gettype($contactName)), __LINE__);
        }
        $this->ContactName = $contactName;
        return $this;
    }
    /**
     * Get HolderType value
     * @return string|null
     */
    public function getHolderType()
    {
        return $this->HolderType;
    }
    /**
     * Set HolderType value
     * @param string $holderType
     * @return \StructType\DocumentType
     */
    public function setHolderType($holderType = null)
    {
        // validation for constraint: string
        if (!is_null($holderType) && !is_string($holderType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($holderType, true), gettype($holderType)), __LINE__);
        }
        $this->HolderType = $holderType;
        return $this;
    }
    /**
     * Get Remark value
     * @return string|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * Set Remark value
     * @param string $remark
     * @return \StructType\DocumentType
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \StructType\DocumentType
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DocumentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
