<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerType StructType
 * @subpackage Structs
 */
class CustomerType extends AbstractStructBase
{
    /**
     * The Preferences
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCustomerPreferenceType
     */
    public $Preferences;
    /**
     * The Document
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DocumentType[]
     */
    public $Document;
    /**
     * The PersonName
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PersonNameType[]
     */
    public $PersonName;
    /**
     * The Telephone
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Telephone[]
     */
    public $Telephone;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Email[]
     */
    public $Email;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Address[]
     */
    public $Address;
    /**
     * The URL
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\URL[]
     */
    public $URL;
    /**
     * The CitizenCountryName
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CitizenCountryName[]
     */
    public $CitizenCountryName;
    /**
     * The PhysChallName
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PhysChallName[]
     */
    public $PhysChallName;
    /**
     * The PetInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PetInfo;
    /**
     * The PaymentForm
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaymentForm[]
     */
    public $PaymentForm;
    /**
     * The ContactPerson
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContactPersonType[]
     */
    public $ContactPerson;
    /**
     * The CustLoyalty
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustLoyalty[]
     */
    public $CustLoyalty;
    /**
     * The EmployeeInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EmployeeInfoType[]
     */
    public $EmployeeInfo;
    /**
     * The EmployerInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CompanyNameType
     */
    public $EmployerInfo;
    /**
     * The AdditionalLanguage
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AdditionalLanguage[]
     */
    public $AdditionalLanguage;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The Nation
     * @var string
     */
    public $Nation;
    /**
     * The Gender
     * @var string
     */
    public $Gender;
    /**
     * The Deceased
     * @var bool
     */
    public $Deceased;
    /**
     * The LockoutType
     * @var string
     */
    public $LockoutType;
    /**
     * The BirthDate
     * @var string
     */
    public $BirthDate;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * The VIP_Indicator
     * @var bool
     */
    public $VIP_Indicator;
    /**
     * The Text
     * @var string
     */
    public $Text;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * The CustomerValue
     * @var string
     */
    public $CustomerValue;
    /**
     * The MaritalStatus
     * @var string
     */
    public $MaritalStatus;
    /**
     * The PreviouslyMarriedIndicator
     * @var bool
     */
    public $PreviouslyMarriedIndicator;
    /**
     * The ChildQuantity
     * @var int
     */
    public $ChildQuantity;
    /**
     * Constructor method for CustomerType
     * @uses CustomerType::setPreferences()
     * @uses CustomerType::setDocument()
     * @uses CustomerType::setPersonName()
     * @uses CustomerType::setTelephone()
     * @uses CustomerType::setEmail()
     * @uses CustomerType::setAddress()
     * @uses CustomerType::setURL()
     * @uses CustomerType::setCitizenCountryName()
     * @uses CustomerType::setPhysChallName()
     * @uses CustomerType::setPetInfo()
     * @uses CustomerType::setPaymentForm()
     * @uses CustomerType::setContactPerson()
     * @uses CustomerType::setCustLoyalty()
     * @uses CustomerType::setEmployeeInfo()
     * @uses CustomerType::setEmployerInfo()
     * @uses CustomerType::setAdditionalLanguage()
     * @uses CustomerType::setTPA_Extensions()
     * @uses CustomerType::setNation()
     * @uses CustomerType::setGender()
     * @uses CustomerType::setDeceased()
     * @uses CustomerType::setLockoutType()
     * @uses CustomerType::setBirthDate()
     * @uses CustomerType::setCurrencyCode()
     * @uses CustomerType::setDecimalPlaces()
     * @uses CustomerType::setVIP_Indicator()
     * @uses CustomerType::setText()
     * @uses CustomerType::setLanguage()
     * @uses CustomerType::setCustomerValue()
     * @uses CustomerType::setMaritalStatus()
     * @uses CustomerType::setPreviouslyMarriedIndicator()
     * @uses CustomerType::setChildQuantity()
     * @param \ArrayType\ArrayOfCustomerPreferenceType $preferences
     * @param \StructType\DocumentType[] $document
     * @param \StructType\PersonNameType[] $personName
     * @param \StructType\Telephone[] $telephone
     * @param \StructType\Email[] $email
     * @param \StructType\Address[] $address
     * @param \StructType\URL[] $uRL
     * @param \StructType\CitizenCountryName[] $citizenCountryName
     * @param \StructType\PhysChallName[] $physChallName
     * @param string[] $petInfo
     * @param \StructType\PaymentForm[] $paymentForm
     * @param \StructType\ContactPersonType[] $contactPerson
     * @param \StructType\CustLoyalty[] $custLoyalty
     * @param \StructType\EmployeeInfoType[] $employeeInfo
     * @param \StructType\CompanyNameType $employerInfo
     * @param \StructType\AdditionalLanguage[] $additionalLanguage
     * @param \StructType\TPA_ExtensionsType $tPA_Extensions
     * @param string $nation
     * @param string $gender
     * @param bool $deceased
     * @param string $lockoutType
     * @param string $birthDate
     * @param string $currencyCode
     * @param int $decimalPlaces
     * @param bool $vIP_Indicator
     * @param string $text
     * @param string $language
     * @param string $customerValue
     * @param string $maritalStatus
     * @param bool $previouslyMarriedIndicator
     * @param int $childQuantity
     */
    public function __construct(\ArrayType\ArrayOfCustomerPreferenceType $preferences = null, array $document = array(), array $personName = array(), array $telephone = array(), array $email = array(), array $address = array(), array $uRL = array(), array $citizenCountryName = array(), array $physChallName = array(), array $petInfo = array(), array $paymentForm = array(), array $contactPerson = array(), array $custLoyalty = array(), array $employeeInfo = array(), \StructType\CompanyNameType $employerInfo = null, array $additionalLanguage = array(), \StructType\TPA_ExtensionsType $tPA_Extensions = null, $nation = null, $gender = null, $deceased = null, $lockoutType = null, $birthDate = null, $currencyCode = null, $decimalPlaces = null, $vIP_Indicator = null, $text = null, $language = null, $customerValue = null, $maritalStatus = null, $previouslyMarriedIndicator = null, $childQuantity = null)
    {
        $this
            ->setPreferences($preferences)
            ->setDocument($document)
            ->setPersonName($personName)
            ->setTelephone($telephone)
            ->setEmail($email)
            ->setAddress($address)
            ->setURL($uRL)
            ->setCitizenCountryName($citizenCountryName)
            ->setPhysChallName($physChallName)
            ->setPetInfo($petInfo)
            ->setPaymentForm($paymentForm)
            ->setContactPerson($contactPerson)
            ->setCustLoyalty($custLoyalty)
            ->setEmployeeInfo($employeeInfo)
            ->setEmployerInfo($employerInfo)
            ->setAdditionalLanguage($additionalLanguage)
            ->setTPA_Extensions($tPA_Extensions)
            ->setNation($nation)
            ->setGender($gender)
            ->setDeceased($deceased)
            ->setLockoutType($lockoutType)
            ->setBirthDate($birthDate)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces)
            ->setVIP_Indicator($vIP_Indicator)
            ->setText($text)
            ->setLanguage($language)
            ->setCustomerValue($customerValue)
            ->setMaritalStatus($maritalStatus)
            ->setPreviouslyMarriedIndicator($previouslyMarriedIndicator)
            ->setChildQuantity($childQuantity);
    }
    /**
     * Get Preferences value
     * @return \ArrayType\ArrayOfCustomerPreferenceType|null
     */
    public function getPreferences()
    {
        return $this->Preferences;
    }
    /**
     * Set Preferences value
     * @param \ArrayType\ArrayOfCustomerPreferenceType $preferences
     * @return \StructType\CustomerType
     */
    public function setPreferences(\ArrayType\ArrayOfCustomerPreferenceType $preferences = null)
    {
        $this->Preferences = $preferences;
        return $this;
    }
    /**
     * Get Document value
     * @return \StructType\DocumentType[]|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * This method is responsible for validating the values passed to the setDocument method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocument method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentForArrayConstraintsFromSetDocument(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypeDocumentItem) {
            // validation for constraint: itemType
            if (!$customerTypeDocumentItem instanceof \StructType\DocumentType) {
                $invalidValues[] = is_object($customerTypeDocumentItem) ? get_class($customerTypeDocumentItem) : sprintf('%s(%s)', gettype($customerTypeDocumentItem), var_export($customerTypeDocumentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Document property can only contain items of type \StructType\DocumentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Document value
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentType[] $document
     * @return \StructType\CustomerType
     */
    public function setDocument(array $document = array())
    {
        // validation for constraint: array
        if ('' !== ($documentArrayErrorMessage = self::validateDocumentForArrayConstraintsFromSetDocument($document))) {
            throw new \InvalidArgumentException($documentArrayErrorMessage, __LINE__);
        }
        $this->Document = $document;
        return $this;
    }
    /**
     * Add item to Document value
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentType $item
     * @return \StructType\CustomerType
     */
    public function addToDocument(\StructType\DocumentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DocumentType) {
            throw new \InvalidArgumentException(sprintf('The Document property can only contain items of type \StructType\DocumentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Document[] = $item;
        return $this;
    }
    /**
     * Get PersonName value
     * @return \StructType\PersonNameType[]|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * This method is responsible for validating the values passed to the setPersonName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPersonName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePersonNameForArrayConstraintsFromSetPersonName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypePersonNameItem) {
            // validation for constraint: itemType
            if (!$customerTypePersonNameItem instanceof \StructType\PersonNameType) {
                $invalidValues[] = is_object($customerTypePersonNameItem) ? get_class($customerTypePersonNameItem) : sprintf('%s(%s)', gettype($customerTypePersonNameItem), var_export($customerTypePersonNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PersonName property can only contain items of type \StructType\PersonNameType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PersonName value
     * @throws \InvalidArgumentException
     * @param \StructType\PersonNameType[] $personName
     * @return \StructType\CustomerType
     */
    public function setPersonName(array $personName = array())
    {
        // validation for constraint: array
        if ('' !== ($personNameArrayErrorMessage = self::validatePersonNameForArrayConstraintsFromSetPersonName($personName))) {
            throw new \InvalidArgumentException($personNameArrayErrorMessage, __LINE__);
        }
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Add item to PersonName value
     * @throws \InvalidArgumentException
     * @param \StructType\PersonNameType $item
     * @return \StructType\CustomerType
     */
    public function addToPersonName(\StructType\PersonNameType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PersonNameType) {
            throw new \InvalidArgumentException(sprintf('The PersonName property can only contain items of type \StructType\PersonNameType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PersonName[] = $item;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \StructType\Telephone[]|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * This method is responsible for validating the values passed to the setTelephone method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTelephone method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTelephoneForArrayConstraintsFromSetTelephone(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypeTelephoneItem) {
            // validation for constraint: itemType
            if (!$customerTypeTelephoneItem instanceof \StructType\Telephone) {
                $invalidValues[] = is_object($customerTypeTelephoneItem) ? get_class($customerTypeTelephoneItem) : sprintf('%s(%s)', gettype($customerTypeTelephoneItem), var_export($customerTypeTelephoneItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Telephone property can only contain items of type \StructType\Telephone, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Telephone value
     * @throws \InvalidArgumentException
     * @param \StructType\Telephone[] $telephone
     * @return \StructType\CustomerType
     */
    public function setTelephone(array $telephone = array())
    {
        // validation for constraint: array
        if ('' !== ($telephoneArrayErrorMessage = self::validateTelephoneForArrayConstraintsFromSetTelephone($telephone))) {
            throw new \InvalidArgumentException($telephoneArrayErrorMessage, __LINE__);
        }
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Add item to Telephone value
     * @throws \InvalidArgumentException
     * @param \StructType\Telephone $item
     * @return \StructType\CustomerType
     */
    public function addToTelephone(\StructType\Telephone $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Telephone) {
            throw new \InvalidArgumentException(sprintf('The Telephone property can only contain items of type \StructType\Telephone, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Telephone[] = $item;
        return $this;
    }
    /**
     * Get Email value
     * @return \StructType\Email[]|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * This method is responsible for validating the values passed to the setEmail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmailForArrayConstraintsFromSetEmail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypeEmailItem) {
            // validation for constraint: itemType
            if (!$customerTypeEmailItem instanceof \StructType\Email) {
                $invalidValues[] = is_object($customerTypeEmailItem) ? get_class($customerTypeEmailItem) : sprintf('%s(%s)', gettype($customerTypeEmailItem), var_export($customerTypeEmailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Email property can only contain items of type \StructType\Email, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Email value
     * @throws \InvalidArgumentException
     * @param \StructType\Email[] $email
     * @return \StructType\CustomerType
     */
    public function setEmail(array $email = array())
    {
        // validation for constraint: array
        if ('' !== ($emailArrayErrorMessage = self::validateEmailForArrayConstraintsFromSetEmail($email))) {
            throw new \InvalidArgumentException($emailArrayErrorMessage, __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Add item to Email value
     * @throws \InvalidArgumentException
     * @param \StructType\Email $item
     * @return \StructType\CustomerType
     */
    public function addToEmail(\StructType\Email $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Email) {
            throw new \InvalidArgumentException(sprintf('The Email property can only contain items of type \StructType\Email, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Email[] = $item;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\Address[]|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * This method is responsible for validating the values passed to the setAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressForArrayConstraintsFromSetAddress(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypeAddressItem) {
            // validation for constraint: itemType
            if (!$customerTypeAddressItem instanceof \StructType\Address) {
                $invalidValues[] = is_object($customerTypeAddressItem) ? get_class($customerTypeAddressItem) : sprintf('%s(%s)', gettype($customerTypeAddressItem), var_export($customerTypeAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Address property can only contain items of type \StructType\Address, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Address value
     * @throws \InvalidArgumentException
     * @param \StructType\Address[] $address
     * @return \StructType\CustomerType
     */
    public function setAddress(array $address = array())
    {
        // validation for constraint: array
        if ('' !== ($addressArrayErrorMessage = self::validateAddressForArrayConstraintsFromSetAddress($address))) {
            throw new \InvalidArgumentException($addressArrayErrorMessage, __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Add item to Address value
     * @throws \InvalidArgumentException
     * @param \StructType\Address $item
     * @return \StructType\CustomerType
     */
    public function addToAddress(\StructType\Address $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Address) {
            throw new \InvalidArgumentException(sprintf('The Address property can only contain items of type \StructType\Address, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Address[] = $item;
        return $this;
    }
    /**
     * Get URL value
     * @return \StructType\URL[]|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * This method is responsible for validating the values passed to the setURL method
     * This method is willingly generated in order to preserve the one-line inline validation within the setURL method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateURLForArrayConstraintsFromSetURL(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypeURLItem) {
            // validation for constraint: itemType
            if (!$customerTypeURLItem instanceof \StructType\URL) {
                $invalidValues[] = is_object($customerTypeURLItem) ? get_class($customerTypeURLItem) : sprintf('%s(%s)', gettype($customerTypeURLItem), var_export($customerTypeURLItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The URL property can only contain items of type \StructType\URL, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set URL value
     * @throws \InvalidArgumentException
     * @param \StructType\URL[] $uRL
     * @return \StructType\CustomerType
     */
    public function setURL(array $uRL = array())
    {
        // validation for constraint: array
        if ('' !== ($uRLArrayErrorMessage = self::validateURLForArrayConstraintsFromSetURL($uRL))) {
            throw new \InvalidArgumentException($uRLArrayErrorMessage, __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Add item to URL value
     * @throws \InvalidArgumentException
     * @param \StructType\URL $item
     * @return \StructType\CustomerType
     */
    public function addToURL(\StructType\URL $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\URL) {
            throw new \InvalidArgumentException(sprintf('The URL property can only contain items of type \StructType\URL, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->URL[] = $item;
        return $this;
    }
    /**
     * Get CitizenCountryName value
     * @return \StructType\CitizenCountryName[]|null
     */
    public function getCitizenCountryName()
    {
        return $this->CitizenCountryName;
    }
    /**
     * This method is responsible for validating the values passed to the setCitizenCountryName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCitizenCountryName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCitizenCountryNameForArrayConstraintsFromSetCitizenCountryName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypeCitizenCountryNameItem) {
            // validation for constraint: itemType
            if (!$customerTypeCitizenCountryNameItem instanceof \StructType\CitizenCountryName) {
                $invalidValues[] = is_object($customerTypeCitizenCountryNameItem) ? get_class($customerTypeCitizenCountryNameItem) : sprintf('%s(%s)', gettype($customerTypeCitizenCountryNameItem), var_export($customerTypeCitizenCountryNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CitizenCountryName property can only contain items of type \StructType\CitizenCountryName, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CitizenCountryName value
     * @throws \InvalidArgumentException
     * @param \StructType\CitizenCountryName[] $citizenCountryName
     * @return \StructType\CustomerType
     */
    public function setCitizenCountryName(array $citizenCountryName = array())
    {
        // validation for constraint: array
        if ('' !== ($citizenCountryNameArrayErrorMessage = self::validateCitizenCountryNameForArrayConstraintsFromSetCitizenCountryName($citizenCountryName))) {
            throw new \InvalidArgumentException($citizenCountryNameArrayErrorMessage, __LINE__);
        }
        $this->CitizenCountryName = $citizenCountryName;
        return $this;
    }
    /**
     * Add item to CitizenCountryName value
     * @throws \InvalidArgumentException
     * @param \StructType\CitizenCountryName $item
     * @return \StructType\CustomerType
     */
    public function addToCitizenCountryName(\StructType\CitizenCountryName $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CitizenCountryName) {
            throw new \InvalidArgumentException(sprintf('The CitizenCountryName property can only contain items of type \StructType\CitizenCountryName, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CitizenCountryName[] = $item;
        return $this;
    }
    /**
     * Get PhysChallName value
     * @return \StructType\PhysChallName[]|null
     */
    public function getPhysChallName()
    {
        return $this->PhysChallName;
    }
    /**
     * This method is responsible for validating the values passed to the setPhysChallName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPhysChallName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePhysChallNameForArrayConstraintsFromSetPhysChallName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypePhysChallNameItem) {
            // validation for constraint: itemType
            if (!$customerTypePhysChallNameItem instanceof \StructType\PhysChallName) {
                $invalidValues[] = is_object($customerTypePhysChallNameItem) ? get_class($customerTypePhysChallNameItem) : sprintf('%s(%s)', gettype($customerTypePhysChallNameItem), var_export($customerTypePhysChallNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PhysChallName property can only contain items of type \StructType\PhysChallName, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PhysChallName value
     * @throws \InvalidArgumentException
     * @param \StructType\PhysChallName[] $physChallName
     * @return \StructType\CustomerType
     */
    public function setPhysChallName(array $physChallName = array())
    {
        // validation for constraint: array
        if ('' !== ($physChallNameArrayErrorMessage = self::validatePhysChallNameForArrayConstraintsFromSetPhysChallName($physChallName))) {
            throw new \InvalidArgumentException($physChallNameArrayErrorMessage, __LINE__);
        }
        $this->PhysChallName = $physChallName;
        return $this;
    }
    /**
     * Add item to PhysChallName value
     * @throws \InvalidArgumentException
     * @param \StructType\PhysChallName $item
     * @return \StructType\CustomerType
     */
    public function addToPhysChallName(\StructType\PhysChallName $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PhysChallName) {
            throw new \InvalidArgumentException(sprintf('The PhysChallName property can only contain items of type \StructType\PhysChallName, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PhysChallName[] = $item;
        return $this;
    }
    /**
     * Get PetInfo value
     * @return string[]|null
     */
    public function getPetInfo()
    {
        return $this->PetInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setPetInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPetInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePetInfoForArrayConstraintsFromSetPetInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypePetInfoItem) {
            // validation for constraint: itemType
            if (!is_string($customerTypePetInfoItem)) {
                $invalidValues[] = is_object($customerTypePetInfoItem) ? get_class($customerTypePetInfoItem) : sprintf('%s(%s)', gettype($customerTypePetInfoItem), var_export($customerTypePetInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PetInfo property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PetInfo value
     * @throws \InvalidArgumentException
     * @param string[] $petInfo
     * @return \StructType\CustomerType
     */
    public function setPetInfo(array $petInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($petInfoArrayErrorMessage = self::validatePetInfoForArrayConstraintsFromSetPetInfo($petInfo))) {
            throw new \InvalidArgumentException($petInfoArrayErrorMessage, __LINE__);
        }
        $this->PetInfo = $petInfo;
        return $this;
    }
    /**
     * Add item to PetInfo value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\CustomerType
     */
    public function addToPetInfo($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PetInfo property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PetInfo[] = $item;
        return $this;
    }
    /**
     * Get PaymentForm value
     * @return \StructType\PaymentForm[]|null
     */
    public function getPaymentForm()
    {
        return $this->PaymentForm;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentForm method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentForm method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentFormForArrayConstraintsFromSetPaymentForm(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypePaymentFormItem) {
            // validation for constraint: itemType
            if (!$customerTypePaymentFormItem instanceof \StructType\PaymentForm) {
                $invalidValues[] = is_object($customerTypePaymentFormItem) ? get_class($customerTypePaymentFormItem) : sprintf('%s(%s)', gettype($customerTypePaymentFormItem), var_export($customerTypePaymentFormItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentForm property can only contain items of type \StructType\PaymentForm, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentForm value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentForm[] $paymentForm
     * @return \StructType\CustomerType
     */
    public function setPaymentForm(array $paymentForm = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentFormArrayErrorMessage = self::validatePaymentFormForArrayConstraintsFromSetPaymentForm($paymentForm))) {
            throw new \InvalidArgumentException($paymentFormArrayErrorMessage, __LINE__);
        }
        $this->PaymentForm = $paymentForm;
        return $this;
    }
    /**
     * Add item to PaymentForm value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentForm $item
     * @return \StructType\CustomerType
     */
    public function addToPaymentForm(\StructType\PaymentForm $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentForm) {
            throw new \InvalidArgumentException(sprintf('The PaymentForm property can only contain items of type \StructType\PaymentForm, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentForm[] = $item;
        return $this;
    }
    /**
     * Get ContactPerson value
     * @return \StructType\ContactPersonType[]|null
     */
    public function getContactPerson()
    {
        return $this->ContactPerson;
    }
    /**
     * This method is responsible for validating the values passed to the setContactPerson method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContactPerson method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactPersonForArrayConstraintsFromSetContactPerson(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypeContactPersonItem) {
            // validation for constraint: itemType
            if (!$customerTypeContactPersonItem instanceof \StructType\ContactPersonType) {
                $invalidValues[] = is_object($customerTypeContactPersonItem) ? get_class($customerTypeContactPersonItem) : sprintf('%s(%s)', gettype($customerTypeContactPersonItem), var_export($customerTypeContactPersonItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContactPerson property can only contain items of type \StructType\ContactPersonType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContactPerson value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactPersonType[] $contactPerson
     * @return \StructType\CustomerType
     */
    public function setContactPerson(array $contactPerson = array())
    {
        // validation for constraint: array
        if ('' !== ($contactPersonArrayErrorMessage = self::validateContactPersonForArrayConstraintsFromSetContactPerson($contactPerson))) {
            throw new \InvalidArgumentException($contactPersonArrayErrorMessage, __LINE__);
        }
        $this->ContactPerson = $contactPerson;
        return $this;
    }
    /**
     * Add item to ContactPerson value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactPersonType $item
     * @return \StructType\CustomerType
     */
    public function addToContactPerson(\StructType\ContactPersonType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactPersonType) {
            throw new \InvalidArgumentException(sprintf('The ContactPerson property can only contain items of type \StructType\ContactPersonType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContactPerson[] = $item;
        return $this;
    }
    /**
     * Get CustLoyalty value
     * @return \StructType\CustLoyalty[]|null
     */
    public function getCustLoyalty()
    {
        return $this->CustLoyalty;
    }
    /**
     * This method is responsible for validating the values passed to the setCustLoyalty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustLoyalty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustLoyaltyForArrayConstraintsFromSetCustLoyalty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypeCustLoyaltyItem) {
            // validation for constraint: itemType
            if (!$customerTypeCustLoyaltyItem instanceof \StructType\CustLoyalty) {
                $invalidValues[] = is_object($customerTypeCustLoyaltyItem) ? get_class($customerTypeCustLoyaltyItem) : sprintf('%s(%s)', gettype($customerTypeCustLoyaltyItem), var_export($customerTypeCustLoyaltyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustLoyalty property can only contain items of type \StructType\CustLoyalty, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \StructType\CustLoyalty[] $custLoyalty
     * @return \StructType\CustomerType
     */
    public function setCustLoyalty(array $custLoyalty = array())
    {
        // validation for constraint: array
        if ('' !== ($custLoyaltyArrayErrorMessage = self::validateCustLoyaltyForArrayConstraintsFromSetCustLoyalty($custLoyalty))) {
            throw new \InvalidArgumentException($custLoyaltyArrayErrorMessage, __LINE__);
        }
        $this->CustLoyalty = $custLoyalty;
        return $this;
    }
    /**
     * Add item to CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \StructType\CustLoyalty $item
     * @return \StructType\CustomerType
     */
    public function addToCustLoyalty(\StructType\CustLoyalty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustLoyalty) {
            throw new \InvalidArgumentException(sprintf('The CustLoyalty property can only contain items of type \StructType\CustLoyalty, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustLoyalty[] = $item;
        return $this;
    }
    /**
     * Get EmployeeInfo value
     * @return \StructType\EmployeeInfoType[]|null
     */
    public function getEmployeeInfo()
    {
        return $this->EmployeeInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setEmployeeInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmployeeInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmployeeInfoForArrayConstraintsFromSetEmployeeInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypeEmployeeInfoItem) {
            // validation for constraint: itemType
            if (!$customerTypeEmployeeInfoItem instanceof \StructType\EmployeeInfoType) {
                $invalidValues[] = is_object($customerTypeEmployeeInfoItem) ? get_class($customerTypeEmployeeInfoItem) : sprintf('%s(%s)', gettype($customerTypeEmployeeInfoItem), var_export($customerTypeEmployeeInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EmployeeInfo property can only contain items of type \StructType\EmployeeInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EmployeeInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\EmployeeInfoType[] $employeeInfo
     * @return \StructType\CustomerType
     */
    public function setEmployeeInfo(array $employeeInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($employeeInfoArrayErrorMessage = self::validateEmployeeInfoForArrayConstraintsFromSetEmployeeInfo($employeeInfo))) {
            throw new \InvalidArgumentException($employeeInfoArrayErrorMessage, __LINE__);
        }
        $this->EmployeeInfo = $employeeInfo;
        return $this;
    }
    /**
     * Add item to EmployeeInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\EmployeeInfoType $item
     * @return \StructType\CustomerType
     */
    public function addToEmployeeInfo(\StructType\EmployeeInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EmployeeInfoType) {
            throw new \InvalidArgumentException(sprintf('The EmployeeInfo property can only contain items of type \StructType\EmployeeInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EmployeeInfo[] = $item;
        return $this;
    }
    /**
     * Get EmployerInfo value
     * @return \StructType\CompanyNameType|null
     */
    public function getEmployerInfo()
    {
        return $this->EmployerInfo;
    }
    /**
     * Set EmployerInfo value
     * @param \StructType\CompanyNameType $employerInfo
     * @return \StructType\CustomerType
     */
    public function setEmployerInfo(\StructType\CompanyNameType $employerInfo = null)
    {
        $this->EmployerInfo = $employerInfo;
        return $this;
    }
    /**
     * Get AdditionalLanguage value
     * @return \StructType\AdditionalLanguage[]|null
     */
    public function getAdditionalLanguage()
    {
        return $this->AdditionalLanguage;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalLanguage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalLanguage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalLanguageForArrayConstraintsFromSetAdditionalLanguage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypeAdditionalLanguageItem) {
            // validation for constraint: itemType
            if (!$customerTypeAdditionalLanguageItem instanceof \StructType\AdditionalLanguage) {
                $invalidValues[] = is_object($customerTypeAdditionalLanguageItem) ? get_class($customerTypeAdditionalLanguageItem) : sprintf('%s(%s)', gettype($customerTypeAdditionalLanguageItem), var_export($customerTypeAdditionalLanguageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdditionalLanguage property can only contain items of type \StructType\AdditionalLanguage, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdditionalLanguage value
     * @throws \InvalidArgumentException
     * @param \StructType\AdditionalLanguage[] $additionalLanguage
     * @return \StructType\CustomerType
     */
    public function setAdditionalLanguage(array $additionalLanguage = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalLanguageArrayErrorMessage = self::validateAdditionalLanguageForArrayConstraintsFromSetAdditionalLanguage($additionalLanguage))) {
            throw new \InvalidArgumentException($additionalLanguageArrayErrorMessage, __LINE__);
        }
        $this->AdditionalLanguage = $additionalLanguage;
        return $this;
    }
    /**
     * Add item to AdditionalLanguage value
     * @throws \InvalidArgumentException
     * @param \StructType\AdditionalLanguage $item
     * @return \StructType\CustomerType
     */
    public function addToAdditionalLanguage(\StructType\AdditionalLanguage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AdditionalLanguage) {
            throw new \InvalidArgumentException(sprintf('The AdditionalLanguage property can only contain items of type \StructType\AdditionalLanguage, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AdditionalLanguage[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \StructType\TPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \StructType\TPA_ExtensionsType $tPA_Extensions
     * @return \StructType\CustomerType
     */
    public function setTPA_Extensions(\StructType\TPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get Nation value
     * @return string|null
     */
    public function getNation()
    {
        return $this->Nation;
    }
    /**
     * Set Nation value
     * @param string $nation
     * @return \StructType\CustomerType
     */
    public function setNation($nation = null)
    {
        // validation for constraint: string
        if (!is_null($nation) && !is_string($nation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nation, true), gettype($nation)), __LINE__);
        }
        $this->Nation = $nation;
        return $this;
    }
    /**
     * Get Gender value
     * @return string|null
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @param string $gender
     * @return \StructType\CustomerType
     */
    public function setGender($gender = null)
    {
        // validation for constraint: string
        if (!is_null($gender) && !is_string($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gender, true), gettype($gender)), __LINE__);
        }
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get Deceased value
     * @return bool|null
     */
    public function getDeceased()
    {
        return $this->Deceased;
    }
    /**
     * Set Deceased value
     * @param bool $deceased
     * @return \StructType\CustomerType
     */
    public function setDeceased($deceased = null)
    {
        // validation for constraint: boolean
        if (!is_null($deceased) && !is_bool($deceased)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($deceased, true), gettype($deceased)), __LINE__);
        }
        $this->Deceased = $deceased;
        return $this;
    }
    /**
     * Get LockoutType value
     * @return string|null
     */
    public function getLockoutType()
    {
        return $this->LockoutType;
    }
    /**
     * Set LockoutType value
     * @param string $lockoutType
     * @return \StructType\CustomerType
     */
    public function setLockoutType($lockoutType = null)
    {
        // validation for constraint: string
        if (!is_null($lockoutType) && !is_string($lockoutType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lockoutType, true), gettype($lockoutType)), __LINE__);
        }
        $this->LockoutType = $lockoutType;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \StructType\CustomerType
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthDate, true), gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\CustomerType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \StructType\CustomerType
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !(is_int($decimalPlaces) || ctype_digit($decimalPlaces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($decimalPlaces, true), gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Get VIP_Indicator value
     * @return bool|null
     */
    public function getVIP_Indicator()
    {
        return $this->VIP_Indicator;
    }
    /**
     * Set VIP_Indicator value
     * @param bool $vIP_Indicator
     * @return \StructType\CustomerType
     */
    public function setVIP_Indicator($vIP_Indicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($vIP_Indicator) && !is_bool($vIP_Indicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vIP_Indicator, true), gettype($vIP_Indicator)), __LINE__);
        }
        $this->VIP_Indicator = $vIP_Indicator;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \StructType\CustomerType
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\CustomerType
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get CustomerValue value
     * @return string|null
     */
    public function getCustomerValue()
    {
        return $this->CustomerValue;
    }
    /**
     * Set CustomerValue value
     * @param string $customerValue
     * @return \StructType\CustomerType
     */
    public function setCustomerValue($customerValue = null)
    {
        // validation for constraint: string
        if (!is_null($customerValue) && !is_string($customerValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerValue, true), gettype($customerValue)), __LINE__);
        }
        $this->CustomerValue = $customerValue;
        return $this;
    }
    /**
     * Get MaritalStatus value
     * @return string|null
     */
    public function getMaritalStatus()
    {
        return $this->MaritalStatus;
    }
    /**
     * Set MaritalStatus value
     * @param string $maritalStatus
     * @return \StructType\CustomerType
     */
    public function setMaritalStatus($maritalStatus = null)
    {
        // validation for constraint: string
        if (!is_null($maritalStatus) && !is_string($maritalStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maritalStatus, true), gettype($maritalStatus)), __LINE__);
        }
        $this->MaritalStatus = $maritalStatus;
        return $this;
    }
    /**
     * Get PreviouslyMarriedIndicator value
     * @return bool|null
     */
    public function getPreviouslyMarriedIndicator()
    {
        return $this->PreviouslyMarriedIndicator;
    }
    /**
     * Set PreviouslyMarriedIndicator value
     * @param bool $previouslyMarriedIndicator
     * @return \StructType\CustomerType
     */
    public function setPreviouslyMarriedIndicator($previouslyMarriedIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($previouslyMarriedIndicator) && !is_bool($previouslyMarriedIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($previouslyMarriedIndicator, true), gettype($previouslyMarriedIndicator)), __LINE__);
        }
        $this->PreviouslyMarriedIndicator = $previouslyMarriedIndicator;
        return $this;
    }
    /**
     * Get ChildQuantity value
     * @return int|null
     */
    public function getChildQuantity()
    {
        return $this->ChildQuantity;
    }
    /**
     * Set ChildQuantity value
     * @param int $childQuantity
     * @return \StructType\CustomerType
     */
    public function setChildQuantity($childQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($childQuantity) && !(is_int($childQuantity) || ctype_digit($childQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($childQuantity, true), gettype($childQuantity)), __LINE__);
        }
        $this->ChildQuantity = $childQuantity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomerType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
