<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustLoyalty StructType
 * @subpackage Structs
 */
class CustLoyalty extends AbstractStructBase
{
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The ProgramID
     * @var string
     */
    public $ProgramID;
    /**
     * The MembershipID
     * @var string
     */
    public $MembershipID;
    /**
     * The TravelSector
     * @var string
     */
    public $TravelSector;
    /**
     * The VendorCode
     * @var string[]
     */
    public $VendorCode;
    /**
     * The PrimaryLoyaltyIndicator
     * @var bool
     */
    public $PrimaryLoyaltyIndicator;
    /**
     * The AllianceLoyaltyLevelName
     * @var string
     */
    public $AllianceLoyaltyLevelName;
    /**
     * The CustomerType
     * @var string
     */
    public $CustomerType;
    /**
     * The CustomerValue
     * @var string
     */
    public $CustomerValue;
    /**
     * The Password
     * @var string
     */
    public $Password;
    /**
     * The LoyalLevel
     * @var string
     */
    public $LoyalLevel;
    /**
     * The LoyalLevelCode
     * @var int
     */
    public $LoyalLevelCode;
    /**
     * The SingleVendorInd
     * @var string
     */
    public $SingleVendorInd;
    /**
     * The SignupDate
     * @var string
     */
    public $SignupDate;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * The ExpireDateExclusiveIndicator
     * @var bool
     */
    public $ExpireDateExclusiveIndicator;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * The MemberPreferences
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MemberPreferences
     */
    public $MemberPreferences;
    /**
     * The SecurityInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SecurityInfo
     */
    public $SecurityInfo;
    /**
     * The SubAccountBalance
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SubAccountBalance[]
     */
    public $SubAccountBalance;
    /**
     * The Remark
     * @var string
     */
    public $Remark;
    /**
     * Constructor method for CustLoyalty
     * @uses CustLoyalty::setShareSynchInd()
     * @uses CustLoyalty::setShareMarketInd()
     * @uses CustLoyalty::setProgramID()
     * @uses CustLoyalty::setMembershipID()
     * @uses CustLoyalty::setTravelSector()
     * @uses CustLoyalty::setVendorCode()
     * @uses CustLoyalty::setPrimaryLoyaltyIndicator()
     * @uses CustLoyalty::setAllianceLoyaltyLevelName()
     * @uses CustLoyalty::setCustomerType()
     * @uses CustLoyalty::setCustomerValue()
     * @uses CustLoyalty::setPassword()
     * @uses CustLoyalty::setLoyalLevel()
     * @uses CustLoyalty::setLoyalLevelCode()
     * @uses CustLoyalty::setSingleVendorInd()
     * @uses CustLoyalty::setSignupDate()
     * @uses CustLoyalty::setEffectiveDate()
     * @uses CustLoyalty::setExpireDate()
     * @uses CustLoyalty::setExpireDateExclusiveIndicator()
     * @uses CustLoyalty::setRPH()
     * @uses CustLoyalty::setMemberPreferences()
     * @uses CustLoyalty::setSecurityInfo()
     * @uses CustLoyalty::setSubAccountBalance()
     * @uses CustLoyalty::setRemark()
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $programID
     * @param string $membershipID
     * @param string $travelSector
     * @param string[] $vendorCode
     * @param bool $primaryLoyaltyIndicator
     * @param string $allianceLoyaltyLevelName
     * @param string $customerType
     * @param string $customerValue
     * @param string $password
     * @param string $loyalLevel
     * @param int $loyalLevelCode
     * @param string $singleVendorInd
     * @param string $signupDate
     * @param string $effectiveDate
     * @param string $expireDate
     * @param bool $expireDateExclusiveIndicator
     * @param string $rPH
     * @param \StructType\MemberPreferences $memberPreferences
     * @param \StructType\SecurityInfo $securityInfo
     * @param \StructType\SubAccountBalance[] $subAccountBalance
     * @param string $remark
     */
    public function __construct($shareSynchInd = null, $shareMarketInd = null, $programID = null, $membershipID = null, $travelSector = null, array $vendorCode = array(), $primaryLoyaltyIndicator = null, $allianceLoyaltyLevelName = null, $customerType = null, $customerValue = null, $password = null, $loyalLevel = null, $loyalLevelCode = null, $singleVendorInd = null, $signupDate = null, $effectiveDate = null, $expireDate = null, $expireDateExclusiveIndicator = null, $rPH = null, \StructType\MemberPreferences $memberPreferences = null, \StructType\SecurityInfo $securityInfo = null, array $subAccountBalance = array(), $remark = null)
    {
        $this
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setProgramID($programID)
            ->setMembershipID($membershipID)
            ->setTravelSector($travelSector)
            ->setVendorCode($vendorCode)
            ->setPrimaryLoyaltyIndicator($primaryLoyaltyIndicator)
            ->setAllianceLoyaltyLevelName($allianceLoyaltyLevelName)
            ->setCustomerType($customerType)
            ->setCustomerValue($customerValue)
            ->setPassword($password)
            ->setLoyalLevel($loyalLevel)
            ->setLoyalLevelCode($loyalLevelCode)
            ->setSingleVendorInd($singleVendorInd)
            ->setSignupDate($signupDate)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setExpireDateExclusiveIndicator($expireDateExclusiveIndicator)
            ->setRPH($rPH)
            ->setMemberPreferences($memberPreferences)
            ->setSecurityInfo($securityInfo)
            ->setSubAccountBalance($subAccountBalance)
            ->setRemark($remark);
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \StructType\CustLoyalty
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareSynchInd, true), gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \StructType\CustLoyalty
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareMarketInd, true), gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get ProgramID value
     * @return string|null
     */
    public function getProgramID()
    {
        return $this->ProgramID;
    }
    /**
     * Set ProgramID value
     * @param string $programID
     * @return \StructType\CustLoyalty
     */
    public function setProgramID($programID = null)
    {
        // validation for constraint: string
        if (!is_null($programID) && !is_string($programID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($programID, true), gettype($programID)), __LINE__);
        }
        $this->ProgramID = $programID;
        return $this;
    }
    /**
     * Get MembershipID value
     * @return string|null
     */
    public function getMembershipID()
    {
        return $this->MembershipID;
    }
    /**
     * Set MembershipID value
     * @param string $membershipID
     * @return \StructType\CustLoyalty
     */
    public function setMembershipID($membershipID = null)
    {
        // validation for constraint: string
        if (!is_null($membershipID) && !is_string($membershipID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipID, true), gettype($membershipID)), __LINE__);
        }
        $this->MembershipID = $membershipID;
        return $this;
    }
    /**
     * Get TravelSector value
     * @return string|null
     */
    public function getTravelSector()
    {
        return $this->TravelSector;
    }
    /**
     * Set TravelSector value
     * @param string $travelSector
     * @return \StructType\CustLoyalty
     */
    public function setTravelSector($travelSector = null)
    {
        // validation for constraint: string
        if (!is_null($travelSector) && !is_string($travelSector)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travelSector, true), gettype($travelSector)), __LINE__);
        }
        $this->TravelSector = $travelSector;
        return $this;
    }
    /**
     * Get VendorCode value
     * @return string[]|null
     */
    public function getVendorCode()
    {
        return $this->VendorCode;
    }
    /**
     * This method is responsible for validating the values passed to the setVendorCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVendorCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVendorCodeForArrayConstraintsFromSetVendorCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $custLoyaltyVendorCodeItem) {
            // validation for constraint: itemType
            if (!is_string($custLoyaltyVendorCodeItem)) {
                $invalidValues[] = is_object($custLoyaltyVendorCodeItem) ? get_class($custLoyaltyVendorCodeItem) : sprintf('%s(%s)', gettype($custLoyaltyVendorCodeItem), var_export($custLoyaltyVendorCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VendorCode property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VendorCode value
     * @throws \InvalidArgumentException
     * @param string[] $vendorCode
     * @return \StructType\CustLoyalty
     */
    public function setVendorCode(array $vendorCode = array())
    {
        // validation for constraint: array
        if ('' !== ($vendorCodeArrayErrorMessage = self::validateVendorCodeForArrayConstraintsFromSetVendorCode($vendorCode))) {
            throw new \InvalidArgumentException($vendorCodeArrayErrorMessage, __LINE__);
        }
        $this->VendorCode = $vendorCode;
        return $this;
    }
    /**
     * Add item to VendorCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\CustLoyalty
     */
    public function addToVendorCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The VendorCode property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->VendorCode[] = $item;
        return $this;
    }
    /**
     * Get PrimaryLoyaltyIndicator value
     * @return bool|null
     */
    public function getPrimaryLoyaltyIndicator()
    {
        return $this->PrimaryLoyaltyIndicator;
    }
    /**
     * Set PrimaryLoyaltyIndicator value
     * @param bool $primaryLoyaltyIndicator
     * @return \StructType\CustLoyalty
     */
    public function setPrimaryLoyaltyIndicator($primaryLoyaltyIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($primaryLoyaltyIndicator) && !is_bool($primaryLoyaltyIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($primaryLoyaltyIndicator, true), gettype($primaryLoyaltyIndicator)), __LINE__);
        }
        $this->PrimaryLoyaltyIndicator = $primaryLoyaltyIndicator;
        return $this;
    }
    /**
     * Get AllianceLoyaltyLevelName value
     * @return string|null
     */
    public function getAllianceLoyaltyLevelName()
    {
        return $this->AllianceLoyaltyLevelName;
    }
    /**
     * Set AllianceLoyaltyLevelName value
     * @param string $allianceLoyaltyLevelName
     * @return \StructType\CustLoyalty
     */
    public function setAllianceLoyaltyLevelName($allianceLoyaltyLevelName = null)
    {
        // validation for constraint: string
        if (!is_null($allianceLoyaltyLevelName) && !is_string($allianceLoyaltyLevelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allianceLoyaltyLevelName, true), gettype($allianceLoyaltyLevelName)), __LINE__);
        }
        $this->AllianceLoyaltyLevelName = $allianceLoyaltyLevelName;
        return $this;
    }
    /**
     * Get CustomerType value
     * @return string|null
     */
    public function getCustomerType()
    {
        return $this->CustomerType;
    }
    /**
     * Set CustomerType value
     * @param string $customerType
     * @return \StructType\CustLoyalty
     */
    public function setCustomerType($customerType = null)
    {
        // validation for constraint: string
        if (!is_null($customerType) && !is_string($customerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerType, true), gettype($customerType)), __LINE__);
        }
        $this->CustomerType = $customerType;
        return $this;
    }
    /**
     * Get CustomerValue value
     * @return string|null
     */
    public function getCustomerValue()
    {
        return $this->CustomerValue;
    }
    /**
     * Set CustomerValue value
     * @param string $customerValue
     * @return \StructType\CustLoyalty
     */
    public function setCustomerValue($customerValue = null)
    {
        // validation for constraint: string
        if (!is_null($customerValue) && !is_string($customerValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerValue, true), gettype($customerValue)), __LINE__);
        }
        $this->CustomerValue = $customerValue;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\CustLoyalty
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get LoyalLevel value
     * @return string|null
     */
    public function getLoyalLevel()
    {
        return $this->LoyalLevel;
    }
    /**
     * Set LoyalLevel value
     * @param string $loyalLevel
     * @return \StructType\CustLoyalty
     */
    public function setLoyalLevel($loyalLevel = null)
    {
        // validation for constraint: string
        if (!is_null($loyalLevel) && !is_string($loyalLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loyalLevel, true), gettype($loyalLevel)), __LINE__);
        }
        $this->LoyalLevel = $loyalLevel;
        return $this;
    }
    /**
     * Get LoyalLevelCode value
     * @return int|null
     */
    public function getLoyalLevelCode()
    {
        return $this->LoyalLevelCode;
    }
    /**
     * Set LoyalLevelCode value
     * @param int $loyalLevelCode
     * @return \StructType\CustLoyalty
     */
    public function setLoyalLevelCode($loyalLevelCode = null)
    {
        // validation for constraint: int
        if (!is_null($loyalLevelCode) && !(is_int($loyalLevelCode) || ctype_digit($loyalLevelCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($loyalLevelCode, true), gettype($loyalLevelCode)), __LINE__);
        }
        $this->LoyalLevelCode = $loyalLevelCode;
        return $this;
    }
    /**
     * Get SingleVendorInd value
     * @return string|null
     */
    public function getSingleVendorInd()
    {
        return $this->SingleVendorInd;
    }
    /**
     * Set SingleVendorInd value
     * @param string $singleVendorInd
     * @return \StructType\CustLoyalty
     */
    public function setSingleVendorInd($singleVendorInd = null)
    {
        // validation for constraint: string
        if (!is_null($singleVendorInd) && !is_string($singleVendorInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($singleVendorInd, true), gettype($singleVendorInd)), __LINE__);
        }
        $this->SingleVendorInd = $singleVendorInd;
        return $this;
    }
    /**
     * Get SignupDate value
     * @return string|null
     */
    public function getSignupDate()
    {
        return $this->SignupDate;
    }
    /**
     * Set SignupDate value
     * @param string $signupDate
     * @return \StructType\CustLoyalty
     */
    public function setSignupDate($signupDate = null)
    {
        // validation for constraint: string
        if (!is_null($signupDate) && !is_string($signupDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signupDate, true), gettype($signupDate)), __LINE__);
        }
        $this->SignupDate = $signupDate;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\CustLoyalty
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \StructType\CustLoyalty
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get ExpireDateExclusiveIndicator value
     * @return bool|null
     */
    public function getExpireDateExclusiveIndicator()
    {
        return $this->ExpireDateExclusiveIndicator;
    }
    /**
     * Set ExpireDateExclusiveIndicator value
     * @param bool $expireDateExclusiveIndicator
     * @return \StructType\CustLoyalty
     */
    public function setExpireDateExclusiveIndicator($expireDateExclusiveIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($expireDateExclusiveIndicator) && !is_bool($expireDateExclusiveIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($expireDateExclusiveIndicator, true), gettype($expireDateExclusiveIndicator)), __LINE__);
        }
        $this->ExpireDateExclusiveIndicator = $expireDateExclusiveIndicator;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\CustLoyalty
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get MemberPreferences value
     * @return \StructType\MemberPreferences|null
     */
    public function getMemberPreferences()
    {
        return $this->MemberPreferences;
    }
    /**
     * Set MemberPreferences value
     * @param \StructType\MemberPreferences $memberPreferences
     * @return \StructType\CustLoyalty
     */
    public function setMemberPreferences(\StructType\MemberPreferences $memberPreferences = null)
    {
        $this->MemberPreferences = $memberPreferences;
        return $this;
    }
    /**
     * Get SecurityInfo value
     * @return \StructType\SecurityInfo|null
     */
    public function getSecurityInfo()
    {
        return $this->SecurityInfo;
    }
    /**
     * Set SecurityInfo value
     * @param \StructType\SecurityInfo $securityInfo
     * @return \StructType\CustLoyalty
     */
    public function setSecurityInfo(\StructType\SecurityInfo $securityInfo = null)
    {
        $this->SecurityInfo = $securityInfo;
        return $this;
    }
    /**
     * Get SubAccountBalance value
     * @return \StructType\SubAccountBalance[]|null
     */
    public function getSubAccountBalance()
    {
        return $this->SubAccountBalance;
    }
    /**
     * This method is responsible for validating the values passed to the setSubAccountBalance method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubAccountBalance method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubAccountBalanceForArrayConstraintsFromSetSubAccountBalance(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $custLoyaltySubAccountBalanceItem) {
            // validation for constraint: itemType
            if (!$custLoyaltySubAccountBalanceItem instanceof \StructType\SubAccountBalance) {
                $invalidValues[] = is_object($custLoyaltySubAccountBalanceItem) ? get_class($custLoyaltySubAccountBalanceItem) : sprintf('%s(%s)', gettype($custLoyaltySubAccountBalanceItem), var_export($custLoyaltySubAccountBalanceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SubAccountBalance property can only contain items of type \StructType\SubAccountBalance, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SubAccountBalance value
     * @throws \InvalidArgumentException
     * @param \StructType\SubAccountBalance[] $subAccountBalance
     * @return \StructType\CustLoyalty
     */
    public function setSubAccountBalance(array $subAccountBalance = array())
    {
        // validation for constraint: array
        if ('' !== ($subAccountBalanceArrayErrorMessage = self::validateSubAccountBalanceForArrayConstraintsFromSetSubAccountBalance($subAccountBalance))) {
            throw new \InvalidArgumentException($subAccountBalanceArrayErrorMessage, __LINE__);
        }
        $this->SubAccountBalance = $subAccountBalance;
        return $this;
    }
    /**
     * Add item to SubAccountBalance value
     * @throws \InvalidArgumentException
     * @param \StructType\SubAccountBalance $item
     * @return \StructType\CustLoyalty
     */
    public function addToSubAccountBalance(\StructType\SubAccountBalance $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SubAccountBalance) {
            throw new \InvalidArgumentException(sprintf('The SubAccountBalance property can only contain items of type \StructType\SubAccountBalance, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SubAccountBalance[] = $item;
        return $this;
    }
    /**
     * Get Remark value
     * @return string|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * Set Remark value
     * @param string $remark
     * @return \StructType\CustLoyalty
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustLoyalty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
