<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactInfoType StructType
 * @subpackage Structs
 */
class ContactInfoType extends AbstractStructBase
{
    /**
     * The Addresses
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAddressesTypeAddress
     */
    public $Addresses;
    /**
     * The Location
     * @var string
     */
    public $Location;
    /**
     * Constructor method for ContactInfoType
     * @uses ContactInfoType::setAddresses()
     * @uses ContactInfoType::setLocation()
     * @param \ArrayType\ArrayOfAddressesTypeAddress $addresses
     * @param string $location
     */
    public function __construct(\ArrayType\ArrayOfAddressesTypeAddress $addresses = null, $location = null)
    {
        $this
            ->setAddresses($addresses)
            ->setLocation($location);
    }
    /**
     * Get Addresses value
     * @return \ArrayType\ArrayOfAddressesTypeAddress|null
     */
    public function getAddresses()
    {
        return $this->Addresses;
    }
    /**
     * Set Addresses value
     * @param \ArrayType\ArrayOfAddressesTypeAddress $addresses
     * @return \StructType\ContactInfoType
     */
    public function setAddresses(\ArrayType\ArrayOfAddressesTypeAddress $addresses = null)
    {
        $this->Addresses = $addresses;
        return $this;
    }
    /**
     * Get Location value
     * @return string|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param string $location
     * @return \StructType\ContactInfoType
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($location, true), gettype($location)), __LINE__);
        }
        $this->Location = $location;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ContactInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
