<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConjunctionTicketNbr StructType
 * @subpackage Structs
 */
class ConjunctionTicketNbr extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The Coupons
     * @var string[]
     */
    public $Coupons;
    /**
     * Constructor method for ConjunctionTicketNbr
     * @uses ConjunctionTicketNbr::set_()
     * @uses ConjunctionTicketNbr::setCoupons()
     * @param string $_
     * @param string[] $coupons
     */
    public function __construct($_ = null, array $coupons = array())
    {
        $this
            ->set_($_)
            ->setCoupons($coupons);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\ConjunctionTicketNbr
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get Coupons value
     * @return string[]|null
     */
    public function getCoupons()
    {
        return $this->Coupons;
    }
    /**
     * This method is responsible for validating the values passed to the setCoupons method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCoupons method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCouponsForArrayConstraintsFromSetCoupons(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $conjunctionTicketNbrCouponsItem) {
            // validation for constraint: itemType
            if (!is_string($conjunctionTicketNbrCouponsItem)) {
                $invalidValues[] = is_object($conjunctionTicketNbrCouponsItem) ? get_class($conjunctionTicketNbrCouponsItem) : sprintf('%s(%s)', gettype($conjunctionTicketNbrCouponsItem), var_export($conjunctionTicketNbrCouponsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Coupons property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Coupons value
     * @throws \InvalidArgumentException
     * @param string[] $coupons
     * @return \StructType\ConjunctionTicketNbr
     */
    public function setCoupons(array $coupons = array())
    {
        // validation for constraint: array
        if ('' !== ($couponsArrayErrorMessage = self::validateCouponsForArrayConstraintsFromSetCoupons($coupons))) {
            throw new \InvalidArgumentException($couponsArrayErrorMessage, __LINE__);
        }
        $this->Coupons = $coupons;
        return $this;
    }
    /**
     * Add item to Coupons value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ConjunctionTicketNbr
     */
    public function addToCoupons($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Coupons property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Coupons[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConjunctionTicketNbr
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
