<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressType StructType
 * @subpackage Structs
 */
class AddressType extends AbstractStructBase
{
    /**
     * The StreetNmbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StreetNmbr
     */
    public $StreetNmbr;
    /**
     * The BldgRoom
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BldgRoom[]
     */
    public $BldgRoom;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddressType_TPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The AddressLine
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $AddressLine;
    /**
     * The CityName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CityName;
    /**
     * The PostalCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostalCode;
    /**
     * The County
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $County;
    /**
     * The StateProv
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StateProvType
     */
    public $StateProv;
    /**
     * The CountryName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CountryNameType
     */
    public $CountryName;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * Constructor method for AddressType
     * @uses AddressType::setStreetNmbr()
     * @uses AddressType::setBldgRoom()
     * @uses AddressType::setTPA_Extensions()
     * @uses AddressType::setAddressLine()
     * @uses AddressType::setCityName()
     * @uses AddressType::setPostalCode()
     * @uses AddressType::setCounty()
     * @uses AddressType::setStateProv()
     * @uses AddressType::setCountryName()
     * @uses AddressType::setType()
     * @param \StructType\StreetNmbr $streetNmbr
     * @param \StructType\BldgRoom[] $bldgRoom
     * @param \StructType\AddressType_TPA_ExtensionsType $tPA_Extensions
     * @param string[] $addressLine
     * @param string $cityName
     * @param string $postalCode
     * @param string $county
     * @param \StructType\StateProvType $stateProv
     * @param \StructType\CountryNameType $countryName
     * @param string $type
     */
    public function __construct(\StructType\StreetNmbr $streetNmbr = null, array $bldgRoom = array(), \StructType\AddressType_TPA_ExtensionsType $tPA_Extensions = null, array $addressLine = array(), $cityName = null, $postalCode = null, $county = null, \StructType\StateProvType $stateProv = null, \StructType\CountryNameType $countryName = null, $type = null)
    {
        $this
            ->setStreetNmbr($streetNmbr)
            ->setBldgRoom($bldgRoom)
            ->setTPA_Extensions($tPA_Extensions)
            ->setAddressLine($addressLine)
            ->setCityName($cityName)
            ->setPostalCode($postalCode)
            ->setCounty($county)
            ->setStateProv($stateProv)
            ->setCountryName($countryName)
            ->setType($type);
    }
    /**
     * Get StreetNmbr value
     * @return \StructType\StreetNmbr|null
     */
    public function getStreetNmbr()
    {
        return $this->StreetNmbr;
    }
    /**
     * Set StreetNmbr value
     * @param \StructType\StreetNmbr $streetNmbr
     * @return \StructType\AddressType
     */
    public function setStreetNmbr(\StructType\StreetNmbr $streetNmbr = null)
    {
        $this->StreetNmbr = $streetNmbr;
        return $this;
    }
    /**
     * Get BldgRoom value
     * @return \StructType\BldgRoom[]|null
     */
    public function getBldgRoom()
    {
        return $this->BldgRoom;
    }
    /**
     * This method is responsible for validating the values passed to the setBldgRoom method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBldgRoom method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBldgRoomForArrayConstraintsFromSetBldgRoom(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $addressTypeBldgRoomItem) {
            // validation for constraint: itemType
            if (!$addressTypeBldgRoomItem instanceof \StructType\BldgRoom) {
                $invalidValues[] = is_object($addressTypeBldgRoomItem) ? get_class($addressTypeBldgRoomItem) : sprintf('%s(%s)', gettype($addressTypeBldgRoomItem), var_export($addressTypeBldgRoomItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BldgRoom property can only contain items of type \StructType\BldgRoom, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BldgRoom value
     * @throws \InvalidArgumentException
     * @param \StructType\BldgRoom[] $bldgRoom
     * @return \StructType\AddressType
     */
    public function setBldgRoom(array $bldgRoom = array())
    {
        // validation for constraint: array
        if ('' !== ($bldgRoomArrayErrorMessage = self::validateBldgRoomForArrayConstraintsFromSetBldgRoom($bldgRoom))) {
            throw new \InvalidArgumentException($bldgRoomArrayErrorMessage, __LINE__);
        }
        $this->BldgRoom = $bldgRoom;
        return $this;
    }
    /**
     * Add item to BldgRoom value
     * @throws \InvalidArgumentException
     * @param \StructType\BldgRoom $item
     * @return \StructType\AddressType
     */
    public function addToBldgRoom(\StructType\BldgRoom $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BldgRoom) {
            throw new \InvalidArgumentException(sprintf('The BldgRoom property can only contain items of type \StructType\BldgRoom, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BldgRoom[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \StructType\AddressType_TPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \StructType\AddressType_TPA_ExtensionsType $tPA_Extensions
     * @return \StructType\AddressType
     */
    public function setTPA_Extensions(\StructType\AddressType_TPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get AddressLine value
     * @return string[]|null
     */
    public function getAddressLine()
    {
        return $this->AddressLine;
    }
    /**
     * This method is responsible for validating the values passed to the setAddressLine method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddressLine method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressLineForArrayConstraintsFromSetAddressLine(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $addressTypeAddressLineItem) {
            // validation for constraint: itemType
            if (!is_string($addressTypeAddressLineItem)) {
                $invalidValues[] = is_object($addressTypeAddressLineItem) ? get_class($addressTypeAddressLineItem) : sprintf('%s(%s)', gettype($addressTypeAddressLineItem), var_export($addressTypeAddressLineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AddressLine property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AddressLine value
     * @throws \InvalidArgumentException
     * @param string[] $addressLine
     * @return \StructType\AddressType
     */
    public function setAddressLine(array $addressLine = array())
    {
        // validation for constraint: array
        if ('' !== ($addressLineArrayErrorMessage = self::validateAddressLineForArrayConstraintsFromSetAddressLine($addressLine))) {
            throw new \InvalidArgumentException($addressLineArrayErrorMessage, __LINE__);
        }
        $this->AddressLine = $addressLine;
        return $this;
    }
    /**
     * Add item to AddressLine value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\AddressType
     */
    public function addToAddressLine($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The AddressLine property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AddressLine[] = $item;
        return $this;
    }
    /**
     * Get CityName value
     * @return string|null
     */
    public function getCityName()
    {
        return $this->CityName;
    }
    /**
     * Set CityName value
     * @param string $cityName
     * @return \StructType\AddressType
     */
    public function setCityName($cityName = null)
    {
        // validation for constraint: string
        if (!is_null($cityName) && !is_string($cityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityName, true), gettype($cityName)), __LINE__);
        }
        $this->CityName = $cityName;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \StructType\AddressType
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get County value
     * @return string|null
     */
    public function getCounty()
    {
        return $this->County;
    }
    /**
     * Set County value
     * @param string $county
     * @return \StructType\AddressType
     */
    public function setCounty($county = null)
    {
        // validation for constraint: string
        if (!is_null($county) && !is_string($county)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($county, true), gettype($county)), __LINE__);
        }
        $this->County = $county;
        return $this;
    }
    /**
     * Get StateProv value
     * @return \StructType\StateProvType|null
     */
    public function getStateProv()
    {
        return $this->StateProv;
    }
    /**
     * Set StateProv value
     * @param \StructType\StateProvType $stateProv
     * @return \StructType\AddressType
     */
    public function setStateProv(\StructType\StateProvType $stateProv = null)
    {
        $this->StateProv = $stateProv;
        return $this;
    }
    /**
     * Get CountryName value
     * @return \StructType\CountryNameType|null
     */
    public function getCountryName()
    {
        return $this->CountryName;
    }
    /**
     * Set CountryName value
     * @param \StructType\CountryNameType $countryName
     * @return \StructType\AddressType
     */
    public function setCountryName(\StructType\CountryNameType $countryName = null)
    {
        $this->CountryName = $countryName;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\AddressType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddressType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
