<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Address StructType
 * @subpackage Structs
 */
class Address extends AddressInfoType
{
    /**
     * The AddresseeName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddresseeName;
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CompanyNameType
     */
    public $CompanyName;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * The ExpireDateExclusiveInd
     * @var bool
     */
    public $ExpireDateExclusiveInd;
    /**
     * The ValidationStatus
     * @var string
     */
    public $ValidationStatus;
    /**
     * The TransferAction
     * @var string
     */
    public $TransferAction;
    /**
     * The ParentCompanyRef
     * @var string
     */
    public $ParentCompanyRef;
    /**
     * Constructor method for Address
     * @uses Address::setAddresseeName()
     * @uses Address::setCompanyName()
     * @uses Address::setEffectiveDate()
     * @uses Address::setExpireDate()
     * @uses Address::setExpireDateExclusiveInd()
     * @uses Address::setValidationStatus()
     * @uses Address::setTransferAction()
     * @uses Address::setParentCompanyRef()
     * @param string $addresseeName
     * @param \StructType\CompanyNameType $companyName
     * @param string $effectiveDate
     * @param string $expireDate
     * @param bool $expireDateExclusiveInd
     * @param string $validationStatus
     * @param string $transferAction
     * @param string $parentCompanyRef
     */
    public function __construct($addresseeName = null, \StructType\CompanyNameType $companyName = null, $effectiveDate = null, $expireDate = null, $expireDateExclusiveInd = null, $validationStatus = null, $transferAction = null, $parentCompanyRef = null)
    {
        $this
            ->setAddresseeName($addresseeName)
            ->setCompanyName($companyName)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setExpireDateExclusiveInd($expireDateExclusiveInd)
            ->setValidationStatus($validationStatus)
            ->setTransferAction($transferAction)
            ->setParentCompanyRef($parentCompanyRef);
    }
    /**
     * Get AddresseeName value
     * @return string|null
     */
    public function getAddresseeName()
    {
        return $this->AddresseeName;
    }
    /**
     * Set AddresseeName value
     * @param string $addresseeName
     * @return \StructType\Address
     */
    public function setAddresseeName($addresseeName = null)
    {
        // validation for constraint: string
        if (!is_null($addresseeName) && !is_string($addresseeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addresseeName, true), gettype($addresseeName)), __LINE__);
        }
        $this->AddresseeName = $addresseeName;
        return $this;
    }
    /**
     * Get CompanyName value
     * @return \StructType\CompanyNameType|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param \StructType\CompanyNameType $companyName
     * @return \StructType\Address
     */
    public function setCompanyName(\StructType\CompanyNameType $companyName = null)
    {
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\Address
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \StructType\Address
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get ExpireDateExclusiveInd value
     * @return bool|null
     */
    public function getExpireDateExclusiveInd()
    {
        return $this->ExpireDateExclusiveInd;
    }
    /**
     * Set ExpireDateExclusiveInd value
     * @param bool $expireDateExclusiveInd
     * @return \StructType\Address
     */
    public function setExpireDateExclusiveInd($expireDateExclusiveInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($expireDateExclusiveInd) && !is_bool($expireDateExclusiveInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($expireDateExclusiveInd, true), gettype($expireDateExclusiveInd)), __LINE__);
        }
        $this->ExpireDateExclusiveInd = $expireDateExclusiveInd;
        return $this;
    }
    /**
     * Get ValidationStatus value
     * @return string|null
     */
    public function getValidationStatus()
    {
        return $this->ValidationStatus;
    }
    /**
     * Set ValidationStatus value
     * @param string $validationStatus
     * @return \StructType\Address
     */
    public function setValidationStatus($validationStatus = null)
    {
        // validation for constraint: string
        if (!is_null($validationStatus) && !is_string($validationStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validationStatus, true), gettype($validationStatus)), __LINE__);
        }
        $this->ValidationStatus = $validationStatus;
        return $this;
    }
    /**
     * Get TransferAction value
     * @return string|null
     */
    public function getTransferAction()
    {
        return $this->TransferAction;
    }
    /**
     * Set TransferAction value
     * @uses \EnumType\TransferActionType::valueIsValid()
     * @uses \EnumType\TransferActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transferAction
     * @return \StructType\Address
     */
    public function setTransferAction($transferAction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransferActionType::valueIsValid($transferAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TransferActionType', is_array($transferAction) ? implode(', ', $transferAction) : var_export($transferAction, true), implode(', ', \EnumType\TransferActionType::getValidValues())), __LINE__);
        }
        $this->TransferAction = $transferAction;
        return $this;
    }
    /**
     * Get ParentCompanyRef value
     * @return string|null
     */
    public function getParentCompanyRef()
    {
        return $this->ParentCompanyRef;
    }
    /**
     * Set ParentCompanyRef value
     * @param string $parentCompanyRef
     * @return \StructType\Address
     */
    public function setParentCompanyRef($parentCompanyRef = null)
    {
        // validation for constraint: string
        if (!is_null($parentCompanyRef) && !is_string($parentCompanyRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentCompanyRef, true), gettype($parentCompanyRef)), __LINE__);
        }
        $this->ParentCompanyRef = $parentCompanyRef;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Address
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
