<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalGuestAmount StructType
 * @subpackage Structs
 */
class AdditionalGuestAmount extends TotalType
{
    /**
     * The MaxAdditionalGuests
     * @var int
     */
    public $MaxAdditionalGuests;
    /**
     * The BedRequired
     * @var bool
     */
    public $BedRequired;
    /**
     * The AgeQualifyingCode
     * @var string
     */
    public $AgeQualifyingCode;
    /**
     * The MinAge
     * @var int
     */
    public $MinAge;
    /**
     * The MaxAge
     * @var int
     */
    public $MaxAge;
    /**
     * The AgeTimeUnit
     * @var string
     */
    public $AgeTimeUnit;
    /**
     * The AgeBucket
     * @var string
     */
    public $AgeBucket;
    /**
     * Constructor method for AdditionalGuestAmount
     * @uses AdditionalGuestAmount::setMaxAdditionalGuests()
     * @uses AdditionalGuestAmount::setBedRequired()
     * @uses AdditionalGuestAmount::setAgeQualifyingCode()
     * @uses AdditionalGuestAmount::setMinAge()
     * @uses AdditionalGuestAmount::setMaxAge()
     * @uses AdditionalGuestAmount::setAgeTimeUnit()
     * @uses AdditionalGuestAmount::setAgeBucket()
     * @param int $maxAdditionalGuests
     * @param bool $bedRequired
     * @param string $ageQualifyingCode
     * @param int $minAge
     * @param int $maxAge
     * @param string $ageTimeUnit
     * @param string $ageBucket
     */
    public function __construct($maxAdditionalGuests = null, $bedRequired = null, $ageQualifyingCode = null, $minAge = null, $maxAge = null, $ageTimeUnit = null, $ageBucket = null)
    {
        $this
            ->setMaxAdditionalGuests($maxAdditionalGuests)
            ->setBedRequired($bedRequired)
            ->setAgeQualifyingCode($ageQualifyingCode)
            ->setMinAge($minAge)
            ->setMaxAge($maxAge)
            ->setAgeTimeUnit($ageTimeUnit)
            ->setAgeBucket($ageBucket);
    }
    /**
     * Get MaxAdditionalGuests value
     * @return int|null
     */
    public function getMaxAdditionalGuests()
    {
        return $this->MaxAdditionalGuests;
    }
    /**
     * Set MaxAdditionalGuests value
     * @param int $maxAdditionalGuests
     * @return \StructType\AdditionalGuestAmount
     */
    public function setMaxAdditionalGuests($maxAdditionalGuests = null)
    {
        // validation for constraint: int
        if (!is_null($maxAdditionalGuests) && !(is_int($maxAdditionalGuests) || ctype_digit($maxAdditionalGuests))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxAdditionalGuests, true), gettype($maxAdditionalGuests)), __LINE__);
        }
        $this->MaxAdditionalGuests = $maxAdditionalGuests;
        return $this;
    }
    /**
     * Get BedRequired value
     * @return bool|null
     */
    public function getBedRequired()
    {
        return $this->BedRequired;
    }
    /**
     * Set BedRequired value
     * @param bool $bedRequired
     * @return \StructType\AdditionalGuestAmount
     */
    public function setBedRequired($bedRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($bedRequired) && !is_bool($bedRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bedRequired, true), gettype($bedRequired)), __LINE__);
        }
        $this->BedRequired = $bedRequired;
        return $this;
    }
    /**
     * Get AgeQualifyingCode value
     * @return string|null
     */
    public function getAgeQualifyingCode()
    {
        return $this->AgeQualifyingCode;
    }
    /**
     * Set AgeQualifyingCode value
     * @param string $ageQualifyingCode
     * @return \StructType\AdditionalGuestAmount
     */
    public function setAgeQualifyingCode($ageQualifyingCode = null)
    {
        // validation for constraint: string
        if (!is_null($ageQualifyingCode) && !is_string($ageQualifyingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ageQualifyingCode, true), gettype($ageQualifyingCode)), __LINE__);
        }
        $this->AgeQualifyingCode = $ageQualifyingCode;
        return $this;
    }
    /**
     * Get MinAge value
     * @return int|null
     */
    public function getMinAge()
    {
        return $this->MinAge;
    }
    /**
     * Set MinAge value
     * @param int $minAge
     * @return \StructType\AdditionalGuestAmount
     */
    public function setMinAge($minAge = null)
    {
        // validation for constraint: int
        if (!is_null($minAge) && !(is_int($minAge) || ctype_digit($minAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minAge, true), gettype($minAge)), __LINE__);
        }
        $this->MinAge = $minAge;
        return $this;
    }
    /**
     * Get MaxAge value
     * @return int|null
     */
    public function getMaxAge()
    {
        return $this->MaxAge;
    }
    /**
     * Set MaxAge value
     * @param int $maxAge
     * @return \StructType\AdditionalGuestAmount
     */
    public function setMaxAge($maxAge = null)
    {
        // validation for constraint: int
        if (!is_null($maxAge) && !(is_int($maxAge) || ctype_digit($maxAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxAge, true), gettype($maxAge)), __LINE__);
        }
        $this->MaxAge = $maxAge;
        return $this;
    }
    /**
     * Get AgeTimeUnit value
     * @return string|null
     */
    public function getAgeTimeUnit()
    {
        return $this->AgeTimeUnit;
    }
    /**
     * Set AgeTimeUnit value
     * @uses \EnumType\TimeUnitType::valueIsValid()
     * @uses \EnumType\TimeUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ageTimeUnit
     * @return \StructType\AdditionalGuestAmount
     */
    public function setAgeTimeUnit($ageTimeUnit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TimeUnitType::valueIsValid($ageTimeUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TimeUnitType', is_array($ageTimeUnit) ? implode(', ', $ageTimeUnit) : var_export($ageTimeUnit, true), implode(', ', \EnumType\TimeUnitType::getValidValues())), __LINE__);
        }
        $this->AgeTimeUnit = $ageTimeUnit;
        return $this;
    }
    /**
     * Get AgeBucket value
     * @return string|null
     */
    public function getAgeBucket()
    {
        return $this->AgeBucket;
    }
    /**
     * Set AgeBucket value
     * @param string $ageBucket
     * @return \StructType\AdditionalGuestAmount
     */
    public function setAgeBucket($ageBucket = null)
    {
        // validation for constraint: string
        if (!is_null($ageBucket) && !is_string($ageBucket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ageBucket, true), gettype($ageBucket)), __LINE__);
        }
        $this->AgeBucket = $ageBucket;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdditionalGuestAmount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
