<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticket StructType
 * @subpackage Structs
 */
class Ticket extends AbstractStructBase
{
    /**
     * The ConjunctionTicketNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ConjunctionTicketNbr[]
     */
    public $ConjunctionTicketNbr;
    /**
     * The TicketNumber
     * @var string
     */
    public $TicketNumber;
    /**
     * The OriginalTicketNumber
     * @var string
     */
    public $OriginalTicketNumber;
    /**
     * The OriginalIssuePlace
     * @var string
     */
    public $OriginalIssuePlace;
    /**
     * The OriginalIssueDate
     * @var string
     */
    public $OriginalIssueDate;
    /**
     * The OriginalIssueIATA
     * @var string
     */
    public $OriginalIssueIATA;
    /**
     * The OriginalPaymentForm
     * @var string
     */
    public $OriginalPaymentForm;
    /**
     * The CheckInhibitorType
     * @var string
     */
    public $CheckInhibitorType;
    /**
     * The CouponRPHs
     * @var string[]
     */
    public $CouponRPHs;
    /**
     * The ReroutingType
     * @var string
     */
    public $ReroutingType;
    /**
     * The ReasonForReroute
     * @var string
     */
    public $ReasonForReroute;
    /**
     * Constructor method for Ticket
     * @uses Ticket::setConjunctionTicketNbr()
     * @uses Ticket::setTicketNumber()
     * @uses Ticket::setOriginalTicketNumber()
     * @uses Ticket::setOriginalIssuePlace()
     * @uses Ticket::setOriginalIssueDate()
     * @uses Ticket::setOriginalIssueIATA()
     * @uses Ticket::setOriginalPaymentForm()
     * @uses Ticket::setCheckInhibitorType()
     * @uses Ticket::setCouponRPHs()
     * @uses Ticket::setReroutingType()
     * @uses Ticket::setReasonForReroute()
     * @param \StructType\ConjunctionTicketNbr[] $conjunctionTicketNbr
     * @param string $ticketNumber
     * @param string $originalTicketNumber
     * @param string $originalIssuePlace
     * @param string $originalIssueDate
     * @param string $originalIssueIATA
     * @param string $originalPaymentForm
     * @param string $checkInhibitorType
     * @param string[] $couponRPHs
     * @param string $reroutingType
     * @param string $reasonForReroute
     */
    public function __construct(array $conjunctionTicketNbr = array(), $ticketNumber = null, $originalTicketNumber = null, $originalIssuePlace = null, $originalIssueDate = null, $originalIssueIATA = null, $originalPaymentForm = null, $checkInhibitorType = null, array $couponRPHs = array(), $reroutingType = null, $reasonForReroute = null)
    {
        $this
            ->setConjunctionTicketNbr($conjunctionTicketNbr)
            ->setTicketNumber($ticketNumber)
            ->setOriginalTicketNumber($originalTicketNumber)
            ->setOriginalIssuePlace($originalIssuePlace)
            ->setOriginalIssueDate($originalIssueDate)
            ->setOriginalIssueIATA($originalIssueIATA)
            ->setOriginalPaymentForm($originalPaymentForm)
            ->setCheckInhibitorType($checkInhibitorType)
            ->setCouponRPHs($couponRPHs)
            ->setReroutingType($reroutingType)
            ->setReasonForReroute($reasonForReroute);
    }
    /**
     * Get ConjunctionTicketNbr value
     * @return \StructType\ConjunctionTicketNbr[]|null
     */
    public function getConjunctionTicketNbr()
    {
        return $this->ConjunctionTicketNbr;
    }
    /**
     * This method is responsible for validating the values passed to the setConjunctionTicketNbr method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConjunctionTicketNbr method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConjunctionTicketNbrForArrayConstraintsFromSetConjunctionTicketNbr(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ticketConjunctionTicketNbrItem) {
            // validation for constraint: itemType
            if (!$ticketConjunctionTicketNbrItem instanceof \StructType\ConjunctionTicketNbr) {
                $invalidValues[] = is_object($ticketConjunctionTicketNbrItem) ? get_class($ticketConjunctionTicketNbrItem) : sprintf('%s(%s)', gettype($ticketConjunctionTicketNbrItem), var_export($ticketConjunctionTicketNbrItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ConjunctionTicketNbr property can only contain items of type \StructType\ConjunctionTicketNbr, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ConjunctionTicketNbr value
     * @throws \InvalidArgumentException
     * @param \StructType\ConjunctionTicketNbr[] $conjunctionTicketNbr
     * @return \StructType\Ticket
     */
    public function setConjunctionTicketNbr(array $conjunctionTicketNbr = array())
    {
        // validation for constraint: array
        if ('' !== ($conjunctionTicketNbrArrayErrorMessage = self::validateConjunctionTicketNbrForArrayConstraintsFromSetConjunctionTicketNbr($conjunctionTicketNbr))) {
            throw new \InvalidArgumentException($conjunctionTicketNbrArrayErrorMessage, __LINE__);
        }
        $this->ConjunctionTicketNbr = $conjunctionTicketNbr;
        return $this;
    }
    /**
     * Add item to ConjunctionTicketNbr value
     * @throws \InvalidArgumentException
     * @param \StructType\ConjunctionTicketNbr $item
     * @return \StructType\Ticket
     */
    public function addToConjunctionTicketNbr(\StructType\ConjunctionTicketNbr $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ConjunctionTicketNbr) {
            throw new \InvalidArgumentException(sprintf('The ConjunctionTicketNbr property can only contain items of type \StructType\ConjunctionTicketNbr, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ConjunctionTicketNbr[] = $item;
        return $this;
    }
    /**
     * Get TicketNumber value
     * @return string|null
     */
    public function getTicketNumber()
    {
        return $this->TicketNumber;
    }
    /**
     * Set TicketNumber value
     * @param string $ticketNumber
     * @return \StructType\Ticket
     */
    public function setTicketNumber($ticketNumber = null)
    {
        // validation for constraint: string
        if (!is_null($ticketNumber) && !is_string($ticketNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketNumber, true), gettype($ticketNumber)), __LINE__);
        }
        $this->TicketNumber = $ticketNumber;
        return $this;
    }
    /**
     * Get OriginalTicketNumber value
     * @return string|null
     */
    public function getOriginalTicketNumber()
    {
        return $this->OriginalTicketNumber;
    }
    /**
     * Set OriginalTicketNumber value
     * @param string $originalTicketNumber
     * @return \StructType\Ticket
     */
    public function setOriginalTicketNumber($originalTicketNumber = null)
    {
        // validation for constraint: string
        if (!is_null($originalTicketNumber) && !is_string($originalTicketNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalTicketNumber, true), gettype($originalTicketNumber)), __LINE__);
        }
        $this->OriginalTicketNumber = $originalTicketNumber;
        return $this;
    }
    /**
     * Get OriginalIssuePlace value
     * @return string|null
     */
    public function getOriginalIssuePlace()
    {
        return $this->OriginalIssuePlace;
    }
    /**
     * Set OriginalIssuePlace value
     * @param string $originalIssuePlace
     * @return \StructType\Ticket
     */
    public function setOriginalIssuePlace($originalIssuePlace = null)
    {
        // validation for constraint: string
        if (!is_null($originalIssuePlace) && !is_string($originalIssuePlace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalIssuePlace, true), gettype($originalIssuePlace)), __LINE__);
        }
        $this->OriginalIssuePlace = $originalIssuePlace;
        return $this;
    }
    /**
     * Get OriginalIssueDate value
     * @return string|null
     */
    public function getOriginalIssueDate()
    {
        return $this->OriginalIssueDate;
    }
    /**
     * Set OriginalIssueDate value
     * @param string $originalIssueDate
     * @return \StructType\Ticket
     */
    public function setOriginalIssueDate($originalIssueDate = null)
    {
        // validation for constraint: string
        if (!is_null($originalIssueDate) && !is_string($originalIssueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalIssueDate, true), gettype($originalIssueDate)), __LINE__);
        }
        $this->OriginalIssueDate = $originalIssueDate;
        return $this;
    }
    /**
     * Get OriginalIssueIATA value
     * @return string|null
     */
    public function getOriginalIssueIATA()
    {
        return $this->OriginalIssueIATA;
    }
    /**
     * Set OriginalIssueIATA value
     * @param string $originalIssueIATA
     * @return \StructType\Ticket
     */
    public function setOriginalIssueIATA($originalIssueIATA = null)
    {
        // validation for constraint: string
        if (!is_null($originalIssueIATA) && !is_string($originalIssueIATA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalIssueIATA, true), gettype($originalIssueIATA)), __LINE__);
        }
        $this->OriginalIssueIATA = $originalIssueIATA;
        return $this;
    }
    /**
     * Get OriginalPaymentForm value
     * @return string|null
     */
    public function getOriginalPaymentForm()
    {
        return $this->OriginalPaymentForm;
    }
    /**
     * Set OriginalPaymentForm value
     * @param string $originalPaymentForm
     * @return \StructType\Ticket
     */
    public function setOriginalPaymentForm($originalPaymentForm = null)
    {
        // validation for constraint: string
        if (!is_null($originalPaymentForm) && !is_string($originalPaymentForm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalPaymentForm, true), gettype($originalPaymentForm)), __LINE__);
        }
        $this->OriginalPaymentForm = $originalPaymentForm;
        return $this;
    }
    /**
     * Get CheckInhibitorType value
     * @return string|null
     */
    public function getCheckInhibitorType()
    {
        return $this->CheckInhibitorType;
    }
    /**
     * Set CheckInhibitorType value
     * @param string $checkInhibitorType
     * @return \StructType\Ticket
     */
    public function setCheckInhibitorType($checkInhibitorType = null)
    {
        // validation for constraint: string
        if (!is_null($checkInhibitorType) && !is_string($checkInhibitorType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkInhibitorType, true), gettype($checkInhibitorType)), __LINE__);
        }
        $this->CheckInhibitorType = $checkInhibitorType;
        return $this;
    }
    /**
     * Get CouponRPHs value
     * @return string[]|null
     */
    public function getCouponRPHs()
    {
        return $this->CouponRPHs;
    }
    /**
     * This method is responsible for validating the values passed to the setCouponRPHs method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCouponRPHs method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCouponRPHsForArrayConstraintsFromSetCouponRPHs(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ticketCouponRPHsItem) {
            // validation for constraint: itemType
            if (!is_string($ticketCouponRPHsItem)) {
                $invalidValues[] = is_object($ticketCouponRPHsItem) ? get_class($ticketCouponRPHsItem) : sprintf('%s(%s)', gettype($ticketCouponRPHsItem), var_export($ticketCouponRPHsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CouponRPHs property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CouponRPHs value
     * @throws \InvalidArgumentException
     * @param string[] $couponRPHs
     * @return \StructType\Ticket
     */
    public function setCouponRPHs(array $couponRPHs = array())
    {
        // validation for constraint: array
        if ('' !== ($couponRPHsArrayErrorMessage = self::validateCouponRPHsForArrayConstraintsFromSetCouponRPHs($couponRPHs))) {
            throw new \InvalidArgumentException($couponRPHsArrayErrorMessage, __LINE__);
        }
        $this->CouponRPHs = $couponRPHs;
        return $this;
    }
    /**
     * Add item to CouponRPHs value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Ticket
     */
    public function addToCouponRPHs($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The CouponRPHs property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CouponRPHs[] = $item;
        return $this;
    }
    /**
     * Get ReroutingType value
     * @return string|null
     */
    public function getReroutingType()
    {
        return $this->ReroutingType;
    }
    /**
     * Set ReroutingType value
     * @param string $reroutingType
     * @return \StructType\Ticket
     */
    public function setReroutingType($reroutingType = null)
    {
        // validation for constraint: string
        if (!is_null($reroutingType) && !is_string($reroutingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reroutingType, true), gettype($reroutingType)), __LINE__);
        }
        $this->ReroutingType = $reroutingType;
        return $this;
    }
    /**
     * Get ReasonForReroute value
     * @return string|null
     */
    public function getReasonForReroute()
    {
        return $this->ReasonForReroute;
    }
    /**
     * Set ReasonForReroute value
     * @param string $reasonForReroute
     * @return \StructType\Ticket
     */
    public function setReasonForReroute($reasonForReroute = null)
    {
        // validation for constraint: string
        if (!is_null($reasonForReroute) && !is_string($reasonForReroute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reasonForReroute, true), gettype($reasonForReroute)), __LINE__);
        }
        $this->ReasonForReroute = $reasonForReroute;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Ticket
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
