<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxesType StructType
 * @subpackage Structs
 */
class TaxesType extends AbstractStructBase
{
    /**
     * The Tax
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TaxType[]
     */
    public $Tax;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * Constructor method for TaxesType
     * @uses TaxesType::setTax()
     * @uses TaxesType::setCurrencyCode()
     * @uses TaxesType::setAmount()
     * @param \StructType\TaxType[] $tax
     * @param string $currencyCode
     * @param float $amount
     */
    public function __construct(array $tax = array(), $currencyCode = null, $amount = null)
    {
        $this
            ->setTax($tax)
            ->setCurrencyCode($currencyCode)
            ->setAmount($amount);
    }
    /**
     * Get Tax value
     * @return \StructType\TaxType[]|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * This method is responsible for validating the values passed to the setTax method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTax method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxForArrayConstraintsFromSetTax(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxesTypeTaxItem) {
            // validation for constraint: itemType
            if (!$taxesTypeTaxItem instanceof \StructType\TaxType) {
                $invalidValues[] = is_object($taxesTypeTaxItem) ? get_class($taxesTypeTaxItem) : sprintf('%s(%s)', gettype($taxesTypeTaxItem), var_export($taxesTypeTaxItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Tax property can only contain items of type \StructType\TaxType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Tax value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxType[] $tax
     * @return \StructType\TaxesType
     */
    public function setTax(array $tax = array())
    {
        // validation for constraint: array
        if ('' !== ($taxArrayErrorMessage = self::validateTaxForArrayConstraintsFromSetTax($tax))) {
            throw new \InvalidArgumentException($taxArrayErrorMessage, __LINE__);
        }
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Add item to Tax value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxType $item
     * @return \StructType\TaxesType
     */
    public function addToTax(\StructType\TaxType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaxType) {
            throw new \InvalidArgumentException(sprintf('The Tax property can only contain items of type \StructType\TaxType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Tax[] = $item;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\TaxesType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\TaxesType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TaxesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
