<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TLWebPmsServiceExtensions StructType
 * @subpackage Structs
 */
class TLWebPmsServiceExtensions extends AbstractStructBase
{
    /**
     * The prepay
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $prepay;
    /**
     * The InfoItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InfoItem[]
     */
    public $InfoItem;
    /**
     * The direction
     * @var string
     */
    public $direction;
    /**
     * The vehicle
     * @var string
     */
    public $vehicle;
    /**
     * The date
     * @var string
     */
    public $date;
    /**
     * The mealPlanCode
     * @var string
     */
    public $mealPlanCode;
    /**
     * Constructor method for TLWebPmsServiceExtensions
     * @uses TLWebPmsServiceExtensions::setPrepay()
     * @uses TLWebPmsServiceExtensions::setInfoItem()
     * @uses TLWebPmsServiceExtensions::setDirection()
     * @uses TLWebPmsServiceExtensions::setVehicle()
     * @uses TLWebPmsServiceExtensions::setDate()
     * @uses TLWebPmsServiceExtensions::setMealPlanCode()
     * @param float $prepay
     * @param \StructType\InfoItem[] $infoItem
     * @param string $direction
     * @param string $vehicle
     * @param string $date
     * @param string $mealPlanCode
     */
    public function __construct($prepay = null, array $infoItem = array(), $direction = null, $vehicle = null, $date = null, $mealPlanCode = null)
    {
        $this
            ->setPrepay($prepay)
            ->setInfoItem($infoItem)
            ->setDirection($direction)
            ->setVehicle($vehicle)
            ->setDate($date)
            ->setMealPlanCode($mealPlanCode);
    }
    /**
     * Get prepay value
     * @return float
     */
    public function getPrepay()
    {
        return $this->prepay;
    }
    /**
     * Set prepay value
     * @param float $prepay
     * @return \StructType\TLWebPmsServiceExtensions
     */
    public function setPrepay($prepay = null)
    {
        // validation for constraint: float
        if (!is_null($prepay) && !(is_float($prepay) || is_numeric($prepay))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prepay, true), gettype($prepay)), __LINE__);
        }
        $this->prepay = $prepay;
        return $this;
    }
    /**
     * Get InfoItem value
     * @return \StructType\InfoItem[]|null
     */
    public function getInfoItem()
    {
        return $this->InfoItem;
    }
    /**
     * This method is responsible for validating the values passed to the setInfoItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInfoItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInfoItemForArrayConstraintsFromSetInfoItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tLWebPmsServiceExtensionsInfoItemItem) {
            // validation for constraint: itemType
            if (!$tLWebPmsServiceExtensionsInfoItemItem instanceof \StructType\InfoItem) {
                $invalidValues[] = is_object($tLWebPmsServiceExtensionsInfoItemItem) ? get_class($tLWebPmsServiceExtensionsInfoItemItem) : sprintf('%s(%s)', gettype($tLWebPmsServiceExtensionsInfoItemItem), var_export($tLWebPmsServiceExtensionsInfoItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InfoItem property can only contain items of type \StructType\InfoItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InfoItem value
     * @throws \InvalidArgumentException
     * @param \StructType\InfoItem[] $infoItem
     * @return \StructType\TLWebPmsServiceExtensions
     */
    public function setInfoItem(array $infoItem = array())
    {
        // validation for constraint: array
        if ('' !== ($infoItemArrayErrorMessage = self::validateInfoItemForArrayConstraintsFromSetInfoItem($infoItem))) {
            throw new \InvalidArgumentException($infoItemArrayErrorMessage, __LINE__);
        }
        $this->InfoItem = $infoItem;
        return $this;
    }
    /**
     * Add item to InfoItem value
     * @throws \InvalidArgumentException
     * @param \StructType\InfoItem $item
     * @return \StructType\TLWebPmsServiceExtensions
     */
    public function addToInfoItem(\StructType\InfoItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InfoItem) {
            throw new \InvalidArgumentException(sprintf('The InfoItem property can only contain items of type \StructType\InfoItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InfoItem[] = $item;
        return $this;
    }
    /**
     * Get direction value
     * @return string|null
     */
    public function getDirection()
    {
        return $this->direction;
    }
    /**
     * Set direction value
     * @uses \EnumType\TransferDirectionEnum::valueIsValid()
     * @uses \EnumType\TransferDirectionEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $direction
     * @return \StructType\TLWebPmsServiceExtensions
     */
    public function setDirection($direction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransferDirectionEnum::valueIsValid($direction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TransferDirectionEnum', is_array($direction) ? implode(', ', $direction) : var_export($direction, true), implode(', ', \EnumType\TransferDirectionEnum::getValidValues())), __LINE__);
        }
        $this->direction = $direction;
        return $this;
    }
    /**
     * Get vehicle value
     * @return string|null
     */
    public function getVehicle()
    {
        return $this->vehicle;
    }
    /**
     * Set vehicle value
     * @param string $vehicle
     * @return \StructType\TLWebPmsServiceExtensions
     */
    public function setVehicle($vehicle = null)
    {
        // validation for constraint: string
        if (!is_null($vehicle) && !is_string($vehicle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vehicle, true), gettype($vehicle)), __LINE__);
        }
        $this->vehicle = $vehicle;
        return $this;
    }
    /**
     * Get date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \StructType\TLWebPmsServiceExtensions
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get mealPlanCode value
     * @return string|null
     */
    public function getMealPlanCode()
    {
        return $this->mealPlanCode;
    }
    /**
     * Set mealPlanCode value
     * @param string $mealPlanCode
     * @return \StructType\TLWebPmsServiceExtensions
     */
    public function setMealPlanCode($mealPlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($mealPlanCode) && !is_string($mealPlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mealPlanCode, true), gettype($mealPlanCode)), __LINE__);
        }
        $this->mealPlanCode = $mealPlanCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TLWebPmsServiceExtensions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
