<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomStay StructType
 * @subpackage Structs
 */
class RoomStay extends RoomStayType
{
    /**
     * The Comments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCommentTypeComment
     */
    public $Comments;
    /**
     * The ServiceRPHs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfServiceRPHsTypeServiceRPH
     */
    public $ServiceRPHs;
    /**
     * The MarketCode
     * @var string
     */
    public $MarketCode;
    /**
     * The SourceOfBusiness
     * @var string
     */
    public $SourceOfBusiness;
    /**
     * The IndexNumber
     * @var int
     */
    public $IndexNumber;
    /**
     * The Reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Reference
     */
    public $Reference;
    /**
     * The RoomStayCandidateRPH
     * @var string
     */
    public $RoomStayCandidateRPH;
    /**
     * Constructor method for RoomStay
     * @uses RoomStay::setComments()
     * @uses RoomStay::setServiceRPHs()
     * @uses RoomStay::setMarketCode()
     * @uses RoomStay::setSourceOfBusiness()
     * @uses RoomStay::setIndexNumber()
     * @uses RoomStay::setReference()
     * @uses RoomStay::setRoomStayCandidateRPH()
     * @param \ArrayType\ArrayOfCommentTypeComment $comments
     * @param \ArrayType\ArrayOfServiceRPHsTypeServiceRPH $serviceRPHs
     * @param string $marketCode
     * @param string $sourceOfBusiness
     * @param int $indexNumber
     * @param \StructType\Reference $reference
     * @param string $roomStayCandidateRPH
     */
    public function __construct(\ArrayType\ArrayOfCommentTypeComment $comments = null, \ArrayType\ArrayOfServiceRPHsTypeServiceRPH $serviceRPHs = null, $marketCode = null, $sourceOfBusiness = null, $indexNumber = null, \StructType\Reference $reference = null, $roomStayCandidateRPH = null)
    {
        $this
            ->setComments($comments)
            ->setServiceRPHs($serviceRPHs)
            ->setMarketCode($marketCode)
            ->setSourceOfBusiness($sourceOfBusiness)
            ->setIndexNumber($indexNumber)
            ->setReference($reference)
            ->setRoomStayCandidateRPH($roomStayCandidateRPH);
    }
    /**
     * Get Comments value
     * @return \ArrayType\ArrayOfCommentTypeComment|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param \ArrayType\ArrayOfCommentTypeComment $comments
     * @return \StructType\RoomStay
     */
    public function setComments(\ArrayType\ArrayOfCommentTypeComment $comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get ServiceRPHs value
     * @return \ArrayType\ArrayOfServiceRPHsTypeServiceRPH|null
     */
    public function getServiceRPHs()
    {
        return $this->ServiceRPHs;
    }
    /**
     * Set ServiceRPHs value
     * @param \ArrayType\ArrayOfServiceRPHsTypeServiceRPH $serviceRPHs
     * @return \StructType\RoomStay
     */
    public function setServiceRPHs(\ArrayType\ArrayOfServiceRPHsTypeServiceRPH $serviceRPHs = null)
    {
        $this->ServiceRPHs = $serviceRPHs;
        return $this;
    }
    /**
     * Get MarketCode value
     * @return string|null
     */
    public function getMarketCode()
    {
        return $this->MarketCode;
    }
    /**
     * Set MarketCode value
     * @param string $marketCode
     * @return \StructType\RoomStay
     */
    public function setMarketCode($marketCode = null)
    {
        // validation for constraint: string
        if (!is_null($marketCode) && !is_string($marketCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marketCode, true), gettype($marketCode)), __LINE__);
        }
        $this->MarketCode = $marketCode;
        return $this;
    }
    /**
     * Get SourceOfBusiness value
     * @return string|null
     */
    public function getSourceOfBusiness()
    {
        return $this->SourceOfBusiness;
    }
    /**
     * Set SourceOfBusiness value
     * @param string $sourceOfBusiness
     * @return \StructType\RoomStay
     */
    public function setSourceOfBusiness($sourceOfBusiness = null)
    {
        // validation for constraint: string
        if (!is_null($sourceOfBusiness) && !is_string($sourceOfBusiness)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceOfBusiness, true), gettype($sourceOfBusiness)), __LINE__);
        }
        $this->SourceOfBusiness = $sourceOfBusiness;
        return $this;
    }
    /**
     * Get IndexNumber value
     * @return int|null
     */
    public function getIndexNumber()
    {
        return $this->IndexNumber;
    }
    /**
     * Set IndexNumber value
     * @param int $indexNumber
     * @return \StructType\RoomStay
     */
    public function setIndexNumber($indexNumber = null)
    {
        // validation for constraint: int
        if (!is_null($indexNumber) && !(is_int($indexNumber) || ctype_digit($indexNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($indexNumber, true), gettype($indexNumber)), __LINE__);
        }
        $this->IndexNumber = $indexNumber;
        return $this;
    }
    /**
     * Get Reference value
     * @return \StructType\Reference|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param \StructType\Reference $reference
     * @return \StructType\RoomStay
     */
    public function setReference(\StructType\Reference $reference = null)
    {
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get RoomStayCandidateRPH value
     * @return string|null
     */
    public function getRoomStayCandidateRPH()
    {
        return $this->RoomStayCandidateRPH;
    }
    /**
     * Set RoomStayCandidateRPH value
     * @param string $roomStayCandidateRPH
     * @return \StructType\RoomStay
     */
    public function setRoomStayCandidateRPH($roomStayCandidateRPH = null)
    {
        // validation for constraint: string
        if (!is_null($roomStayCandidateRPH) && !is_string($roomStayCandidateRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomStayCandidateRPH, true), gettype($roomStayCandidateRPH)), __LINE__);
        }
        $this->RoomStayCandidateRPH = $roomStayCandidateRPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomStay
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
