<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomRateType StructType
 * @subpackage Structs
 */
class RoomRateType extends AbstractStructBase
{
    /**
     * The Rates
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRateTypeRate
     */
    public $Rates;
    /**
     * The Total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TotalType
     */
    public $Total;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * The ExpireDateExclusiveInd
     * @var bool
     */
    public $ExpireDateExclusiveInd;
    /**
     * The RoomTypeCode
     * @var string
     */
    public $RoomTypeCode;
    /**
     * The NumberOfUnits
     * @var int
     */
    public $NumberOfUnits;
    /**
     * The RatePlanType
     * @var string
     */
    public $RatePlanType;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * The RatePlanID
     * @var string
     */
    public $RatePlanID;
    /**
     * The RatePlanQualifier
     * @var bool
     */
    public $RatePlanQualifier;
    /**
     * The RatePlanCategory
     * @var string
     */
    public $RatePlanCategory;
    /**
     * The InvBlockCode
     * @var string
     */
    public $InvBlockCode;
    /**
     * Constructor method for RoomRateType
     * @uses RoomRateType::setRates()
     * @uses RoomRateType::setTotal()
     * @uses RoomRateType::setEffectiveDate()
     * @uses RoomRateType::setExpireDate()
     * @uses RoomRateType::setExpireDateExclusiveInd()
     * @uses RoomRateType::setRoomTypeCode()
     * @uses RoomRateType::setNumberOfUnits()
     * @uses RoomRateType::setRatePlanType()
     * @uses RoomRateType::setRatePlanCode()
     * @uses RoomRateType::setRatePlanID()
     * @uses RoomRateType::setRatePlanQualifier()
     * @uses RoomRateType::setRatePlanCategory()
     * @uses RoomRateType::setInvBlockCode()
     * @param \ArrayType\ArrayOfRateTypeRate $rates
     * @param \StructType\TotalType $total
     * @param string $effectiveDate
     * @param string $expireDate
     * @param bool $expireDateExclusiveInd
     * @param string $roomTypeCode
     * @param int $numberOfUnits
     * @param string $ratePlanType
     * @param string $ratePlanCode
     * @param string $ratePlanID
     * @param bool $ratePlanQualifier
     * @param string $ratePlanCategory
     * @param string $invBlockCode
     */
    public function __construct(\ArrayType\ArrayOfRateTypeRate $rates = null, \StructType\TotalType $total = null, $effectiveDate = null, $expireDate = null, $expireDateExclusiveInd = null, $roomTypeCode = null, $numberOfUnits = null, $ratePlanType = null, $ratePlanCode = null, $ratePlanID = null, $ratePlanQualifier = null, $ratePlanCategory = null, $invBlockCode = null)
    {
        $this
            ->setRates($rates)
            ->setTotal($total)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setExpireDateExclusiveInd($expireDateExclusiveInd)
            ->setRoomTypeCode($roomTypeCode)
            ->setNumberOfUnits($numberOfUnits)
            ->setRatePlanType($ratePlanType)
            ->setRatePlanCode($ratePlanCode)
            ->setRatePlanID($ratePlanID)
            ->setRatePlanQualifier($ratePlanQualifier)
            ->setRatePlanCategory($ratePlanCategory)
            ->setInvBlockCode($invBlockCode);
    }
    /**
     * Get Rates value
     * @return \ArrayType\ArrayOfRateTypeRate|null
     */
    public function getRates()
    {
        return $this->Rates;
    }
    /**
     * Set Rates value
     * @param \ArrayType\ArrayOfRateTypeRate $rates
     * @return \StructType\RoomRateType
     */
    public function setRates(\ArrayType\ArrayOfRateTypeRate $rates = null)
    {
        $this->Rates = $rates;
        return $this;
    }
    /**
     * Get Total value
     * @return \StructType\TotalType|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param \StructType\TotalType $total
     * @return \StructType\RoomRateType
     */
    public function setTotal(\StructType\TotalType $total = null)
    {
        $this->Total = $total;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\RoomRateType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \StructType\RoomRateType
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get ExpireDateExclusiveInd value
     * @return bool|null
     */
    public function getExpireDateExclusiveInd()
    {
        return $this->ExpireDateExclusiveInd;
    }
    /**
     * Set ExpireDateExclusiveInd value
     * @param bool $expireDateExclusiveInd
     * @return \StructType\RoomRateType
     */
    public function setExpireDateExclusiveInd($expireDateExclusiveInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($expireDateExclusiveInd) && !is_bool($expireDateExclusiveInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($expireDateExclusiveInd, true), gettype($expireDateExclusiveInd)), __LINE__);
        }
        $this->ExpireDateExclusiveInd = $expireDateExclusiveInd;
        return $this;
    }
    /**
     * Get RoomTypeCode value
     * @return string|null
     */
    public function getRoomTypeCode()
    {
        return $this->RoomTypeCode;
    }
    /**
     * Set RoomTypeCode value
     * @param string $roomTypeCode
     * @return \StructType\RoomRateType
     */
    public function setRoomTypeCode($roomTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomTypeCode) && !is_string($roomTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomTypeCode, true), gettype($roomTypeCode)), __LINE__);
        }
        $this->RoomTypeCode = $roomTypeCode;
        return $this;
    }
    /**
     * Get NumberOfUnits value
     * @return int|null
     */
    public function getNumberOfUnits()
    {
        return $this->NumberOfUnits;
    }
    /**
     * Set NumberOfUnits value
     * @param int $numberOfUnits
     * @return \StructType\RoomRateType
     */
    public function setNumberOfUnits($numberOfUnits = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfUnits) && !(is_int($numberOfUnits) || ctype_digit($numberOfUnits))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfUnits, true), gettype($numberOfUnits)), __LINE__);
        }
        $this->NumberOfUnits = $numberOfUnits;
        return $this;
    }
    /**
     * Get RatePlanType value
     * @return string|null
     */
    public function getRatePlanType()
    {
        return $this->RatePlanType;
    }
    /**
     * Set RatePlanType value
     * @param string $ratePlanType
     * @return \StructType\RoomRateType
     */
    public function setRatePlanType($ratePlanType = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanType) && !is_string($ratePlanType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanType, true), gettype($ratePlanType)), __LINE__);
        }
        $this->RatePlanType = $ratePlanType;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\RoomRateType
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get RatePlanID value
     * @return string|null
     */
    public function getRatePlanID()
    {
        return $this->RatePlanID;
    }
    /**
     * Set RatePlanID value
     * @param string $ratePlanID
     * @return \StructType\RoomRateType
     */
    public function setRatePlanID($ratePlanID = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanID) && !is_string($ratePlanID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanID, true), gettype($ratePlanID)), __LINE__);
        }
        $this->RatePlanID = $ratePlanID;
        return $this;
    }
    /**
     * Get RatePlanQualifier value
     * @return bool|null
     */
    public function getRatePlanQualifier()
    {
        return $this->RatePlanQualifier;
    }
    /**
     * Set RatePlanQualifier value
     * @param bool $ratePlanQualifier
     * @return \StructType\RoomRateType
     */
    public function setRatePlanQualifier($ratePlanQualifier = null)
    {
        // validation for constraint: boolean
        if (!is_null($ratePlanQualifier) && !is_bool($ratePlanQualifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ratePlanQualifier, true), gettype($ratePlanQualifier)), __LINE__);
        }
        $this->RatePlanQualifier = $ratePlanQualifier;
        return $this;
    }
    /**
     * Get RatePlanCategory value
     * @return string|null
     */
    public function getRatePlanCategory()
    {
        return $this->RatePlanCategory;
    }
    /**
     * Set RatePlanCategory value
     * @param string $ratePlanCategory
     * @return \StructType\RoomRateType
     */
    public function setRatePlanCategory($ratePlanCategory = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCategory) && !is_string($ratePlanCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCategory, true), gettype($ratePlanCategory)), __LINE__);
        }
        $this->RatePlanCategory = $ratePlanCategory;
        return $this;
    }
    /**
     * Get InvBlockCode value
     * @return string|null
     */
    public function getInvBlockCode()
    {
        return $this->InvBlockCode;
    }
    /**
     * Set InvBlockCode value
     * @param string $invBlockCode
     * @return \StructType\RoomRateType
     */
    public function setInvBlockCode($invBlockCode = null)
    {
        // validation for constraint: string
        if (!is_null($invBlockCode) && !is_string($invBlockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invBlockCode, true), gettype($invBlockCode)), __LINE__);
        }
        $this->InvBlockCode = $invBlockCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomRateType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
