<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomRate StructType
 * @subpackage Structs
 */
class RoomRate extends RoomRateType
{
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RoomStayTypeRoomRate_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The RoomTypeName
     * @var string
     */
    public $RoomTypeName;
    /**
     * The RatePlanName
     * @var string
     */
    public $RatePlanName;
    /**
     * The InvBlockName
     * @var string
     */
    public $InvBlockName;
    /**
     * Constructor method for RoomRate
     * @uses RoomRate::setTPA_Extensions()
     * @uses RoomRate::setRoomTypeName()
     * @uses RoomRate::setRatePlanName()
     * @uses RoomRate::setInvBlockName()
     * @param \StructType\RoomStayTypeRoomRate_ExtensionsType $tPA_Extensions
     * @param string $roomTypeName
     * @param string $ratePlanName
     * @param string $invBlockName
     */
    public function __construct(\StructType\RoomStayTypeRoomRate_ExtensionsType $tPA_Extensions = null, $roomTypeName = null, $ratePlanName = null, $invBlockName = null)
    {
        $this
            ->setTPA_Extensions($tPA_Extensions)
            ->setRoomTypeName($roomTypeName)
            ->setRatePlanName($ratePlanName)
            ->setInvBlockName($invBlockName);
    }
    /**
     * Get TPA_Extensions value
     * @return \StructType\RoomStayTypeRoomRate_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \StructType\RoomStayTypeRoomRate_ExtensionsType $tPA_Extensions
     * @return \StructType\RoomRate
     */
    public function setTPA_Extensions(\StructType\RoomStayTypeRoomRate_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get RoomTypeName value
     * @return string|null
     */
    public function getRoomTypeName()
    {
        return $this->RoomTypeName;
    }
    /**
     * Set RoomTypeName value
     * @param string $roomTypeName
     * @return \StructType\RoomRate
     */
    public function setRoomTypeName($roomTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($roomTypeName) && !is_string($roomTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomTypeName, true), gettype($roomTypeName)), __LINE__);
        }
        $this->RoomTypeName = $roomTypeName;
        return $this;
    }
    /**
     * Get RatePlanName value
     * @return string|null
     */
    public function getRatePlanName()
    {
        return $this->RatePlanName;
    }
    /**
     * Set RatePlanName value
     * @param string $ratePlanName
     * @return \StructType\RoomRate
     */
    public function setRatePlanName($ratePlanName = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanName) && !is_string($ratePlanName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanName, true), gettype($ratePlanName)), __LINE__);
        }
        $this->RatePlanName = $ratePlanName;
        return $this;
    }
    /**
     * Get InvBlockName value
     * @return string|null
     */
    public function getInvBlockName()
    {
        return $this->InvBlockName;
    }
    /**
     * Set InvBlockName value
     * @param string $invBlockName
     * @return \StructType\RoomRate
     */
    public function setInvBlockName($invBlockName = null)
    {
        // validation for constraint: string
        if (!is_null($invBlockName) && !is_string($invBlockName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invBlockName, true), gettype($invBlockName)), __LINE__);
        }
        $this->InvBlockName = $invBlockName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomRate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
