<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestorID StructType
 * @subpackage Structs
 */
class RequestorID extends UniqueID_Type
{
    /**
     * The MessagePassword
     * @var string
     */
    public $MessagePassword;
    /**
     * Constructor method for RequestorID
     * @uses RequestorID::setMessagePassword()
     * @param string $messagePassword
     */
    public function __construct($messagePassword = null)
    {
        $this
            ->setMessagePassword($messagePassword);
    }
    /**
     * Get MessagePassword value
     * @return string|null
     */
    public function getMessagePassword()
    {
        return $this->MessagePassword;
    }
    /**
     * Set MessagePassword value
     * @param string $messagePassword
     * @return \StructType\RequestorID
     */
    public function setMessagePassword($messagePassword = null)
    {
        // validation for constraint: string
        if (!is_null($messagePassword) && !is_string($messagePassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messagePassword, true), gettype($messagePassword)), __LINE__);
        }
        $this->MessagePassword = $messagePassword;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RequestorID
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
