<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReadRequests StructType
 * @subpackage Structs
 */
class ReadRequests extends AbstractStructBase
{
    /**
     * The HotelReadRequest
     * Meta informations extracted from the WSDL
     * - choice: HotelReadRequest | ReadRequest | ProfileReadRequest
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\HotelReadRequest
     */
    public $HotelReadRequest;
    /**
     * The ReadRequest
     * Meta informations extracted from the WSDL
     * - choice: HotelReadRequest | ReadRequest | ProfileReadRequest
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ReadRequest
     */
    public $ReadRequest;
    /**
     * The ProfileReadRequest
     * Meta informations extracted from the WSDL
     * - choice: HotelReadRequest | ReadRequest | ProfileReadRequest
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ProfileReadRequest
     */
    public $ProfileReadRequest;
    /**
     * Constructor method for ReadRequests
     * @uses ReadRequests::setHotelReadRequest()
     * @uses ReadRequests::setReadRequest()
     * @uses ReadRequests::setProfileReadRequest()
     * @param \StructType\HotelReadRequest $hotelReadRequest
     * @param \StructType\ReadRequest $readRequest
     * @param \StructType\ProfileReadRequest $profileReadRequest
     */
    public function __construct(\StructType\HotelReadRequest $hotelReadRequest = null, \StructType\ReadRequest $readRequest = null, \StructType\ProfileReadRequest $profileReadRequest = null)
    {
        $this
            ->setHotelReadRequest($hotelReadRequest)
            ->setReadRequest($readRequest)
            ->setProfileReadRequest($profileReadRequest);
    }
    /**
     * Get HotelReadRequest value
     * @return \StructType\HotelReadRequest|null
     */
    public function getHotelReadRequest()
    {
        return isset($this->HotelReadRequest) ? $this->HotelReadRequest : null;
    }
    /**
     * This method is responsible for validating the value passed to the setHotelReadRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelReadRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateHotelReadRequestForChoiceConstraintsFromSetHotelReadRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ReadRequest',
            'ProfileReadRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property HotelReadRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: HotelReadRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set HotelReadRequest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\HotelReadRequest $hotelReadRequest
     * @return \StructType\ReadRequests
     */
    public function setHotelReadRequest(\StructType\HotelReadRequest $hotelReadRequest = null)
    {
        // validation for constraint: choice(HotelReadRequest, ReadRequest, ProfileReadRequest)
        if ('' !== ($hotelReadRequestChoiceErrorMessage = self::validateHotelReadRequestForChoiceConstraintsFromSetHotelReadRequest($hotelReadRequest))) {
            throw new \InvalidArgumentException($hotelReadRequestChoiceErrorMessage, __LINE__);
        }
        if (is_null($hotelReadRequest) || (is_array($hotelReadRequest) && empty($hotelReadRequest))) {
            unset($this->HotelReadRequest);
        } else {
            $this->HotelReadRequest = $hotelReadRequest;
        }
        return $this;
    }
    /**
     * Get ReadRequest value
     * @return \StructType\ReadRequest|null
     */
    public function getReadRequest()
    {
        return isset($this->ReadRequest) ? $this->ReadRequest : null;
    }
    /**
     * This method is responsible for validating the value passed to the setReadRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReadRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateReadRequestForChoiceConstraintsFromSetReadRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'HotelReadRequest',
            'ProfileReadRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ReadRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: ReadRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ReadRequest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ReadRequest $readRequest
     * @return \StructType\ReadRequests
     */
    public function setReadRequest(\StructType\ReadRequest $readRequest = null)
    {
        // validation for constraint: choice(HotelReadRequest, ReadRequest, ProfileReadRequest)
        if ('' !== ($readRequestChoiceErrorMessage = self::validateReadRequestForChoiceConstraintsFromSetReadRequest($readRequest))) {
            throw new \InvalidArgumentException($readRequestChoiceErrorMessage, __LINE__);
        }
        if (is_null($readRequest) || (is_array($readRequest) && empty($readRequest))) {
            unset($this->ReadRequest);
        } else {
            $this->ReadRequest = $readRequest;
        }
        return $this;
    }
    /**
     * Get ProfileReadRequest value
     * @return \StructType\ProfileReadRequest|null
     */
    public function getProfileReadRequest()
    {
        return isset($this->ProfileReadRequest) ? $this->ProfileReadRequest : null;
    }
    /**
     * This method is responsible for validating the value passed to the setProfileReadRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProfileReadRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateProfileReadRequestForChoiceConstraintsFromSetProfileReadRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'HotelReadRequest',
            'ReadRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ProfileReadRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: ProfileReadRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ProfileReadRequest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ProfileReadRequest $profileReadRequest
     * @return \StructType\ReadRequests
     */
    public function setProfileReadRequest(\StructType\ProfileReadRequest $profileReadRequest = null)
    {
        // validation for constraint: choice(HotelReadRequest, ReadRequest, ProfileReadRequest)
        if ('' !== ($profileReadRequestChoiceErrorMessage = self::validateProfileReadRequestForChoiceConstraintsFromSetProfileReadRequest($profileReadRequest))) {
            throw new \InvalidArgumentException($profileReadRequestChoiceErrorMessage, __LINE__);
        }
        if (is_null($profileReadRequest) || (is_array($profileReadRequest) && empty($profileReadRequest))) {
            unset($this->ProfileReadRequest);
        } else {
            $this->ProfileReadRequest = $profileReadRequest;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReadRequests
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
