<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RatePlans StructType
 * @subpackage Structs
 */
class RatePlans extends AbstractStructBase
{
    /**
     * The RatePlan
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\HotelRatePlanType[]
     */
    public $RatePlan;
    /**
     * The HotelCode
     * @var string
     */
    public $HotelCode;
    /**
     * The HotelName
     * @var string
     */
    public $HotelName;
    /**
     * Constructor method for RatePlans
     * @uses RatePlans::setRatePlan()
     * @uses RatePlans::setHotelCode()
     * @uses RatePlans::setHotelName()
     * @param \StructType\HotelRatePlanType[] $ratePlan
     * @param string $hotelCode
     * @param string $hotelName
     */
    public function __construct(array $ratePlan = array(), $hotelCode = null, $hotelName = null)
    {
        $this
            ->setRatePlan($ratePlan)
            ->setHotelCode($hotelCode)
            ->setHotelName($hotelName);
    }
    /**
     * Get RatePlan value
     * @return \StructType\HotelRatePlanType[]|null
     */
    public function getRatePlan()
    {
        return $this->RatePlan;
    }
    /**
     * This method is responsible for validating the values passed to the setRatePlan method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRatePlan method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRatePlanForArrayConstraintsFromSetRatePlan(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ratePlansRatePlanItem) {
            // validation for constraint: itemType
            if (!$ratePlansRatePlanItem instanceof \StructType\HotelRatePlanType) {
                $invalidValues[] = is_object($ratePlansRatePlanItem) ? get_class($ratePlansRatePlanItem) : sprintf('%s(%s)', gettype($ratePlansRatePlanItem), var_export($ratePlansRatePlanItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RatePlan property can only contain items of type \StructType\HotelRatePlanType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RatePlan value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelRatePlanType[] $ratePlan
     * @return \StructType\RatePlans
     */
    public function setRatePlan(array $ratePlan = array())
    {
        // validation for constraint: array
        if ('' !== ($ratePlanArrayErrorMessage = self::validateRatePlanForArrayConstraintsFromSetRatePlan($ratePlan))) {
            throw new \InvalidArgumentException($ratePlanArrayErrorMessage, __LINE__);
        }
        $this->RatePlan = $ratePlan;
        return $this;
    }
    /**
     * Add item to RatePlan value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelRatePlanType $item
     * @return \StructType\RatePlans
     */
    public function addToRatePlan(\StructType\HotelRatePlanType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HotelRatePlanType) {
            throw new \InvalidArgumentException(sprintf('The RatePlan property can only contain items of type \StructType\HotelRatePlanType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RatePlan[] = $item;
        return $this;
    }
    /**
     * Get HotelCode value
     * @return string|null
     */
    public function getHotelCode()
    {
        return $this->HotelCode;
    }
    /**
     * Set HotelCode value
     * @param string $hotelCode
     * @return \StructType\RatePlans
     */
    public function setHotelCode($hotelCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCode) && !is_string($hotelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCode, true), gettype($hotelCode)), __LINE__);
        }
        $this->HotelCode = $hotelCode;
        return $this;
    }
    /**
     * Get HotelName value
     * @return string|null
     */
    public function getHotelName()
    {
        return $this->HotelName;
    }
    /**
     * Set HotelName value
     * @param string $hotelName
     * @return \StructType\RatePlans
     */
    public function setHotelName($hotelName = null)
    {
        // validation for constraint: string
        if (!is_null($hotelName) && !is_string($hotelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelName, true), gettype($hotelName)), __LINE__);
        }
        $this->HotelName = $hotelName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RatePlans
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
