<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RatePlanCrossRef StructType
 * @subpackage Structs
 */
class RatePlanCrossRef extends AbstractStructBase
{
    /**
     * The RequestRatePlanCode
     * @var string
     */
    public $RequestRatePlanCode;
    /**
     * The RequestRatePlanGroupingCode
     * @var string
     */
    public $RequestRatePlanGroupingCode;
    /**
     * The ResponseRatePlanCode
     * @var string
     */
    public $ResponseRatePlanCode;
    /**
     * The ResponseRatePlanGroupingCode
     * @var string
     */
    public $ResponseRatePlanGroupingCode;
    /**
     * Constructor method for RatePlanCrossRef
     * @uses RatePlanCrossRef::setRequestRatePlanCode()
     * @uses RatePlanCrossRef::setRequestRatePlanGroupingCode()
     * @uses RatePlanCrossRef::setResponseRatePlanCode()
     * @uses RatePlanCrossRef::setResponseRatePlanGroupingCode()
     * @param string $requestRatePlanCode
     * @param string $requestRatePlanGroupingCode
     * @param string $responseRatePlanCode
     * @param string $responseRatePlanGroupingCode
     */
    public function __construct($requestRatePlanCode = null, $requestRatePlanGroupingCode = null, $responseRatePlanCode = null, $responseRatePlanGroupingCode = null)
    {
        $this
            ->setRequestRatePlanCode($requestRatePlanCode)
            ->setRequestRatePlanGroupingCode($requestRatePlanGroupingCode)
            ->setResponseRatePlanCode($responseRatePlanCode)
            ->setResponseRatePlanGroupingCode($responseRatePlanGroupingCode);
    }
    /**
     * Get RequestRatePlanCode value
     * @return string|null
     */
    public function getRequestRatePlanCode()
    {
        return $this->RequestRatePlanCode;
    }
    /**
     * Set RequestRatePlanCode value
     * @param string $requestRatePlanCode
     * @return \StructType\RatePlanCrossRef
     */
    public function setRequestRatePlanCode($requestRatePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($requestRatePlanCode) && !is_string($requestRatePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestRatePlanCode, true), gettype($requestRatePlanCode)), __LINE__);
        }
        $this->RequestRatePlanCode = $requestRatePlanCode;
        return $this;
    }
    /**
     * Get RequestRatePlanGroupingCode value
     * @return string|null
     */
    public function getRequestRatePlanGroupingCode()
    {
        return $this->RequestRatePlanGroupingCode;
    }
    /**
     * Set RequestRatePlanGroupingCode value
     * @param string $requestRatePlanGroupingCode
     * @return \StructType\RatePlanCrossRef
     */
    public function setRequestRatePlanGroupingCode($requestRatePlanGroupingCode = null)
    {
        // validation for constraint: string
        if (!is_null($requestRatePlanGroupingCode) && !is_string($requestRatePlanGroupingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestRatePlanGroupingCode, true), gettype($requestRatePlanGroupingCode)), __LINE__);
        }
        $this->RequestRatePlanGroupingCode = $requestRatePlanGroupingCode;
        return $this;
    }
    /**
     * Get ResponseRatePlanCode value
     * @return string|null
     */
    public function getResponseRatePlanCode()
    {
        return $this->ResponseRatePlanCode;
    }
    /**
     * Set ResponseRatePlanCode value
     * @param string $responseRatePlanCode
     * @return \StructType\RatePlanCrossRef
     */
    public function setResponseRatePlanCode($responseRatePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($responseRatePlanCode) && !is_string($responseRatePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseRatePlanCode, true), gettype($responseRatePlanCode)), __LINE__);
        }
        $this->ResponseRatePlanCode = $responseRatePlanCode;
        return $this;
    }
    /**
     * Get ResponseRatePlanGroupingCode value
     * @return string|null
     */
    public function getResponseRatePlanGroupingCode()
    {
        return $this->ResponseRatePlanGroupingCode;
    }
    /**
     * Set ResponseRatePlanGroupingCode value
     * @param string $responseRatePlanGroupingCode
     * @return \StructType\RatePlanCrossRef
     */
    public function setResponseRatePlanGroupingCode($responseRatePlanGroupingCode = null)
    {
        // validation for constraint: string
        if (!is_null($responseRatePlanGroupingCode) && !is_string($responseRatePlanGroupingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseRatePlanGroupingCode, true), gettype($responseRatePlanGroupingCode)), __LINE__);
        }
        $this->ResponseRatePlanGroupingCode = $responseRatePlanGroupingCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RatePlanCrossRef
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
