<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RatePlanCommission StructType
 * @subpackage Structs
 */
class RatePlanCommission extends AbstractStructBase
{
    /**
     * The MaxCommissionPercentage
     * @var float
     */
    public $MaxCommissionPercentage;
    /**
     * The MinCommissionPercentage
     * @var float
     */
    public $MinCommissionPercentage;
    /**
     * The CommissionableIndicator
     * @var bool
     */
    public $CommissionableIndicator;
    /**
     * Constructor method for RatePlanCommission
     * @uses RatePlanCommission::setMaxCommissionPercentage()
     * @uses RatePlanCommission::setMinCommissionPercentage()
     * @uses RatePlanCommission::setCommissionableIndicator()
     * @param float $maxCommissionPercentage
     * @param float $minCommissionPercentage
     * @param bool $commissionableIndicator
     */
    public function __construct($maxCommissionPercentage = null, $minCommissionPercentage = null, $commissionableIndicator = null)
    {
        $this
            ->setMaxCommissionPercentage($maxCommissionPercentage)
            ->setMinCommissionPercentage($minCommissionPercentage)
            ->setCommissionableIndicator($commissionableIndicator);
    }
    /**
     * Get MaxCommissionPercentage value
     * @return float|null
     */
    public function getMaxCommissionPercentage()
    {
        return $this->MaxCommissionPercentage;
    }
    /**
     * Set MaxCommissionPercentage value
     * @param float $maxCommissionPercentage
     * @return \StructType\RatePlanCommission
     */
    public function setMaxCommissionPercentage($maxCommissionPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($maxCommissionPercentage) && !(is_float($maxCommissionPercentage) || is_numeric($maxCommissionPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxCommissionPercentage, true), gettype($maxCommissionPercentage)), __LINE__);
        }
        $this->MaxCommissionPercentage = $maxCommissionPercentage;
        return $this;
    }
    /**
     * Get MinCommissionPercentage value
     * @return float|null
     */
    public function getMinCommissionPercentage()
    {
        return $this->MinCommissionPercentage;
    }
    /**
     * Set MinCommissionPercentage value
     * @param float $minCommissionPercentage
     * @return \StructType\RatePlanCommission
     */
    public function setMinCommissionPercentage($minCommissionPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($minCommissionPercentage) && !(is_float($minCommissionPercentage) || is_numeric($minCommissionPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minCommissionPercentage, true), gettype($minCommissionPercentage)), __LINE__);
        }
        $this->MinCommissionPercentage = $minCommissionPercentage;
        return $this;
    }
    /**
     * Get CommissionableIndicator value
     * @return bool|null
     */
    public function getCommissionableIndicator()
    {
        return $this->CommissionableIndicator;
    }
    /**
     * Set CommissionableIndicator value
     * @param bool $commissionableIndicator
     * @return \StructType\RatePlanCommission
     */
    public function setCommissionableIndicator($commissionableIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($commissionableIndicator) && !is_bool($commissionableIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($commissionableIndicator, true), gettype($commissionableIndicator)), __LINE__);
        }
        $this->CommissionableIndicator = $commissionableIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RatePlanCommission
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
