<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlacementRates StructType
 * @subpackage Structs
 */
class PlacementRates extends AbstractStructBase
{
    /**
     * The PlacementRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PlacementRateType[]
     */
    public $PlacementRate;
    /**
     * Constructor method for PlacementRates
     * @uses PlacementRates::setPlacementRate()
     * @param \StructType\PlacementRateType[] $placementRate
     */
    public function __construct(array $placementRate = array())
    {
        $this
            ->setPlacementRate($placementRate);
    }
    /**
     * Get PlacementRate value
     * @return \StructType\PlacementRateType[]|null
     */
    public function getPlacementRate()
    {
        return $this->PlacementRate;
    }
    /**
     * This method is responsible for validating the values passed to the setPlacementRate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPlacementRate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePlacementRateForArrayConstraintsFromSetPlacementRate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $placementRatesPlacementRateItem) {
            // validation for constraint: itemType
            if (!$placementRatesPlacementRateItem instanceof \StructType\PlacementRateType) {
                $invalidValues[] = is_object($placementRatesPlacementRateItem) ? get_class($placementRatesPlacementRateItem) : sprintf('%s(%s)', gettype($placementRatesPlacementRateItem), var_export($placementRatesPlacementRateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PlacementRate property can only contain items of type \StructType\PlacementRateType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PlacementRate value
     * @throws \InvalidArgumentException
     * @param \StructType\PlacementRateType[] $placementRate
     * @return \StructType\PlacementRates
     */
    public function setPlacementRate(array $placementRate = array())
    {
        // validation for constraint: array
        if ('' !== ($placementRateArrayErrorMessage = self::validatePlacementRateForArrayConstraintsFromSetPlacementRate($placementRate))) {
            throw new \InvalidArgumentException($placementRateArrayErrorMessage, __LINE__);
        }
        $this->PlacementRate = $placementRate;
        return $this;
    }
    /**
     * Add item to PlacementRate value
     * @throws \InvalidArgumentException
     * @param \StructType\PlacementRateType $item
     * @return \StructType\PlacementRates
     */
    public function addToPlacementRate(\StructType\PlacementRateType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PlacementRateType) {
            throw new \InvalidArgumentException(sprintf('The PlacementRate property can only contain items of type \StructType\PlacementRateType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PlacementRate[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PlacementRates
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
