<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_CancelRQ StructType
 * @subpackage Structs
 */
class OTA_CancelRQ extends AbstractStructBase
{
    /**
     * The IsSyncRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsSyncRequest;
    /**
     * The UniqueID
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UniqueID[]
     */
    public $UniqueID;
    /**
     * The CancellationOverrides
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CancellationOverrides
     */
    public $CancellationOverrides;
    /**
     * The Reasons
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfOTA_CancelRQReason
     */
    public $Reasons;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * @var string
     */
    public $Target;
    /**
     * The TargetName
     * @var string
     */
    public $TargetName;
    /**
     * The Version
     * @var string
     */
    public $Version;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The SequenceNmbr
     * @var int
     */
    public $SequenceNmbr;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The RetransmissionIndicator
     * @var bool
     */
    public $RetransmissionIndicator;
    /**
     * The CorrelationID
     * @var string
     */
    public $CorrelationID;
    /**
     * The PrimaryLangID
     * @var string
     */
    public $PrimaryLangID;
    /**
     * The AltLangID
     * @var string
     */
    public $AltLangID;
    /**
     * Constructor method for OTA_CancelRQ
     * @uses OTA_CancelRQ::setIsSyncRequest()
     * @uses OTA_CancelRQ::setUniqueID()
     * @uses OTA_CancelRQ::setCancellationOverrides()
     * @uses OTA_CancelRQ::setReasons()
     * @uses OTA_CancelRQ::setEchoToken()
     * @uses OTA_CancelRQ::setTimeStamp()
     * @uses OTA_CancelRQ::setTarget()
     * @uses OTA_CancelRQ::setTargetName()
     * @uses OTA_CancelRQ::setVersion()
     * @uses OTA_CancelRQ::setTransactionIdentifier()
     * @uses OTA_CancelRQ::setSequenceNmbr()
     * @uses OTA_CancelRQ::setTransactionStatusCode()
     * @uses OTA_CancelRQ::setRetransmissionIndicator()
     * @uses OTA_CancelRQ::setCorrelationID()
     * @uses OTA_CancelRQ::setPrimaryLangID()
     * @uses OTA_CancelRQ::setAltLangID()
     * @param bool $isSyncRequest
     * @param \StructType\UniqueID[] $uniqueID
     * @param \StructType\CancellationOverrides $cancellationOverrides
     * @param \ArrayType\ArrayOfOTA_CancelRQReason $reasons
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param string $targetName
     * @param string $version
     * @param string $transactionIdentifier
     * @param int $sequenceNmbr
     * @param string $transactionStatusCode
     * @param bool $retransmissionIndicator
     * @param string $correlationID
     * @param string $primaryLangID
     * @param string $altLangID
     */
    public function __construct($isSyncRequest = null, array $uniqueID = array(), \StructType\CancellationOverrides $cancellationOverrides = null, \ArrayType\ArrayOfOTA_CancelRQReason $reasons = null, $echoToken = null, $timeStamp = null, $target = null, $targetName = null, $version = null, $transactionIdentifier = null, $sequenceNmbr = null, $transactionStatusCode = null, $retransmissionIndicator = null, $correlationID = null, $primaryLangID = null, $altLangID = null)
    {
        $this
            ->setIsSyncRequest($isSyncRequest)
            ->setUniqueID($uniqueID)
            ->setCancellationOverrides($cancellationOverrides)
            ->setReasons($reasons)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setTargetName($targetName)
            ->setVersion($version)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setRetransmissionIndicator($retransmissionIndicator)
            ->setCorrelationID($correlationID)
            ->setPrimaryLangID($primaryLangID)
            ->setAltLangID($altLangID);
    }
    /**
     * Get IsSyncRequest value
     * @return bool
     */
    public function getIsSyncRequest()
    {
        return $this->IsSyncRequest;
    }
    /**
     * Set IsSyncRequest value
     * @param bool $isSyncRequest
     * @return \StructType\OTA_CancelRQ
     */
    public function setIsSyncRequest($isSyncRequest = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSyncRequest) && !is_bool($isSyncRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSyncRequest, true), gettype($isSyncRequest)), __LINE__);
        }
        $this->IsSyncRequest = $isSyncRequest;
        return $this;
    }
    /**
     * Get UniqueID value
     * @return \StructType\UniqueID[]|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * This method is responsible for validating the values passed to the setUniqueID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUniqueID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUniqueIDForArrayConstraintsFromSetUniqueID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $oTA_CancelRQUniqueIDItem) {
            // validation for constraint: itemType
            if (!$oTA_CancelRQUniqueIDItem instanceof \StructType\UniqueID) {
                $invalidValues[] = is_object($oTA_CancelRQUniqueIDItem) ? get_class($oTA_CancelRQUniqueIDItem) : sprintf('%s(%s)', gettype($oTA_CancelRQUniqueIDItem), var_export($oTA_CancelRQUniqueIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UniqueID property can only contain items of type \StructType\UniqueID, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UniqueID value
     * @throws \InvalidArgumentException
     * @param \StructType\UniqueID[] $uniqueID
     * @return \StructType\OTA_CancelRQ
     */
    public function setUniqueID(array $uniqueID = array())
    {
        // validation for constraint: array
        if ('' !== ($uniqueIDArrayErrorMessage = self::validateUniqueIDForArrayConstraintsFromSetUniqueID($uniqueID))) {
            throw new \InvalidArgumentException($uniqueIDArrayErrorMessage, __LINE__);
        }
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Add item to UniqueID value
     * @throws \InvalidArgumentException
     * @param \StructType\UniqueID $item
     * @return \StructType\OTA_CancelRQ
     */
    public function addToUniqueID(\StructType\UniqueID $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UniqueID) {
            throw new \InvalidArgumentException(sprintf('The UniqueID property can only contain items of type \StructType\UniqueID, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UniqueID[] = $item;
        return $this;
    }
    /**
     * Get CancellationOverrides value
     * @return \StructType\CancellationOverrides|null
     */
    public function getCancellationOverrides()
    {
        return $this->CancellationOverrides;
    }
    /**
     * Set CancellationOverrides value
     * @param \StructType\CancellationOverrides $cancellationOverrides
     * @return \StructType\OTA_CancelRQ
     */
    public function setCancellationOverrides(\StructType\CancellationOverrides $cancellationOverrides = null)
    {
        $this->CancellationOverrides = $cancellationOverrides;
        return $this;
    }
    /**
     * Get Reasons value
     * @return \ArrayType\ArrayOfOTA_CancelRQReason|null
     */
    public function getReasons()
    {
        return $this->Reasons;
    }
    /**
     * Set Reasons value
     * @param \ArrayType\ArrayOfOTA_CancelRQReason $reasons
     * @return \StructType\OTA_CancelRQ
     */
    public function setReasons(\ArrayType\ArrayOfOTA_CancelRQReason $reasons = null)
    {
        $this->Reasons = $reasons;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \StructType\OTA_CancelRQ
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($echoToken, true), gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\OTA_CancelRQ
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeStamp, true), gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \StructType\OTA_CancelRQ
     */
    public function setTarget($target = null)
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($target, true), gettype($target)), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get TargetName value
     * @return string|null
     */
    public function getTargetName()
    {
        return $this->TargetName;
    }
    /**
     * Set TargetName value
     * @param string $targetName
     * @return \StructType\OTA_CancelRQ
     */
    public function setTargetName($targetName = null)
    {
        // validation for constraint: string
        if (!is_null($targetName) && !is_string($targetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetName, true), gettype($targetName)), __LINE__);
        }
        $this->TargetName = $targetName;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\OTA_CancelRQ
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \StructType\OTA_CancelRQ
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionIdentifier, true), gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return int|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param int $sequenceNmbr
     * @return \StructType\OTA_CancelRQ
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNmbr) && !(is_int($sequenceNmbr) || ctype_digit($sequenceNmbr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sequenceNmbr, true), gettype($sequenceNmbr)), __LINE__);
        }
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @param string $transactionStatusCode
     * @return \StructType\OTA_CancelRQ
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($transactionStatusCode) && !is_string($transactionStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionStatusCode, true), gettype($transactionStatusCode)), __LINE__);
        }
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get RetransmissionIndicator value
     * @return bool|null
     */
    public function getRetransmissionIndicator()
    {
        return $this->RetransmissionIndicator;
    }
    /**
     * Set RetransmissionIndicator value
     * @param bool $retransmissionIndicator
     * @return \StructType\OTA_CancelRQ
     */
    public function setRetransmissionIndicator($retransmissionIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($retransmissionIndicator) && !is_bool($retransmissionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($retransmissionIndicator, true), gettype($retransmissionIndicator)), __LINE__);
        }
        $this->RetransmissionIndicator = $retransmissionIndicator;
        return $this;
    }
    /**
     * Get CorrelationID value
     * @return string|null
     */
    public function getCorrelationID()
    {
        return $this->CorrelationID;
    }
    /**
     * Set CorrelationID value
     * @param string $correlationID
     * @return \StructType\OTA_CancelRQ
     */
    public function setCorrelationID($correlationID = null)
    {
        // validation for constraint: string
        if (!is_null($correlationID) && !is_string($correlationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($correlationID, true), gettype($correlationID)), __LINE__);
        }
        $this->CorrelationID = $correlationID;
        return $this;
    }
    /**
     * Get PrimaryLangID value
     * @return string|null
     */
    public function getPrimaryLangID()
    {
        return $this->PrimaryLangID;
    }
    /**
     * Set PrimaryLangID value
     * @param string $primaryLangID
     * @return \StructType\OTA_CancelRQ
     */
    public function setPrimaryLangID($primaryLangID = null)
    {
        // validation for constraint: string
        if (!is_null($primaryLangID) && !is_string($primaryLangID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryLangID, true), gettype($primaryLangID)), __LINE__);
        }
        $this->PrimaryLangID = $primaryLangID;
        return $this;
    }
    /**
     * Get AltLangID value
     * @return string|null
     */
    public function getAltLangID()
    {
        return $this->AltLangID;
    }
    /**
     * Set AltLangID value
     * @param string $altLangID
     * @return \StructType\OTA_CancelRQ
     */
    public function setAltLangID($altLangID = null)
    {
        // validation for constraint: string
        if (!is_null($altLangID) && !is_string($altLangID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($altLangID, true), gettype($altLangID)), __LINE__);
        }
        $this->AltLangID = $altLangID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OTA_CancelRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
