<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MarketCode StructType
 * @subpackage Structs
 */
class MarketCode extends AbstractStructBase
{
    /**
     * The MarketCode
     * @var string
     */
    public $MarketCode;
    /**
     * The MarketCodeName
     * @var string
     */
    public $MarketCodeName;
    /**
     * The CommissionableIndicator
     * @var bool
     */
    public $CommissionableIndicator;
    /**
     * The SourceOfBusiness
     * @var string
     */
    public $SourceOfBusiness;
    /**
     * Constructor method for MarketCode
     * @uses MarketCode::setMarketCode()
     * @uses MarketCode::setMarketCodeName()
     * @uses MarketCode::setCommissionableIndicator()
     * @uses MarketCode::setSourceOfBusiness()
     * @param string $marketCode
     * @param string $marketCodeName
     * @param bool $commissionableIndicator
     * @param string $sourceOfBusiness
     */
    public function __construct($marketCode = null, $marketCodeName = null, $commissionableIndicator = null, $sourceOfBusiness = null)
    {
        $this
            ->setMarketCode($marketCode)
            ->setMarketCodeName($marketCodeName)
            ->setCommissionableIndicator($commissionableIndicator)
            ->setSourceOfBusiness($sourceOfBusiness);
    }
    /**
     * Get MarketCode value
     * @return string|null
     */
    public function getMarketCode()
    {
        return $this->MarketCode;
    }
    /**
     * Set MarketCode value
     * @param string $marketCode
     * @return \StructType\MarketCode
     */
    public function setMarketCode($marketCode = null)
    {
        // validation for constraint: string
        if (!is_null($marketCode) && !is_string($marketCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marketCode, true), gettype($marketCode)), __LINE__);
        }
        $this->MarketCode = $marketCode;
        return $this;
    }
    /**
     * Get MarketCodeName value
     * @return string|null
     */
    public function getMarketCodeName()
    {
        return $this->MarketCodeName;
    }
    /**
     * Set MarketCodeName value
     * @param string $marketCodeName
     * @return \StructType\MarketCode
     */
    public function setMarketCodeName($marketCodeName = null)
    {
        // validation for constraint: string
        if (!is_null($marketCodeName) && !is_string($marketCodeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marketCodeName, true), gettype($marketCodeName)), __LINE__);
        }
        $this->MarketCodeName = $marketCodeName;
        return $this;
    }
    /**
     * Get CommissionableIndicator value
     * @return bool|null
     */
    public function getCommissionableIndicator()
    {
        return $this->CommissionableIndicator;
    }
    /**
     * Set CommissionableIndicator value
     * @param bool $commissionableIndicator
     * @return \StructType\MarketCode
     */
    public function setCommissionableIndicator($commissionableIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($commissionableIndicator) && !is_bool($commissionableIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($commissionableIndicator, true), gettype($commissionableIndicator)), __LINE__);
        }
        $this->CommissionableIndicator = $commissionableIndicator;
        return $this;
    }
    /**
     * Get SourceOfBusiness value
     * @return string|null
     */
    public function getSourceOfBusiness()
    {
        return $this->SourceOfBusiness;
    }
    /**
     * Set SourceOfBusiness value
     * @param string $sourceOfBusiness
     * @return \StructType\MarketCode
     */
    public function setSourceOfBusiness($sourceOfBusiness = null)
    {
        // validation for constraint: string
        if (!is_null($sourceOfBusiness) && !is_string($sourceOfBusiness)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceOfBusiness, true), gettype($sourceOfBusiness)), __LINE__);
        }
        $this->SourceOfBusiness = $sourceOfBusiness;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MarketCode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
