<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LengthOfStay StructType
 * @subpackage Structs
 */
class LengthOfStay extends AbstractStructBase
{
    /**
     * The LOS_Pattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LOS_Pattern
     */
    public $LOS_Pattern;
    /**
     * The Time
     * @var int
     */
    public $Time;
    /**
     * The MinMaxMessageType
     * @var string
     */
    public $MinMaxMessageType;
    /**
     * Constructor method for LengthOfStay
     * @uses LengthOfStay::setLOS_Pattern()
     * @uses LengthOfStay::setTime()
     * @uses LengthOfStay::setMinMaxMessageType()
     * @param \StructType\LOS_Pattern $lOS_Pattern
     * @param int $time
     * @param string $minMaxMessageType
     */
    public function __construct(\StructType\LOS_Pattern $lOS_Pattern = null, $time = null, $minMaxMessageType = null)
    {
        $this
            ->setLOS_Pattern($lOS_Pattern)
            ->setTime($time)
            ->setMinMaxMessageType($minMaxMessageType);
    }
    /**
     * Get LOS_Pattern value
     * @return \StructType\LOS_Pattern|null
     */
    public function getLOS_Pattern()
    {
        return $this->LOS_Pattern;
    }
    /**
     * Set LOS_Pattern value
     * @param \StructType\LOS_Pattern $lOS_Pattern
     * @return \StructType\LengthOfStay
     */
    public function setLOS_Pattern(\StructType\LOS_Pattern $lOS_Pattern = null)
    {
        $this->LOS_Pattern = $lOS_Pattern;
        return $this;
    }
    /**
     * Get Time value
     * @return int|null
     */
    public function getTime()
    {
        return $this->Time;
    }
    /**
     * Set Time value
     * @param int $time
     * @return \StructType\LengthOfStay
     */
    public function setTime($time = null)
    {
        // validation for constraint: int
        if (!is_null($time) && !(is_int($time) || ctype_digit($time))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($time, true), gettype($time)), __LINE__);
        }
        $this->Time = $time;
        return $this;
    }
    /**
     * Get MinMaxMessageType value
     * @return string|null
     */
    public function getMinMaxMessageType()
    {
        return $this->MinMaxMessageType;
    }
    /**
     * Set MinMaxMessageType value
     * @param string $minMaxMessageType
     * @return \StructType\LengthOfStay
     */
    public function setMinMaxMessageType($minMaxMessageType = null)
    {
        // validation for constraint: string
        if (!is_null($minMaxMessageType) && !is_string($minMaxMessageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minMaxMessageType, true), gettype($minMaxMessageType)), __LINE__);
        }
        $this->MinMaxMessageType = $minMaxMessageType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LengthOfStay
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
