<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InventoryCrossRefs StructType
 * @subpackage Structs
 */
class InventoryCrossRefs extends AbstractStructBase
{
    /**
     * The InventoryCrossRef
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InventoryCrossRef[]
     */
    public $InventoryCrossRef;
    /**
     * Constructor method for InventoryCrossRefs
     * @uses InventoryCrossRefs::setInventoryCrossRef()
     * @param \StructType\InventoryCrossRef[] $inventoryCrossRef
     */
    public function __construct(array $inventoryCrossRef = array())
    {
        $this
            ->setInventoryCrossRef($inventoryCrossRef);
    }
    /**
     * Get InventoryCrossRef value
     * @return \StructType\InventoryCrossRef[]|null
     */
    public function getInventoryCrossRef()
    {
        return $this->InventoryCrossRef;
    }
    /**
     * This method is responsible for validating the values passed to the setInventoryCrossRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInventoryCrossRef method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInventoryCrossRefForArrayConstraintsFromSetInventoryCrossRef(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inventoryCrossRefsInventoryCrossRefItem) {
            // validation for constraint: itemType
            if (!$inventoryCrossRefsInventoryCrossRefItem instanceof \StructType\InventoryCrossRef) {
                $invalidValues[] = is_object($inventoryCrossRefsInventoryCrossRefItem) ? get_class($inventoryCrossRefsInventoryCrossRefItem) : sprintf('%s(%s)', gettype($inventoryCrossRefsInventoryCrossRefItem), var_export($inventoryCrossRefsInventoryCrossRefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InventoryCrossRef property can only contain items of type \StructType\InventoryCrossRef, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InventoryCrossRef value
     * @throws \InvalidArgumentException
     * @param \StructType\InventoryCrossRef[] $inventoryCrossRef
     * @return \StructType\InventoryCrossRefs
     */
    public function setInventoryCrossRef(array $inventoryCrossRef = array())
    {
        // validation for constraint: array
        if ('' !== ($inventoryCrossRefArrayErrorMessage = self::validateInventoryCrossRefForArrayConstraintsFromSetInventoryCrossRef($inventoryCrossRef))) {
            throw new \InvalidArgumentException($inventoryCrossRefArrayErrorMessage, __LINE__);
        }
        $this->InventoryCrossRef = $inventoryCrossRef;
        return $this;
    }
    /**
     * Add item to InventoryCrossRef value
     * @throws \InvalidArgumentException
     * @param \StructType\InventoryCrossRef $item
     * @return \StructType\InventoryCrossRefs
     */
    public function addToInventoryCrossRef(\StructType\InventoryCrossRef $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InventoryCrossRef) {
            throw new \InvalidArgumentException(sprintf('The InventoryCrossRef property can only contain items of type \StructType\InventoryCrossRef, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InventoryCrossRef[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InventoryCrossRefs
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
