<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvBlocks StructType
 * @subpackage Structs
 */
class InvBlocks extends AbstractStructBase
{
    /**
     * The HotelRef
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\HotelRef
     */
    public $HotelRef;
    /**
     * The InvBlockDates
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InvBlockDates
     */
    public $InvBlockDates;
    /**
     * The InvBlock
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InvBlock[]
     */
    public $InvBlock;
    /**
     * The Contacts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfContactPersonType
     */
    public $Contacts;
    /**
     * The BookingStatus
     * @var string
     */
    public $BookingStatus;
    /**
     * The InvBlockTypeCode
     * @var string
     */
    public $InvBlockTypeCode;
    /**
     * The InvBlockCode
     * @var string
     */
    public $InvBlockCode;
    /**
     * The InvBlockGroupingCode
     * @var string
     */
    public $InvBlockGroupingCode;
    /**
     * The InvBlockName
     * @var string
     */
    public $InvBlockName;
    /**
     * The InvBlockLongName
     * @var string
     */
    public $InvBlockLongName;
    /**
     * The InvBlockStatusCode
     * @var string
     */
    public $InvBlockStatusCode;
    /**
     * The PMS_InvBlockID
     * @var string
     */
    public $PMS_InvBlockID;
    /**
     * The OpportunityID
     * @var string
     */
    public $OpportunityID;
    /**
     * The InvBlockCompanyID
     * @var string
     */
    public $InvBlockCompanyID;
    /**
     * The RestrictedBookingCodeList
     * @var string[]
     */
    public $RestrictedBookingCodeList;
    /**
     * The RestrictedViewingCodeList
     * @var string[]
     */
    public $RestrictedViewingCodeList;
    /**
     * The TransactionAction
     * @var string
     */
    public $TransactionAction;
    /**
     * The TransactionDetail
     * @var string
     */
    public $TransactionDetail;
    /**
     * The QuoteID
     * @var string
     */
    public $QuoteID;
    /**
     * Constructor method for InvBlocks
     * @uses InvBlocks::setHotelRef()
     * @uses InvBlocks::setInvBlockDates()
     * @uses InvBlocks::setInvBlock()
     * @uses InvBlocks::setContacts()
     * @uses InvBlocks::setBookingStatus()
     * @uses InvBlocks::setInvBlockTypeCode()
     * @uses InvBlocks::setInvBlockCode()
     * @uses InvBlocks::setInvBlockGroupingCode()
     * @uses InvBlocks::setInvBlockName()
     * @uses InvBlocks::setInvBlockLongName()
     * @uses InvBlocks::setInvBlockStatusCode()
     * @uses InvBlocks::setPMS_InvBlockID()
     * @uses InvBlocks::setOpportunityID()
     * @uses InvBlocks::setInvBlockCompanyID()
     * @uses InvBlocks::setRestrictedBookingCodeList()
     * @uses InvBlocks::setRestrictedViewingCodeList()
     * @uses InvBlocks::setTransactionAction()
     * @uses InvBlocks::setTransactionDetail()
     * @uses InvBlocks::setQuoteID()
     * @param \StructType\HotelRef $hotelRef
     * @param \StructType\InvBlockDates $invBlockDates
     * @param \StructType\InvBlock[] $invBlock
     * @param \ArrayType\ArrayOfContactPersonType $contacts
     * @param string $bookingStatus
     * @param string $invBlockTypeCode
     * @param string $invBlockCode
     * @param string $invBlockGroupingCode
     * @param string $invBlockName
     * @param string $invBlockLongName
     * @param string $invBlockStatusCode
     * @param string $pMS_InvBlockID
     * @param string $opportunityID
     * @param string $invBlockCompanyID
     * @param string[] $restrictedBookingCodeList
     * @param string[] $restrictedViewingCodeList
     * @param string $transactionAction
     * @param string $transactionDetail
     * @param string $quoteID
     */
    public function __construct(\StructType\HotelRef $hotelRef = null, \StructType\InvBlockDates $invBlockDates = null, array $invBlock = array(), \ArrayType\ArrayOfContactPersonType $contacts = null, $bookingStatus = null, $invBlockTypeCode = null, $invBlockCode = null, $invBlockGroupingCode = null, $invBlockName = null, $invBlockLongName = null, $invBlockStatusCode = null, $pMS_InvBlockID = null, $opportunityID = null, $invBlockCompanyID = null, array $restrictedBookingCodeList = array(), array $restrictedViewingCodeList = array(), $transactionAction = null, $transactionDetail = null, $quoteID = null)
    {
        $this
            ->setHotelRef($hotelRef)
            ->setInvBlockDates($invBlockDates)
            ->setInvBlock($invBlock)
            ->setContacts($contacts)
            ->setBookingStatus($bookingStatus)
            ->setInvBlockTypeCode($invBlockTypeCode)
            ->setInvBlockCode($invBlockCode)
            ->setInvBlockGroupingCode($invBlockGroupingCode)
            ->setInvBlockName($invBlockName)
            ->setInvBlockLongName($invBlockLongName)
            ->setInvBlockStatusCode($invBlockStatusCode)
            ->setPMS_InvBlockID($pMS_InvBlockID)
            ->setOpportunityID($opportunityID)
            ->setInvBlockCompanyID($invBlockCompanyID)
            ->setRestrictedBookingCodeList($restrictedBookingCodeList)
            ->setRestrictedViewingCodeList($restrictedViewingCodeList)
            ->setTransactionAction($transactionAction)
            ->setTransactionDetail($transactionDetail)
            ->setQuoteID($quoteID);
    }
    /**
     * Get HotelRef value
     * @return \StructType\HotelRef|null
     */
    public function getHotelRef()
    {
        return $this->HotelRef;
    }
    /**
     * Set HotelRef value
     * @param \StructType\HotelRef $hotelRef
     * @return \StructType\InvBlocks
     */
    public function setHotelRef(\StructType\HotelRef $hotelRef = null)
    {
        $this->HotelRef = $hotelRef;
        return $this;
    }
    /**
     * Get InvBlockDates value
     * @return \StructType\InvBlockDates|null
     */
    public function getInvBlockDates()
    {
        return $this->InvBlockDates;
    }
    /**
     * Set InvBlockDates value
     * @param \StructType\InvBlockDates $invBlockDates
     * @return \StructType\InvBlocks
     */
    public function setInvBlockDates(\StructType\InvBlockDates $invBlockDates = null)
    {
        $this->InvBlockDates = $invBlockDates;
        return $this;
    }
    /**
     * Get InvBlock value
     * @return \StructType\InvBlock[]|null
     */
    public function getInvBlock()
    {
        return $this->InvBlock;
    }
    /**
     * This method is responsible for validating the values passed to the setInvBlock method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvBlock method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvBlockForArrayConstraintsFromSetInvBlock(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invBlocksInvBlockItem) {
            // validation for constraint: itemType
            if (!$invBlocksInvBlockItem instanceof \StructType\InvBlock) {
                $invalidValues[] = is_object($invBlocksInvBlockItem) ? get_class($invBlocksInvBlockItem) : sprintf('%s(%s)', gettype($invBlocksInvBlockItem), var_export($invBlocksInvBlockItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvBlock property can only contain items of type \StructType\InvBlock, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InvBlock value
     * @throws \InvalidArgumentException
     * @param \StructType\InvBlock[] $invBlock
     * @return \StructType\InvBlocks
     */
    public function setInvBlock(array $invBlock = array())
    {
        // validation for constraint: array
        if ('' !== ($invBlockArrayErrorMessage = self::validateInvBlockForArrayConstraintsFromSetInvBlock($invBlock))) {
            throw new \InvalidArgumentException($invBlockArrayErrorMessage, __LINE__);
        }
        $this->InvBlock = $invBlock;
        return $this;
    }
    /**
     * Add item to InvBlock value
     * @throws \InvalidArgumentException
     * @param \StructType\InvBlock $item
     * @return \StructType\InvBlocks
     */
    public function addToInvBlock(\StructType\InvBlock $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InvBlock) {
            throw new \InvalidArgumentException(sprintf('The InvBlock property can only contain items of type \StructType\InvBlock, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvBlock[] = $item;
        return $this;
    }
    /**
     * Get Contacts value
     * @return \ArrayType\ArrayOfContactPersonType|null
     */
    public function getContacts()
    {
        return $this->Contacts;
    }
    /**
     * Set Contacts value
     * @param \ArrayType\ArrayOfContactPersonType $contacts
     * @return \StructType\InvBlocks
     */
    public function setContacts(\ArrayType\ArrayOfContactPersonType $contacts = null)
    {
        $this->Contacts = $contacts;
        return $this;
    }
    /**
     * Get BookingStatus value
     * @return string|null
     */
    public function getBookingStatus()
    {
        return $this->BookingStatus;
    }
    /**
     * Set BookingStatus value
     * @param string $bookingStatus
     * @return \StructType\InvBlocks
     */
    public function setBookingStatus($bookingStatus = null)
    {
        // validation for constraint: string
        if (!is_null($bookingStatus) && !is_string($bookingStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingStatus, true), gettype($bookingStatus)), __LINE__);
        }
        $this->BookingStatus = $bookingStatus;
        return $this;
    }
    /**
     * Get InvBlockTypeCode value
     * @return string|null
     */
    public function getInvBlockTypeCode()
    {
        return $this->InvBlockTypeCode;
    }
    /**
     * Set InvBlockTypeCode value
     * @param string $invBlockTypeCode
     * @return \StructType\InvBlocks
     */
    public function setInvBlockTypeCode($invBlockTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($invBlockTypeCode) && !is_string($invBlockTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invBlockTypeCode, true), gettype($invBlockTypeCode)), __LINE__);
        }
        $this->InvBlockTypeCode = $invBlockTypeCode;
        return $this;
    }
    /**
     * Get InvBlockCode value
     * @return string|null
     */
    public function getInvBlockCode()
    {
        return $this->InvBlockCode;
    }
    /**
     * Set InvBlockCode value
     * @param string $invBlockCode
     * @return \StructType\InvBlocks
     */
    public function setInvBlockCode($invBlockCode = null)
    {
        // validation for constraint: string
        if (!is_null($invBlockCode) && !is_string($invBlockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invBlockCode, true), gettype($invBlockCode)), __LINE__);
        }
        $this->InvBlockCode = $invBlockCode;
        return $this;
    }
    /**
     * Get InvBlockGroupingCode value
     * @return string|null
     */
    public function getInvBlockGroupingCode()
    {
        return $this->InvBlockGroupingCode;
    }
    /**
     * Set InvBlockGroupingCode value
     * @param string $invBlockGroupingCode
     * @return \StructType\InvBlocks
     */
    public function setInvBlockGroupingCode($invBlockGroupingCode = null)
    {
        // validation for constraint: string
        if (!is_null($invBlockGroupingCode) && !is_string($invBlockGroupingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invBlockGroupingCode, true), gettype($invBlockGroupingCode)), __LINE__);
        }
        $this->InvBlockGroupingCode = $invBlockGroupingCode;
        return $this;
    }
    /**
     * Get InvBlockName value
     * @return string|null
     */
    public function getInvBlockName()
    {
        return $this->InvBlockName;
    }
    /**
     * Set InvBlockName value
     * @param string $invBlockName
     * @return \StructType\InvBlocks
     */
    public function setInvBlockName($invBlockName = null)
    {
        // validation for constraint: string
        if (!is_null($invBlockName) && !is_string($invBlockName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invBlockName, true), gettype($invBlockName)), __LINE__);
        }
        $this->InvBlockName = $invBlockName;
        return $this;
    }
    /**
     * Get InvBlockLongName value
     * @return string|null
     */
    public function getInvBlockLongName()
    {
        return $this->InvBlockLongName;
    }
    /**
     * Set InvBlockLongName value
     * @param string $invBlockLongName
     * @return \StructType\InvBlocks
     */
    public function setInvBlockLongName($invBlockLongName = null)
    {
        // validation for constraint: string
        if (!is_null($invBlockLongName) && !is_string($invBlockLongName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invBlockLongName, true), gettype($invBlockLongName)), __LINE__);
        }
        $this->InvBlockLongName = $invBlockLongName;
        return $this;
    }
    /**
     * Get InvBlockStatusCode value
     * @return string|null
     */
    public function getInvBlockStatusCode()
    {
        return $this->InvBlockStatusCode;
    }
    /**
     * Set InvBlockStatusCode value
     * @param string $invBlockStatusCode
     * @return \StructType\InvBlocks
     */
    public function setInvBlockStatusCode($invBlockStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($invBlockStatusCode) && !is_string($invBlockStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invBlockStatusCode, true), gettype($invBlockStatusCode)), __LINE__);
        }
        $this->InvBlockStatusCode = $invBlockStatusCode;
        return $this;
    }
    /**
     * Get PMS_InvBlockID value
     * @return string|null
     */
    public function getPMS_InvBlockID()
    {
        return $this->PMS_InvBlockID;
    }
    /**
     * Set PMS_InvBlockID value
     * @param string $pMS_InvBlockID
     * @return \StructType\InvBlocks
     */
    public function setPMS_InvBlockID($pMS_InvBlockID = null)
    {
        // validation for constraint: string
        if (!is_null($pMS_InvBlockID) && !is_string($pMS_InvBlockID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pMS_InvBlockID, true), gettype($pMS_InvBlockID)), __LINE__);
        }
        $this->PMS_InvBlockID = $pMS_InvBlockID;
        return $this;
    }
    /**
     * Get OpportunityID value
     * @return string|null
     */
    public function getOpportunityID()
    {
        return $this->OpportunityID;
    }
    /**
     * Set OpportunityID value
     * @param string $opportunityID
     * @return \StructType\InvBlocks
     */
    public function setOpportunityID($opportunityID = null)
    {
        // validation for constraint: string
        if (!is_null($opportunityID) && !is_string($opportunityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($opportunityID, true), gettype($opportunityID)), __LINE__);
        }
        $this->OpportunityID = $opportunityID;
        return $this;
    }
    /**
     * Get InvBlockCompanyID value
     * @return string|null
     */
    public function getInvBlockCompanyID()
    {
        return $this->InvBlockCompanyID;
    }
    /**
     * Set InvBlockCompanyID value
     * @param string $invBlockCompanyID
     * @return \StructType\InvBlocks
     */
    public function setInvBlockCompanyID($invBlockCompanyID = null)
    {
        // validation for constraint: string
        if (!is_null($invBlockCompanyID) && !is_string($invBlockCompanyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invBlockCompanyID, true), gettype($invBlockCompanyID)), __LINE__);
        }
        $this->InvBlockCompanyID = $invBlockCompanyID;
        return $this;
    }
    /**
     * Get RestrictedBookingCodeList value
     * @return string[]|null
     */
    public function getRestrictedBookingCodeList()
    {
        return $this->RestrictedBookingCodeList;
    }
    /**
     * This method is responsible for validating the values passed to the setRestrictedBookingCodeList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRestrictedBookingCodeList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRestrictedBookingCodeListForArrayConstraintsFromSetRestrictedBookingCodeList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invBlocksRestrictedBookingCodeListItem) {
            // validation for constraint: itemType
            if (!is_string($invBlocksRestrictedBookingCodeListItem)) {
                $invalidValues[] = is_object($invBlocksRestrictedBookingCodeListItem) ? get_class($invBlocksRestrictedBookingCodeListItem) : sprintf('%s(%s)', gettype($invBlocksRestrictedBookingCodeListItem), var_export($invBlocksRestrictedBookingCodeListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RestrictedBookingCodeList property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RestrictedBookingCodeList value
     * @throws \InvalidArgumentException
     * @param string[] $restrictedBookingCodeList
     * @return \StructType\InvBlocks
     */
    public function setRestrictedBookingCodeList(array $restrictedBookingCodeList = array())
    {
        // validation for constraint: array
        if ('' !== ($restrictedBookingCodeListArrayErrorMessage = self::validateRestrictedBookingCodeListForArrayConstraintsFromSetRestrictedBookingCodeList($restrictedBookingCodeList))) {
            throw new \InvalidArgumentException($restrictedBookingCodeListArrayErrorMessage, __LINE__);
        }
        $this->RestrictedBookingCodeList = $restrictedBookingCodeList;
        return $this;
    }
    /**
     * Add item to RestrictedBookingCodeList value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\InvBlocks
     */
    public function addToRestrictedBookingCodeList($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The RestrictedBookingCodeList property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RestrictedBookingCodeList[] = $item;
        return $this;
    }
    /**
     * Get RestrictedViewingCodeList value
     * @return string[]|null
     */
    public function getRestrictedViewingCodeList()
    {
        return $this->RestrictedViewingCodeList;
    }
    /**
     * This method is responsible for validating the values passed to the setRestrictedViewingCodeList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRestrictedViewingCodeList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRestrictedViewingCodeListForArrayConstraintsFromSetRestrictedViewingCodeList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invBlocksRestrictedViewingCodeListItem) {
            // validation for constraint: itemType
            if (!is_string($invBlocksRestrictedViewingCodeListItem)) {
                $invalidValues[] = is_object($invBlocksRestrictedViewingCodeListItem) ? get_class($invBlocksRestrictedViewingCodeListItem) : sprintf('%s(%s)', gettype($invBlocksRestrictedViewingCodeListItem), var_export($invBlocksRestrictedViewingCodeListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RestrictedViewingCodeList property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RestrictedViewingCodeList value
     * @throws \InvalidArgumentException
     * @param string[] $restrictedViewingCodeList
     * @return \StructType\InvBlocks
     */
    public function setRestrictedViewingCodeList(array $restrictedViewingCodeList = array())
    {
        // validation for constraint: array
        if ('' !== ($restrictedViewingCodeListArrayErrorMessage = self::validateRestrictedViewingCodeListForArrayConstraintsFromSetRestrictedViewingCodeList($restrictedViewingCodeList))) {
            throw new \InvalidArgumentException($restrictedViewingCodeListArrayErrorMessage, __LINE__);
        }
        $this->RestrictedViewingCodeList = $restrictedViewingCodeList;
        return $this;
    }
    /**
     * Add item to RestrictedViewingCodeList value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\InvBlocks
     */
    public function addToRestrictedViewingCodeList($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The RestrictedViewingCodeList property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RestrictedViewingCodeList[] = $item;
        return $this;
    }
    /**
     * Get TransactionAction value
     * @return string|null
     */
    public function getTransactionAction()
    {
        return $this->TransactionAction;
    }
    /**
     * Set TransactionAction value
     * @uses \EnumType\TransactionActionType::valueIsValid()
     * @uses \EnumType\TransactionActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionAction
     * @return \StructType\InvBlocks
     */
    public function setTransactionAction($transactionAction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransactionActionType::valueIsValid($transactionAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TransactionActionType', is_array($transactionAction) ? implode(', ', $transactionAction) : var_export($transactionAction, true), implode(', ', \EnumType\TransactionActionType::getValidValues())), __LINE__);
        }
        $this->TransactionAction = $transactionAction;
        return $this;
    }
    /**
     * Get TransactionDetail value
     * @return string|null
     */
    public function getTransactionDetail()
    {
        return $this->TransactionDetail;
    }
    /**
     * Set TransactionDetail value
     * @param string $transactionDetail
     * @return \StructType\InvBlocks
     */
    public function setTransactionDetail($transactionDetail = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDetail) && !is_string($transactionDetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionDetail, true), gettype($transactionDetail)), __LINE__);
        }
        $this->TransactionDetail = $transactionDetail;
        return $this;
    }
    /**
     * Get QuoteID value
     * @return string|null
     */
    public function getQuoteID()
    {
        return $this->QuoteID;
    }
    /**
     * Set QuoteID value
     * @param string $quoteID
     * @return \StructType\InvBlocks
     */
    public function setQuoteID($quoteID = null)
    {
        // validation for constraint: string
        if (!is_null($quoteID) && !is_string($quoteID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quoteID, true), gettype($quoteID)), __LINE__);
        }
        $this->QuoteID = $quoteID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvBlocks
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
