<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GuestRoom StructType
 * @subpackage Structs
 */
class GuestRoom extends AbstractStructBase
{
    /**
     * The TypeRoom
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TypeRoom[]
     */
    public $TypeRoom;
    /**
     * The DescriptiveText
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DescriptiveText;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The CodeContext
     * @var string
     */
    public $CodeContext;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * The URI
     * @var string
     */
    public $URI;
    /**
     * The RoomTypeName
     * @var string
     */
    public $RoomTypeName;
    /**
     * The MaxOccupancy
     * @var int
     */
    public $MaxOccupancy;
    /**
     * Constructor method for GuestRoom
     * @uses GuestRoom::setTypeRoom()
     * @uses GuestRoom::setDescriptiveText()
     * @uses GuestRoom::setCode()
     * @uses GuestRoom::setCodeContext()
     * @uses GuestRoom::setQuantity()
     * @uses GuestRoom::setURI()
     * @uses GuestRoom::setRoomTypeName()
     * @uses GuestRoom::setMaxOccupancy()
     * @param \StructType\TypeRoom[] $typeRoom
     * @param string $descriptiveText
     * @param string $code
     * @param string $codeContext
     * @param int $quantity
     * @param string $uRI
     * @param string $roomTypeName
     * @param int $maxOccupancy
     */
    public function __construct(array $typeRoom = array(), $descriptiveText = null, $code = null, $codeContext = null, $quantity = null, $uRI = null, $roomTypeName = null, $maxOccupancy = null)
    {
        $this
            ->setTypeRoom($typeRoom)
            ->setDescriptiveText($descriptiveText)
            ->setCode($code)
            ->setCodeContext($codeContext)
            ->setQuantity($quantity)
            ->setURI($uRI)
            ->setRoomTypeName($roomTypeName)
            ->setMaxOccupancy($maxOccupancy);
    }
    /**
     * Get TypeRoom value
     * @return \StructType\TypeRoom[]|null
     */
    public function getTypeRoom()
    {
        return $this->TypeRoom;
    }
    /**
     * This method is responsible for validating the values passed to the setTypeRoom method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTypeRoom method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTypeRoomForArrayConstraintsFromSetTypeRoom(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $guestRoomTypeRoomItem) {
            // validation for constraint: itemType
            if (!$guestRoomTypeRoomItem instanceof \StructType\TypeRoom) {
                $invalidValues[] = is_object($guestRoomTypeRoomItem) ? get_class($guestRoomTypeRoomItem) : sprintf('%s(%s)', gettype($guestRoomTypeRoomItem), var_export($guestRoomTypeRoomItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TypeRoom property can only contain items of type \StructType\TypeRoom, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TypeRoom value
     * @throws \InvalidArgumentException
     * @param \StructType\TypeRoom[] $typeRoom
     * @return \StructType\GuestRoom
     */
    public function setTypeRoom(array $typeRoom = array())
    {
        // validation for constraint: array
        if ('' !== ($typeRoomArrayErrorMessage = self::validateTypeRoomForArrayConstraintsFromSetTypeRoom($typeRoom))) {
            throw new \InvalidArgumentException($typeRoomArrayErrorMessage, __LINE__);
        }
        $this->TypeRoom = $typeRoom;
        return $this;
    }
    /**
     * Add item to TypeRoom value
     * @throws \InvalidArgumentException
     * @param \StructType\TypeRoom $item
     * @return \StructType\GuestRoom
     */
    public function addToTypeRoom(\StructType\TypeRoom $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TypeRoom) {
            throw new \InvalidArgumentException(sprintf('The TypeRoom property can only contain items of type \StructType\TypeRoom, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TypeRoom[] = $item;
        return $this;
    }
    /**
     * Get DescriptiveText value
     * @return string|null
     */
    public function getDescriptiveText()
    {
        return $this->DescriptiveText;
    }
    /**
     * Set DescriptiveText value
     * @param string $descriptiveText
     * @return \StructType\GuestRoom
     */
    public function setDescriptiveText($descriptiveText = null)
    {
        // validation for constraint: string
        if (!is_null($descriptiveText) && !is_string($descriptiveText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descriptiveText, true), gettype($descriptiveText)), __LINE__);
        }
        $this->DescriptiveText = $descriptiveText;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\GuestRoom
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get CodeContext value
     * @return string|null
     */
    public function getCodeContext()
    {
        return $this->CodeContext;
    }
    /**
     * Set CodeContext value
     * @param string $codeContext
     * @return \StructType\GuestRoom
     */
    public function setCodeContext($codeContext = null)
    {
        // validation for constraint: string
        if (!is_null($codeContext) && !is_string($codeContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeContext, true), gettype($codeContext)), __LINE__);
        }
        $this->CodeContext = $codeContext;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\GuestRoom
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get URI value
     * @return string|null
     */
    public function getURI()
    {
        return $this->URI;
    }
    /**
     * Set URI value
     * @param string $uRI
     * @return \StructType\GuestRoom
     */
    public function setURI($uRI = null)
    {
        // validation for constraint: string
        if (!is_null($uRI) && !is_string($uRI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRI, true), gettype($uRI)), __LINE__);
        }
        $this->URI = $uRI;
        return $this;
    }
    /**
     * Get RoomTypeName value
     * @return string|null
     */
    public function getRoomTypeName()
    {
        return $this->RoomTypeName;
    }
    /**
     * Set RoomTypeName value
     * @param string $roomTypeName
     * @return \StructType\GuestRoom
     */
    public function setRoomTypeName($roomTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($roomTypeName) && !is_string($roomTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomTypeName, true), gettype($roomTypeName)), __LINE__);
        }
        $this->RoomTypeName = $roomTypeName;
        return $this;
    }
    /**
     * Get MaxOccupancy value
     * @return int|null
     */
    public function getMaxOccupancy()
    {
        return $this->MaxOccupancy;
    }
    /**
     * Set MaxOccupancy value
     * @param int $maxOccupancy
     * @return \StructType\GuestRoom
     */
    public function setMaxOccupancy($maxOccupancy = null)
    {
        // validation for constraint: int
        if (!is_null($maxOccupancy) && !(is_int($maxOccupancy) || ctype_digit($maxOccupancy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxOccupancy, true), gettype($maxOccupancy)), __LINE__);
        }
        $this->MaxOccupancy = $maxOccupancy;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GuestRoom
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
