<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DatePrice StructType
 * @subpackage Structs
 */
class DatePrice extends AbstractStructBase
{
    /**
     * The price
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $price;
    /**
     * The date
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $date;
    /**
     * Constructor method for DatePrice
     * @uses DatePrice::setPrice()
     * @uses DatePrice::setDate()
     * @param float $price
     * @param string $date
     */
    public function __construct($price = null, $date = null)
    {
        $this
            ->setPrice($price)
            ->setDate($date);
    }
    /**
     * Get price value
     * @return float
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\DatePrice
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get date value
     * @return string
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \StructType\DatePrice
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DatePrice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
