<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BedInfo StructType
 * @subpackage Structs
 */
class BedInfo extends AbstractStructBase
{
    /**
     * The ageQualifyingCode
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ageQualifyingCode;
    /**
     * The bedId
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $bedId;
    /**
     * The quantity
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $quantity;
    /**
     * The personQuantity
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $personQuantity;
    /**
     * The totalPrice
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $totalPrice;
    /**
     * The Price
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DatePrice[]
     */
    public $Price;
    /**
     * The childBandId
     * @var int
     */
    public $childBandId;
    /**
     * Constructor method for BedInfo
     * @uses BedInfo::setAgeQualifyingCode()
     * @uses BedInfo::setBedId()
     * @uses BedInfo::setQuantity()
     * @uses BedInfo::setPersonQuantity()
     * @uses BedInfo::setTotalPrice()
     * @uses BedInfo::setPrice()
     * @uses BedInfo::setChildBandId()
     * @param string $ageQualifyingCode
     * @param int $bedId
     * @param int $quantity
     * @param int $personQuantity
     * @param float $totalPrice
     * @param \StructType\DatePrice[] $price
     * @param int $childBandId
     */
    public function __construct($ageQualifyingCode = null, $bedId = null, $quantity = null, $personQuantity = null, $totalPrice = null, array $price = array(), $childBandId = null)
    {
        $this
            ->setAgeQualifyingCode($ageQualifyingCode)
            ->setBedId($bedId)
            ->setQuantity($quantity)
            ->setPersonQuantity($personQuantity)
            ->setTotalPrice($totalPrice)
            ->setPrice($price)
            ->setChildBandId($childBandId);
    }
    /**
     * Get ageQualifyingCode value
     * @return string
     */
    public function getAgeQualifyingCode()
    {
        return $this->ageQualifyingCode;
    }
    /**
     * Set ageQualifyingCode value
     * @uses \EnumType\AgeQualifyingEnum::valueIsValid()
     * @uses \EnumType\AgeQualifyingEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ageQualifyingCode
     * @return \StructType\BedInfo
     */
    public function setAgeQualifyingCode($ageQualifyingCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AgeQualifyingEnum::valueIsValid($ageQualifyingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AgeQualifyingEnum', is_array($ageQualifyingCode) ? implode(', ', $ageQualifyingCode) : var_export($ageQualifyingCode, true), implode(', ', \EnumType\AgeQualifyingEnum::getValidValues())), __LINE__);
        }
        $this->ageQualifyingCode = $ageQualifyingCode;
        return $this;
    }
    /**
     * Get bedId value
     * @return int
     */
    public function getBedId()
    {
        return $this->bedId;
    }
    /**
     * Set bedId value
     * @param int $bedId
     * @return \StructType\BedInfo
     */
    public function setBedId($bedId = null)
    {
        // validation for constraint: int
        if (!is_null($bedId) && !(is_int($bedId) || ctype_digit($bedId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bedId, true), gettype($bedId)), __LINE__);
        }
        $this->bedId = $bedId;
        return $this;
    }
    /**
     * Get quantity value
     * @return int
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \StructType\BedInfo
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get personQuantity value
     * @return int
     */
    public function getPersonQuantity()
    {
        return $this->personQuantity;
    }
    /**
     * Set personQuantity value
     * @param int $personQuantity
     * @return \StructType\BedInfo
     */
    public function setPersonQuantity($personQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($personQuantity) && !(is_int($personQuantity) || ctype_digit($personQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personQuantity, true), gettype($personQuantity)), __LINE__);
        }
        $this->personQuantity = $personQuantity;
        return $this;
    }
    /**
     * Get totalPrice value
     * @return float
     */
    public function getTotalPrice()
    {
        return $this->totalPrice;
    }
    /**
     * Set totalPrice value
     * @param float $totalPrice
     * @return \StructType\BedInfo
     */
    public function setTotalPrice($totalPrice = null)
    {
        // validation for constraint: float
        if (!is_null($totalPrice) && !(is_float($totalPrice) || is_numeric($totalPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalPrice, true), gettype($totalPrice)), __LINE__);
        }
        $this->totalPrice = $totalPrice;
        return $this;
    }
    /**
     * Get Price value
     * @return \StructType\DatePrice[]|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * This method is responsible for validating the values passed to the setPrice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrice method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePriceForArrayConstraintsFromSetPrice(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bedInfoPriceItem) {
            // validation for constraint: itemType
            if (!$bedInfoPriceItem instanceof \StructType\DatePrice) {
                $invalidValues[] = is_object($bedInfoPriceItem) ? get_class($bedInfoPriceItem) : sprintf('%s(%s)', gettype($bedInfoPriceItem), var_export($bedInfoPriceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Price property can only contain items of type \StructType\DatePrice, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Price value
     * @throws \InvalidArgumentException
     * @param \StructType\DatePrice[] $price
     * @return \StructType\BedInfo
     */
    public function setPrice(array $price = array())
    {
        // validation for constraint: array
        if ('' !== ($priceArrayErrorMessage = self::validatePriceForArrayConstraintsFromSetPrice($price))) {
            throw new \InvalidArgumentException($priceArrayErrorMessage, __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Add item to Price value
     * @throws \InvalidArgumentException
     * @param \StructType\DatePrice $item
     * @return \StructType\BedInfo
     */
    public function addToPrice(\StructType\DatePrice $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DatePrice) {
            throw new \InvalidArgumentException(sprintf('The Price property can only contain items of type \StructType\DatePrice, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Price[] = $item;
        return $this;
    }
    /**
     * Get childBandId value
     * @return int|null
     */
    public function getChildBandId()
    {
        return $this->childBandId;
    }
    /**
     * Set childBandId value
     * @param int $childBandId
     * @return \StructType\BedInfo
     */
    public function setChildBandId($childBandId = null)
    {
        // validation for constraint: int
        if (!is_null($childBandId) && !(is_int($childBandId) || ctype_digit($childBandId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($childBandId, true), gettype($childBandId)), __LINE__);
        }
        $this->childBandId = $childBandId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BedInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
