<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BankAcctType StructType
 * @subpackage Structs
 */
class BankAcctType extends AbstractStructBase
{
    /**
     * The BankAcctName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankAcctName;
    /**
     * The BankAcctNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EncryptionTokenType
     */
    public $BankAcctNumber;
    /**
     * The BankID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EncryptionTokenType
     */
    public $BankID;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\List_BankAccountType
     */
    public $Type;
    /**
     * The ChecksAcceptedInd
     * @var bool
     */
    public $ChecksAcceptedInd;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The CheckNumber
     * @var string
     */
    public $CheckNumber;
    /**
     * Constructor method for BankAcctType
     * @uses BankAcctType::setBankAcctName()
     * @uses BankAcctType::setBankAcctNumber()
     * @uses BankAcctType::setBankID()
     * @uses BankAcctType::setType()
     * @uses BankAcctType::setChecksAcceptedInd()
     * @uses BankAcctType::setShareSynchInd()
     * @uses BankAcctType::setShareMarketInd()
     * @uses BankAcctType::setCheckNumber()
     * @param string $bankAcctName
     * @param \StructType\EncryptionTokenType $bankAcctNumber
     * @param \StructType\EncryptionTokenType $bankID
     * @param \StructType\List_BankAccountType $type
     * @param bool $checksAcceptedInd
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $checkNumber
     */
    public function __construct($bankAcctName = null, \StructType\EncryptionTokenType $bankAcctNumber = null, \StructType\EncryptionTokenType $bankID = null, \StructType\List_BankAccountType $type = null, $checksAcceptedInd = null, $shareSynchInd = null, $shareMarketInd = null, $checkNumber = null)
    {
        $this
            ->setBankAcctName($bankAcctName)
            ->setBankAcctNumber($bankAcctNumber)
            ->setBankID($bankID)
            ->setType($type)
            ->setChecksAcceptedInd($checksAcceptedInd)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setCheckNumber($checkNumber);
    }
    /**
     * Get BankAcctName value
     * @return string|null
     */
    public function getBankAcctName()
    {
        return $this->BankAcctName;
    }
    /**
     * Set BankAcctName value
     * @param string $bankAcctName
     * @return \StructType\BankAcctType
     */
    public function setBankAcctName($bankAcctName = null)
    {
        // validation for constraint: string
        if (!is_null($bankAcctName) && !is_string($bankAcctName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankAcctName, true), gettype($bankAcctName)), __LINE__);
        }
        $this->BankAcctName = $bankAcctName;
        return $this;
    }
    /**
     * Get BankAcctNumber value
     * @return \StructType\EncryptionTokenType|null
     */
    public function getBankAcctNumber()
    {
        return $this->BankAcctNumber;
    }
    /**
     * Set BankAcctNumber value
     * @param \StructType\EncryptionTokenType $bankAcctNumber
     * @return \StructType\BankAcctType
     */
    public function setBankAcctNumber(\StructType\EncryptionTokenType $bankAcctNumber = null)
    {
        $this->BankAcctNumber = $bankAcctNumber;
        return $this;
    }
    /**
     * Get BankID value
     * @return \StructType\EncryptionTokenType|null
     */
    public function getBankID()
    {
        return $this->BankID;
    }
    /**
     * Set BankID value
     * @param \StructType\EncryptionTokenType $bankID
     * @return \StructType\BankAcctType
     */
    public function setBankID(\StructType\EncryptionTokenType $bankID = null)
    {
        $this->BankID = $bankID;
        return $this;
    }
    /**
     * Get Type value
     * @return \StructType\List_BankAccountType|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param \StructType\List_BankAccountType $type
     * @return \StructType\BankAcctType
     */
    public function setType(\StructType\List_BankAccountType $type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get ChecksAcceptedInd value
     * @return bool|null
     */
    public function getChecksAcceptedInd()
    {
        return $this->ChecksAcceptedInd;
    }
    /**
     * Set ChecksAcceptedInd value
     * @param bool $checksAcceptedInd
     * @return \StructType\BankAcctType
     */
    public function setChecksAcceptedInd($checksAcceptedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($checksAcceptedInd) && !is_bool($checksAcceptedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($checksAcceptedInd, true), gettype($checksAcceptedInd)), __LINE__);
        }
        $this->ChecksAcceptedInd = $checksAcceptedInd;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \StructType\BankAcctType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareSynchInd, true), gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \StructType\BankAcctType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareMarketInd, true), gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get CheckNumber value
     * @return string|null
     */
    public function getCheckNumber()
    {
        return $this->CheckNumber;
    }
    /**
     * Set CheckNumber value
     * @param string $checkNumber
     * @return \StructType\BankAcctType
     */
    public function setCheckNumber($checkNumber = null)
    {
        // validation for constraint: string
        if (!is_null($checkNumber) && !is_string($checkNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkNumber, true), gettype($checkNumber)), __LINE__);
        }
        $this->CheckNumber = $checkNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BankAcctType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
