<?php

namespace EnumType;

/**
 * This class stands for TransferInfoItemKind EnumType
 * @subpackage Enumerations
 */
class TransferInfoItemKind
{
    /**
     * Constant for value 'Airport'
     * @return string 'Airport'
     */
    const VALUE_AIRPORT = 'Airport';
    /**
     * Constant for value 'Airline'
     * @return string 'Airline'
     */
    const VALUE_AIRLINE = 'Airline';
    /**
     * Constant for value 'FlightNumber'
     * @return string 'FlightNumber'
     */
    const VALUE_FLIGHT_NUMBER = 'FlightNumber';
    /**
     * Constant for value 'DepartureLocation'
     * @return string 'DepartureLocation'
     */
    const VALUE_DEPARTURE_LOCATION = 'DepartureLocation';
    /**
     * Constant for value 'BusStation'
     * @return string 'BusStation'
     */
    const VALUE_BUS_STATION = 'BusStation';
    /**
     * Constant for value 'BusNumber'
     * @return string 'BusNumber'
     */
    const VALUE_BUS_NUMBER = 'BusNumber';
    /**
     * Constant for value 'RailwayStation'
     * @return string 'RailwayStation'
     */
    const VALUE_RAILWAY_STATION = 'RailwayStation';
    /**
     * Constant for value 'TrainNumber'
     * @return string 'TrainNumber'
     */
    const VALUE_TRAIN_NUMBER = 'TrainNumber';
    /**
     * Constant for value 'WagonNumber'
     * @return string 'WagonNumber'
     */
    const VALUE_WAGON_NUMBER = 'WagonNumber';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AIRPORT
     * @uses self::VALUE_AIRLINE
     * @uses self::VALUE_FLIGHT_NUMBER
     * @uses self::VALUE_DEPARTURE_LOCATION
     * @uses self::VALUE_BUS_STATION
     * @uses self::VALUE_BUS_NUMBER
     * @uses self::VALUE_RAILWAY_STATION
     * @uses self::VALUE_TRAIN_NUMBER
     * @uses self::VALUE_WAGON_NUMBER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AIRPORT,
            self::VALUE_AIRLINE,
            self::VALUE_FLIGHT_NUMBER,
            self::VALUE_DEPARTURE_LOCATION,
            self::VALUE_BUS_STATION,
            self::VALUE_BUS_NUMBER,
            self::VALUE_RAILWAY_STATION,
            self::VALUE_TRAIN_NUMBER,
            self::VALUE_WAGON_NUMBER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
