<?php

namespace EnumType;

/**
 * This class stands for AgeQualifyingEnum EnumType
 * @subpackage Enumerations
 */
class AgeQualifyingEnum
{
    /**
     * Constant for value 'Additional occupant with adult'
     * @return string 'Additional occupant with adult'
     */
    const VALUE_ADDITIONAL_OCCUPANT_WITH_ADULT = 'Additional occupant with adult';
    /**
     * Constant for value 'Additional occupant without adult'
     * @return string 'Additional occupant without adult'
     */
    const VALUE_ADDITIONAL_OCCUPANT_WITHOUT_ADULT = 'Additional occupant without adult';
    /**
     * Constant for value 'Adult'
     * @return string 'Adult'
     */
    const VALUE_ADULT = 'Adult';
    /**
     * Constant for value 'Child'
     * @return string 'Child'
     */
    const VALUE_CHILD = 'Child';
    /**
     * Constant for value 'Free adult'
     * @return string 'Free adult'
     */
    const VALUE_FREE_ADULT = 'Free adult';
    /**
     * Constant for value 'Free child'
     * @return string 'Free child'
     */
    const VALUE_FREE_CHILD = 'Free child';
    /**
     * Constant for value 'Infant'
     * @return string 'Infant'
     */
    const VALUE_INFANT = 'Infant';
    /**
     * Constant for value 'Over 21'
     * @return string 'Over 21'
     */
    const VALUE_OVER_21 = 'Over 21';
    /**
     * Constant for value 'Over 65'
     * @return string 'Over 65'
     */
    const VALUE_OVER_65 = 'Over 65';
    /**
     * Constant for value 'Senior '
     * @return string 'Senior '
     */
    const VALUE_SENIOR = 'Senior ';
    /**
     * Constant for value 'Teenager'
     * @return string 'Teenager'
     */
    const VALUE_TEENAGER = 'Teenager';
    /**
     * Constant for value 'Under 10'
     * @return string 'Under 10'
     */
    const VALUE_UNDER_10 = 'Under 10';
    /**
     * Constant for value 'Under 12'
     * @return string 'Under 12'
     */
    const VALUE_UNDER_12 = 'Under 12';
    /**
     * Constant for value 'Under 17'
     * @return string 'Under 17'
     */
    const VALUE_UNDER_17 = 'Under 17';
    /**
     * Constant for value 'Under 2'
     * @return string 'Under 2'
     */
    const VALUE_UNDER_2 = 'Under 2';
    /**
     * Constant for value 'Under 21'
     * @return string 'Under 21'
     */
    const VALUE_UNDER_21 = 'Under 21';
    /**
     * Constant for value 'Young driver'
     * @return string 'Young driver'
     */
    const VALUE_YOUNG_DRIVER = 'Young driver';
    /**
     * Constant for value 'Younger driver'
     * @return string 'Younger driver'
     */
    const VALUE_YOUNGER_DRIVER = 'Younger driver';
    /**
     * Constant for value 'Other_'
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ADDITIONAL_OCCUPANT_WITH_ADULT
     * @uses self::VALUE_ADDITIONAL_OCCUPANT_WITHOUT_ADULT
     * @uses self::VALUE_ADULT
     * @uses self::VALUE_CHILD
     * @uses self::VALUE_FREE_ADULT
     * @uses self::VALUE_FREE_CHILD
     * @uses self::VALUE_INFANT
     * @uses self::VALUE_OVER_21
     * @uses self::VALUE_OVER_65
     * @uses self::VALUE_SENIOR
     * @uses self::VALUE_TEENAGER
     * @uses self::VALUE_UNDER_10
     * @uses self::VALUE_UNDER_12
     * @uses self::VALUE_UNDER_17
     * @uses self::VALUE_UNDER_2
     * @uses self::VALUE_UNDER_21
     * @uses self::VALUE_YOUNG_DRIVER
     * @uses self::VALUE_YOUNGER_DRIVER
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ADDITIONAL_OCCUPANT_WITH_ADULT,
            self::VALUE_ADDITIONAL_OCCUPANT_WITHOUT_ADULT,
            self::VALUE_ADULT,
            self::VALUE_CHILD,
            self::VALUE_FREE_ADULT,
            self::VALUE_FREE_CHILD,
            self::VALUE_INFANT,
            self::VALUE_OVER_21,
            self::VALUE_OVER_65,
            self::VALUE_SENIOR,
            self::VALUE_TEENAGER,
            self::VALUE_UNDER_10,
            self::VALUE_UNDER_12,
            self::VALUE_UNDER_17,
            self::VALUE_UNDER_2,
            self::VALUE_UNDER_21,
            self::VALUE_YOUNG_DRIVER,
            self::VALUE_YOUNGER_DRIVER,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
