<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxInformation StructType
 * @subpackage Structs
 */
class TaxInformation extends AbstractStructBase
{
    /**
     * The TaxType
     * @var string
     */
    public $TaxType;
    /**
     * The TaxReason
     * @var string
     */
    public $TaxReason;
    /**
     * The TaxID
     * @var string
     */
    public $TaxID;
    /**
     * Constructor method for TaxInformation
     * @uses TaxInformation::setTaxType()
     * @uses TaxInformation::setTaxReason()
     * @uses TaxInformation::setTaxID()
     * @param string $taxType
     * @param string $taxReason
     * @param string $taxID
     */
    public function __construct($taxType = null, $taxReason = null, $taxID = null)
    {
        $this
            ->setTaxType($taxType)
            ->setTaxReason($taxReason)
            ->setTaxID($taxID);
    }
    /**
     * Get TaxType value
     * @return string|null
     */
    public function getTaxType()
    {
        return $this->TaxType;
    }
    /**
     * Set TaxType value
     * @param string $taxType
     * @return \StructType\TaxInformation
     */
    public function setTaxType($taxType = null)
    {
        // validation for constraint: string
        if (!is_null($taxType) && !is_string($taxType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxType, true), gettype($taxType)), __LINE__);
        }
        $this->TaxType = $taxType;
        return $this;
    }
    /**
     * Get TaxReason value
     * @return string|null
     */
    public function getTaxReason()
    {
        return $this->TaxReason;
    }
    /**
     * Set TaxReason value
     * @param string $taxReason
     * @return \StructType\TaxInformation
     */
    public function setTaxReason($taxReason = null)
    {
        // validation for constraint: string
        if (!is_null($taxReason) && !is_string($taxReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxReason, true), gettype($taxReason)), __LINE__);
        }
        $this->TaxReason = $taxReason;
        return $this;
    }
    /**
     * Get TaxID value
     * @return string|null
     */
    public function getTaxID()
    {
        return $this->TaxID;
    }
    /**
     * Set TaxID value
     * @param string $taxID
     * @return \StructType\TaxInformation
     */
    public function setTaxID($taxID = null)
    {
        // validation for constraint: string
        if (!is_null($taxID) && !is_string($taxID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxID, true), gettype($taxID)), __LINE__);
        }
        $this->TaxID = $taxID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TaxInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
