<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TPA_ExtensionsType StructType
 * @subpackage Structs
 */
class TPA_ExtensionsType extends AbstractStructBase
{
    /**
     * The BookingWebSource
     * Meta informations extracted from the WSDL
     * - choice: BookingWebSource | OxiReservationExt | Shelter | TLWebPmsReservationExtensions | TLWebPmsRoomTypeExtensions | TLWebPmsServiceExtensions
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BookingWebSource
     */
    public $BookingWebSource;
    /**
     * The OxiReservationExt
     * Meta informations extracted from the WSDL
     * - choice: BookingWebSource | OxiReservationExt | Shelter | TLWebPmsReservationExtensions | TLWebPmsRoomTypeExtensions | TLWebPmsServiceExtensions
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OxiReservationExt
     */
    public $OxiReservationExt;
    /**
     * The Shelter
     * Meta informations extracted from the WSDL
     * - choice: BookingWebSource | OxiReservationExt | Shelter | TLWebPmsReservationExtensions | TLWebPmsRoomTypeExtensions | TLWebPmsServiceExtensions
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Shelter
     */
    public $Shelter;
    /**
     * The TLWebPmsReservationExtensions
     * Meta informations extracted from the WSDL
     * - choice: BookingWebSource | OxiReservationExt | Shelter | TLWebPmsReservationExtensions | TLWebPmsRoomTypeExtensions | TLWebPmsServiceExtensions
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TLWebPmsReservationExtensions
     */
    public $TLWebPmsReservationExtensions;
    /**
     * The TLWebPmsRoomTypeExtensions
     * Meta informations extracted from the WSDL
     * - choice: BookingWebSource | OxiReservationExt | Shelter | TLWebPmsReservationExtensions | TLWebPmsRoomTypeExtensions | TLWebPmsServiceExtensions
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TLWebPmsRoomTypeExtensions
     */
    public $TLWebPmsRoomTypeExtensions;
    /**
     * The TLWebPmsServiceExtensions
     * Meta informations extracted from the WSDL
     * - choice: BookingWebSource | OxiReservationExt | Shelter | TLWebPmsReservationExtensions | TLWebPmsRoomTypeExtensions | TLWebPmsServiceExtensions
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TLWebPmsServiceExtensions
     */
    public $TLWebPmsServiceExtensions;
    /**
     * Constructor method for TPA_ExtensionsType
     * @uses TPA_ExtensionsType::setBookingWebSource()
     * @uses TPA_ExtensionsType::setOxiReservationExt()
     * @uses TPA_ExtensionsType::setShelter()
     * @uses TPA_ExtensionsType::setTLWebPmsReservationExtensions()
     * @uses TPA_ExtensionsType::setTLWebPmsRoomTypeExtensions()
     * @uses TPA_ExtensionsType::setTLWebPmsServiceExtensions()
     * @param \StructType\BookingWebSource $bookingWebSource
     * @param \StructType\OxiReservationExt $oxiReservationExt
     * @param \StructType\Shelter $shelter
     * @param \StructType\TLWebPmsReservationExtensions $tLWebPmsReservationExtensions
     * @param \StructType\TLWebPmsRoomTypeExtensions $tLWebPmsRoomTypeExtensions
     * @param \StructType\TLWebPmsServiceExtensions $tLWebPmsServiceExtensions
     */
    public function __construct(\StructType\BookingWebSource $bookingWebSource = null, \StructType\OxiReservationExt $oxiReservationExt = null, \StructType\Shelter $shelter = null, \StructType\TLWebPmsReservationExtensions $tLWebPmsReservationExtensions = null, \StructType\TLWebPmsRoomTypeExtensions $tLWebPmsRoomTypeExtensions = null, \StructType\TLWebPmsServiceExtensions $tLWebPmsServiceExtensions = null)
    {
        $this
            ->setBookingWebSource($bookingWebSource)
            ->setOxiReservationExt($oxiReservationExt)
            ->setShelter($shelter)
            ->setTLWebPmsReservationExtensions($tLWebPmsReservationExtensions)
            ->setTLWebPmsRoomTypeExtensions($tLWebPmsRoomTypeExtensions)
            ->setTLWebPmsServiceExtensions($tLWebPmsServiceExtensions);
    }
    /**
     * Get BookingWebSource value
     * @return \StructType\BookingWebSource|null
     */
    public function getBookingWebSource()
    {
        return isset($this->BookingWebSource) ? $this->BookingWebSource : null;
    }
    /**
     * This method is responsible for validating the value passed to the setBookingWebSource method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBookingWebSource method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBookingWebSourceForChoiceConstraintsFromSetBookingWebSource($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'OxiReservationExt',
            'Shelter',
            'TLWebPmsReservationExtensions',
            'TLWebPmsRoomTypeExtensions',
            'TLWebPmsServiceExtensions',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property BookingWebSource can\'t be set as the property %s is already set. Only one property must be set among these properties: BookingWebSource, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set BookingWebSource value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BookingWebSource $bookingWebSource
     * @return \StructType\TPA_ExtensionsType
     */
    public function setBookingWebSource(\StructType\BookingWebSource $bookingWebSource = null)
    {
        // validation for constraint: choice(BookingWebSource, OxiReservationExt, Shelter, TLWebPmsReservationExtensions, TLWebPmsRoomTypeExtensions, TLWebPmsServiceExtensions)
        if ('' !== ($bookingWebSourceChoiceErrorMessage = self::validateBookingWebSourceForChoiceConstraintsFromSetBookingWebSource($bookingWebSource))) {
            throw new \InvalidArgumentException($bookingWebSourceChoiceErrorMessage, __LINE__);
        }
        if (is_null($bookingWebSource) || (is_array($bookingWebSource) && empty($bookingWebSource))) {
            unset($this->BookingWebSource);
        } else {
            $this->BookingWebSource = $bookingWebSource;
        }
        return $this;
    }
    /**
     * Get OxiReservationExt value
     * @return \StructType\OxiReservationExt|null
     */
    public function getOxiReservationExt()
    {
        return isset($this->OxiReservationExt) ? $this->OxiReservationExt : null;
    }
    /**
     * This method is responsible for validating the value passed to the setOxiReservationExt method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOxiReservationExt method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateOxiReservationExtForChoiceConstraintsFromSetOxiReservationExt($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BookingWebSource',
            'Shelter',
            'TLWebPmsReservationExtensions',
            'TLWebPmsRoomTypeExtensions',
            'TLWebPmsServiceExtensions',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property OxiReservationExt can\'t be set as the property %s is already set. Only one property must be set among these properties: OxiReservationExt, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set OxiReservationExt value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OxiReservationExt $oxiReservationExt
     * @return \StructType\TPA_ExtensionsType
     */
    public function setOxiReservationExt(\StructType\OxiReservationExt $oxiReservationExt = null)
    {
        // validation for constraint: choice(BookingWebSource, OxiReservationExt, Shelter, TLWebPmsReservationExtensions, TLWebPmsRoomTypeExtensions, TLWebPmsServiceExtensions)
        if ('' !== ($oxiReservationExtChoiceErrorMessage = self::validateOxiReservationExtForChoiceConstraintsFromSetOxiReservationExt($oxiReservationExt))) {
            throw new \InvalidArgumentException($oxiReservationExtChoiceErrorMessage, __LINE__);
        }
        if (is_null($oxiReservationExt) || (is_array($oxiReservationExt) && empty($oxiReservationExt))) {
            unset($this->OxiReservationExt);
        } else {
            $this->OxiReservationExt = $oxiReservationExt;
        }
        return $this;
    }
    /**
     * Get Shelter value
     * @return \StructType\Shelter|null
     */
    public function getShelter()
    {
        return isset($this->Shelter) ? $this->Shelter : null;
    }
    /**
     * This method is responsible for validating the value passed to the setShelter method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShelter method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateShelterForChoiceConstraintsFromSetShelter($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BookingWebSource',
            'OxiReservationExt',
            'TLWebPmsReservationExtensions',
            'TLWebPmsRoomTypeExtensions',
            'TLWebPmsServiceExtensions',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Shelter can\'t be set as the property %s is already set. Only one property must be set among these properties: Shelter, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Shelter value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Shelter $shelter
     * @return \StructType\TPA_ExtensionsType
     */
    public function setShelter(\StructType\Shelter $shelter = null)
    {
        // validation for constraint: choice(BookingWebSource, OxiReservationExt, Shelter, TLWebPmsReservationExtensions, TLWebPmsRoomTypeExtensions, TLWebPmsServiceExtensions)
        if ('' !== ($shelterChoiceErrorMessage = self::validateShelterForChoiceConstraintsFromSetShelter($shelter))) {
            throw new \InvalidArgumentException($shelterChoiceErrorMessage, __LINE__);
        }
        if (is_null($shelter) || (is_array($shelter) && empty($shelter))) {
            unset($this->Shelter);
        } else {
            $this->Shelter = $shelter;
        }
        return $this;
    }
    /**
     * Get TLWebPmsReservationExtensions value
     * @return \StructType\TLWebPmsReservationExtensions|null
     */
    public function getTLWebPmsReservationExtensions()
    {
        return isset($this->TLWebPmsReservationExtensions) ? $this->TLWebPmsReservationExtensions : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTLWebPmsReservationExtensions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTLWebPmsReservationExtensions method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTLWebPmsReservationExtensionsForChoiceConstraintsFromSetTLWebPmsReservationExtensions($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BookingWebSource',
            'OxiReservationExt',
            'Shelter',
            'TLWebPmsRoomTypeExtensions',
            'TLWebPmsServiceExtensions',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property TLWebPmsReservationExtensions can\'t be set as the property %s is already set. Only one property must be set among these properties: TLWebPmsReservationExtensions, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set TLWebPmsReservationExtensions value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TLWebPmsReservationExtensions $tLWebPmsReservationExtensions
     * @return \StructType\TPA_ExtensionsType
     */
    public function setTLWebPmsReservationExtensions(\StructType\TLWebPmsReservationExtensions $tLWebPmsReservationExtensions = null)
    {
        // validation for constraint: choice(BookingWebSource, OxiReservationExt, Shelter, TLWebPmsReservationExtensions, TLWebPmsRoomTypeExtensions, TLWebPmsServiceExtensions)
        if ('' !== ($tLWebPmsReservationExtensionsChoiceErrorMessage = self::validateTLWebPmsReservationExtensionsForChoiceConstraintsFromSetTLWebPmsReservationExtensions($tLWebPmsReservationExtensions))) {
            throw new \InvalidArgumentException($tLWebPmsReservationExtensionsChoiceErrorMessage, __LINE__);
        }
        if (is_null($tLWebPmsReservationExtensions) || (is_array($tLWebPmsReservationExtensions) && empty($tLWebPmsReservationExtensions))) {
            unset($this->TLWebPmsReservationExtensions);
        } else {
            $this->TLWebPmsReservationExtensions = $tLWebPmsReservationExtensions;
        }
        return $this;
    }
    /**
     * Get TLWebPmsRoomTypeExtensions value
     * @return \StructType\TLWebPmsRoomTypeExtensions|null
     */
    public function getTLWebPmsRoomTypeExtensions()
    {
        return isset($this->TLWebPmsRoomTypeExtensions) ? $this->TLWebPmsRoomTypeExtensions : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTLWebPmsRoomTypeExtensions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTLWebPmsRoomTypeExtensions method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTLWebPmsRoomTypeExtensionsForChoiceConstraintsFromSetTLWebPmsRoomTypeExtensions($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BookingWebSource',
            'OxiReservationExt',
            'Shelter',
            'TLWebPmsReservationExtensions',
            'TLWebPmsServiceExtensions',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property TLWebPmsRoomTypeExtensions can\'t be set as the property %s is already set. Only one property must be set among these properties: TLWebPmsRoomTypeExtensions, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set TLWebPmsRoomTypeExtensions value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TLWebPmsRoomTypeExtensions $tLWebPmsRoomTypeExtensions
     * @return \StructType\TPA_ExtensionsType
     */
    public function setTLWebPmsRoomTypeExtensions(\StructType\TLWebPmsRoomTypeExtensions $tLWebPmsRoomTypeExtensions = null)
    {
        // validation for constraint: choice(BookingWebSource, OxiReservationExt, Shelter, TLWebPmsReservationExtensions, TLWebPmsRoomTypeExtensions, TLWebPmsServiceExtensions)
        if ('' !== ($tLWebPmsRoomTypeExtensionsChoiceErrorMessage = self::validateTLWebPmsRoomTypeExtensionsForChoiceConstraintsFromSetTLWebPmsRoomTypeExtensions($tLWebPmsRoomTypeExtensions))) {
            throw new \InvalidArgumentException($tLWebPmsRoomTypeExtensionsChoiceErrorMessage, __LINE__);
        }
        if (is_null($tLWebPmsRoomTypeExtensions) || (is_array($tLWebPmsRoomTypeExtensions) && empty($tLWebPmsRoomTypeExtensions))) {
            unset($this->TLWebPmsRoomTypeExtensions);
        } else {
            $this->TLWebPmsRoomTypeExtensions = $tLWebPmsRoomTypeExtensions;
        }
        return $this;
    }
    /**
     * Get TLWebPmsServiceExtensions value
     * @return \StructType\TLWebPmsServiceExtensions|null
     */
    public function getTLWebPmsServiceExtensions()
    {
        return isset($this->TLWebPmsServiceExtensions) ? $this->TLWebPmsServiceExtensions : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTLWebPmsServiceExtensions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTLWebPmsServiceExtensions method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTLWebPmsServiceExtensionsForChoiceConstraintsFromSetTLWebPmsServiceExtensions($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BookingWebSource',
            'OxiReservationExt',
            'Shelter',
            'TLWebPmsReservationExtensions',
            'TLWebPmsRoomTypeExtensions',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property TLWebPmsServiceExtensions can\'t be set as the property %s is already set. Only one property must be set among these properties: TLWebPmsServiceExtensions, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set TLWebPmsServiceExtensions value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TLWebPmsServiceExtensions $tLWebPmsServiceExtensions
     * @return \StructType\TPA_ExtensionsType
     */
    public function setTLWebPmsServiceExtensions(\StructType\TLWebPmsServiceExtensions $tLWebPmsServiceExtensions = null)
    {
        // validation for constraint: choice(BookingWebSource, OxiReservationExt, Shelter, TLWebPmsReservationExtensions, TLWebPmsRoomTypeExtensions, TLWebPmsServiceExtensions)
        if ('' !== ($tLWebPmsServiceExtensionsChoiceErrorMessage = self::validateTLWebPmsServiceExtensionsForChoiceConstraintsFromSetTLWebPmsServiceExtensions($tLWebPmsServiceExtensions))) {
            throw new \InvalidArgumentException($tLWebPmsServiceExtensionsChoiceErrorMessage, __LINE__);
        }
        if (is_null($tLWebPmsServiceExtensions) || (is_array($tLWebPmsServiceExtensions) && empty($tLWebPmsServiceExtensions))) {
            unset($this->TLWebPmsServiceExtensions);
        } else {
            $this->TLWebPmsServiceExtensions = $tLWebPmsServiceExtensions;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TPA_ExtensionsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
