<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TLWebPmsRoomTypeExtensions StructType
 * @subpackage Structs
 */
class TLWebPmsRoomTypeExtensions extends AbstractStructBase
{
    /**
     * The Bed
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BedInfo[]
     */
    public $Bed;
    /**
     * The bookingRoomTypeId
     * @var int
     */
    public $bookingRoomTypeId;
    /**
     * The occupiesQuotaBeforeArrival
     * @var bool
     */
    public $occupiesQuotaBeforeArrival;
    /**
     * The occupiesQuotaAfterDeparture
     * @var bool
     */
    public $occupiesQuotaAfterDeparture;
    /**
     * The overrideEarlyArrivalCharge
     * @var bool
     */
    public $overrideEarlyArrivalCharge;
    /**
     * The overrideLateDepartureCharge
     * @var bool
     */
    public $overrideLateDepartureCharge;
    /**
     * Constructor method for TLWebPmsRoomTypeExtensions
     * @uses TLWebPmsRoomTypeExtensions::setBed()
     * @uses TLWebPmsRoomTypeExtensions::setBookingRoomTypeId()
     * @uses TLWebPmsRoomTypeExtensions::setOccupiesQuotaBeforeArrival()
     * @uses TLWebPmsRoomTypeExtensions::setOccupiesQuotaAfterDeparture()
     * @uses TLWebPmsRoomTypeExtensions::setOverrideEarlyArrivalCharge()
     * @uses TLWebPmsRoomTypeExtensions::setOverrideLateDepartureCharge()
     * @param \StructType\BedInfo[] $bed
     * @param int $bookingRoomTypeId
     * @param bool $occupiesQuotaBeforeArrival
     * @param bool $occupiesQuotaAfterDeparture
     * @param bool $overrideEarlyArrivalCharge
     * @param bool $overrideLateDepartureCharge
     */
    public function __construct(array $bed = array(), $bookingRoomTypeId = null, $occupiesQuotaBeforeArrival = null, $occupiesQuotaAfterDeparture = null, $overrideEarlyArrivalCharge = null, $overrideLateDepartureCharge = null)
    {
        $this
            ->setBed($bed)
            ->setBookingRoomTypeId($bookingRoomTypeId)
            ->setOccupiesQuotaBeforeArrival($occupiesQuotaBeforeArrival)
            ->setOccupiesQuotaAfterDeparture($occupiesQuotaAfterDeparture)
            ->setOverrideEarlyArrivalCharge($overrideEarlyArrivalCharge)
            ->setOverrideLateDepartureCharge($overrideLateDepartureCharge);
    }
    /**
     * Get Bed value
     * @return \StructType\BedInfo[]|null
     */
    public function getBed()
    {
        return $this->Bed;
    }
    /**
     * This method is responsible for validating the values passed to the setBed method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBed method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBedForArrayConstraintsFromSetBed(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tLWebPmsRoomTypeExtensionsBedItem) {
            // validation for constraint: itemType
            if (!$tLWebPmsRoomTypeExtensionsBedItem instanceof \StructType\BedInfo) {
                $invalidValues[] = is_object($tLWebPmsRoomTypeExtensionsBedItem) ? get_class($tLWebPmsRoomTypeExtensionsBedItem) : sprintf('%s(%s)', gettype($tLWebPmsRoomTypeExtensionsBedItem), var_export($tLWebPmsRoomTypeExtensionsBedItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Bed property can only contain items of type \StructType\BedInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Bed value
     * @throws \InvalidArgumentException
     * @param \StructType\BedInfo[] $bed
     * @return \StructType\TLWebPmsRoomTypeExtensions
     */
    public function setBed(array $bed = array())
    {
        // validation for constraint: array
        if ('' !== ($bedArrayErrorMessage = self::validateBedForArrayConstraintsFromSetBed($bed))) {
            throw new \InvalidArgumentException($bedArrayErrorMessage, __LINE__);
        }
        $this->Bed = $bed;
        return $this;
    }
    /**
     * Add item to Bed value
     * @throws \InvalidArgumentException
     * @param \StructType\BedInfo $item
     * @return \StructType\TLWebPmsRoomTypeExtensions
     */
    public function addToBed(\StructType\BedInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BedInfo) {
            throw new \InvalidArgumentException(sprintf('The Bed property can only contain items of type \StructType\BedInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Bed[] = $item;
        return $this;
    }
    /**
     * Get bookingRoomTypeId value
     * @return int|null
     */
    public function getBookingRoomTypeId()
    {
        return $this->bookingRoomTypeId;
    }
    /**
     * Set bookingRoomTypeId value
     * @param int $bookingRoomTypeId
     * @return \StructType\TLWebPmsRoomTypeExtensions
     */
    public function setBookingRoomTypeId($bookingRoomTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($bookingRoomTypeId) && !(is_int($bookingRoomTypeId) || ctype_digit($bookingRoomTypeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bookingRoomTypeId, true), gettype($bookingRoomTypeId)), __LINE__);
        }
        $this->bookingRoomTypeId = $bookingRoomTypeId;
        return $this;
    }
    /**
     * Get occupiesQuotaBeforeArrival value
     * @return bool|null
     */
    public function getOccupiesQuotaBeforeArrival()
    {
        return $this->occupiesQuotaBeforeArrival;
    }
    /**
     * Set occupiesQuotaBeforeArrival value
     * @param bool $occupiesQuotaBeforeArrival
     * @return \StructType\TLWebPmsRoomTypeExtensions
     */
    public function setOccupiesQuotaBeforeArrival($occupiesQuotaBeforeArrival = null)
    {
        // validation for constraint: boolean
        if (!is_null($occupiesQuotaBeforeArrival) && !is_bool($occupiesQuotaBeforeArrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($occupiesQuotaBeforeArrival, true), gettype($occupiesQuotaBeforeArrival)), __LINE__);
        }
        $this->occupiesQuotaBeforeArrival = $occupiesQuotaBeforeArrival;
        return $this;
    }
    /**
     * Get occupiesQuotaAfterDeparture value
     * @return bool|null
     */
    public function getOccupiesQuotaAfterDeparture()
    {
        return $this->occupiesQuotaAfterDeparture;
    }
    /**
     * Set occupiesQuotaAfterDeparture value
     * @param bool $occupiesQuotaAfterDeparture
     * @return \StructType\TLWebPmsRoomTypeExtensions
     */
    public function setOccupiesQuotaAfterDeparture($occupiesQuotaAfterDeparture = null)
    {
        // validation for constraint: boolean
        if (!is_null($occupiesQuotaAfterDeparture) && !is_bool($occupiesQuotaAfterDeparture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($occupiesQuotaAfterDeparture, true), gettype($occupiesQuotaAfterDeparture)), __LINE__);
        }
        $this->occupiesQuotaAfterDeparture = $occupiesQuotaAfterDeparture;
        return $this;
    }
    /**
     * Get overrideEarlyArrivalCharge value
     * @return bool|null
     */
    public function getOverrideEarlyArrivalCharge()
    {
        return $this->overrideEarlyArrivalCharge;
    }
    /**
     * Set overrideEarlyArrivalCharge value
     * @param bool $overrideEarlyArrivalCharge
     * @return \StructType\TLWebPmsRoomTypeExtensions
     */
    public function setOverrideEarlyArrivalCharge($overrideEarlyArrivalCharge = null)
    {
        // validation for constraint: boolean
        if (!is_null($overrideEarlyArrivalCharge) && !is_bool($overrideEarlyArrivalCharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($overrideEarlyArrivalCharge, true), gettype($overrideEarlyArrivalCharge)), __LINE__);
        }
        $this->overrideEarlyArrivalCharge = $overrideEarlyArrivalCharge;
        return $this;
    }
    /**
     * Get overrideLateDepartureCharge value
     * @return bool|null
     */
    public function getOverrideLateDepartureCharge()
    {
        return $this->overrideLateDepartureCharge;
    }
    /**
     * Set overrideLateDepartureCharge value
     * @param bool $overrideLateDepartureCharge
     * @return \StructType\TLWebPmsRoomTypeExtensions
     */
    public function setOverrideLateDepartureCharge($overrideLateDepartureCharge = null)
    {
        // validation for constraint: boolean
        if (!is_null($overrideLateDepartureCharge) && !is_bool($overrideLateDepartureCharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($overrideLateDepartureCharge, true), gettype($overrideLateDepartureCharge)), __LINE__);
        }
        $this->overrideLateDepartureCharge = $overrideLateDepartureCharge;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TLWebPmsRoomTypeExtensions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
