<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TLWebPmsReservationExtensions StructType
 * @subpackage Structs
 */
class TLWebPmsReservationExtensions extends AbstractStructBase
{
    /**
     * The cancellationDate
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $cancellationDate;
    /**
     * The penaltySum
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $penaltySum;
    /**
     * The Invoice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CustomerInvoiceDetails
     */
    public $Invoice;
    /**
     * The discountPercent
     * @var float
     */
    public $discountPercent;
    /**
     * The cancellationReason
     * @var string
     */
    public $cancellationReason;
    /**
     * The notificationLanguage
     * @var string
     */
    public $notificationLanguage;
    /**
     * The extraStayOverrideIndicator
     * @var bool
     */
    public $extraStayOverrideIndicator;
    /**
     * The taxOverrideIndicator
     * @var bool
     */
    public $taxOverrideIndicator;
    /**
     * The isTlAcquiring
     * @var bool
     */
    public $isTlAcquiring;
    /**
     * The penaltyCurrencyId
     * @var string
     */
    public $penaltyCurrencyId;
    /**
     * Constructor method for TLWebPmsReservationExtensions
     * @uses TLWebPmsReservationExtensions::setCancellationDate()
     * @uses TLWebPmsReservationExtensions::setPenaltySum()
     * @uses TLWebPmsReservationExtensions::setInvoice()
     * @uses TLWebPmsReservationExtensions::setDiscountPercent()
     * @uses TLWebPmsReservationExtensions::setCancellationReason()
     * @uses TLWebPmsReservationExtensions::setNotificationLanguage()
     * @uses TLWebPmsReservationExtensions::setExtraStayOverrideIndicator()
     * @uses TLWebPmsReservationExtensions::setTaxOverrideIndicator()
     * @uses TLWebPmsReservationExtensions::setIsTlAcquiring()
     * @uses TLWebPmsReservationExtensions::setPenaltyCurrencyId()
     * @param string $cancellationDate
     * @param float $penaltySum
     * @param \StructType\CustomerInvoiceDetails $invoice
     * @param float $discountPercent
     * @param string $cancellationReason
     * @param string $notificationLanguage
     * @param bool $extraStayOverrideIndicator
     * @param bool $taxOverrideIndicator
     * @param bool $isTlAcquiring
     * @param string $penaltyCurrencyId
     */
    public function __construct($cancellationDate = null, $penaltySum = null, \StructType\CustomerInvoiceDetails $invoice = null, $discountPercent = null, $cancellationReason = null, $notificationLanguage = null, $extraStayOverrideIndicator = null, $taxOverrideIndicator = null, $isTlAcquiring = null, $penaltyCurrencyId = null)
    {
        $this
            ->setCancellationDate($cancellationDate)
            ->setPenaltySum($penaltySum)
            ->setInvoice($invoice)
            ->setDiscountPercent($discountPercent)
            ->setCancellationReason($cancellationReason)
            ->setNotificationLanguage($notificationLanguage)
            ->setExtraStayOverrideIndicator($extraStayOverrideIndicator)
            ->setTaxOverrideIndicator($taxOverrideIndicator)
            ->setIsTlAcquiring($isTlAcquiring)
            ->setPenaltyCurrencyId($penaltyCurrencyId);
    }
    /**
     * Get cancellationDate value
     * @return string
     */
    public function getCancellationDate()
    {
        return $this->cancellationDate;
    }
    /**
     * Set cancellationDate value
     * @param string $cancellationDate
     * @return \StructType\TLWebPmsReservationExtensions
     */
    public function setCancellationDate($cancellationDate = null)
    {
        // validation for constraint: string
        if (!is_null($cancellationDate) && !is_string($cancellationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancellationDate, true), gettype($cancellationDate)), __LINE__);
        }
        $this->cancellationDate = $cancellationDate;
        return $this;
    }
    /**
     * Get penaltySum value
     * @return float
     */
    public function getPenaltySum()
    {
        return $this->penaltySum;
    }
    /**
     * Set penaltySum value
     * @param float $penaltySum
     * @return \StructType\TLWebPmsReservationExtensions
     */
    public function setPenaltySum($penaltySum = null)
    {
        // validation for constraint: float
        if (!is_null($penaltySum) && !(is_float($penaltySum) || is_numeric($penaltySum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($penaltySum, true), gettype($penaltySum)), __LINE__);
        }
        $this->penaltySum = $penaltySum;
        return $this;
    }
    /**
     * Get Invoice value
     * @return \StructType\CustomerInvoiceDetails|null
     */
    public function getInvoice()
    {
        return $this->Invoice;
    }
    /**
     * Set Invoice value
     * @param \StructType\CustomerInvoiceDetails $invoice
     * @return \StructType\TLWebPmsReservationExtensions
     */
    public function setInvoice(\StructType\CustomerInvoiceDetails $invoice = null)
    {
        $this->Invoice = $invoice;
        return $this;
    }
    /**
     * Get discountPercent value
     * @return float|null
     */
    public function getDiscountPercent()
    {
        return $this->discountPercent;
    }
    /**
     * Set discountPercent value
     * @param float $discountPercent
     * @return \StructType\TLWebPmsReservationExtensions
     */
    public function setDiscountPercent($discountPercent = null)
    {
        // validation for constraint: float
        if (!is_null($discountPercent) && !(is_float($discountPercent) || is_numeric($discountPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountPercent, true), gettype($discountPercent)), __LINE__);
        }
        $this->discountPercent = $discountPercent;
        return $this;
    }
    /**
     * Get cancellationReason value
     * @return string|null
     */
    public function getCancellationReason()
    {
        return $this->cancellationReason;
    }
    /**
     * Set cancellationReason value
     * @param string $cancellationReason
     * @return \StructType\TLWebPmsReservationExtensions
     */
    public function setCancellationReason($cancellationReason = null)
    {
        // validation for constraint: string
        if (!is_null($cancellationReason) && !is_string($cancellationReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancellationReason, true), gettype($cancellationReason)), __LINE__);
        }
        $this->cancellationReason = $cancellationReason;
        return $this;
    }
    /**
     * Get notificationLanguage value
     * @return string|null
     */
    public function getNotificationLanguage()
    {
        return $this->notificationLanguage;
    }
    /**
     * Set notificationLanguage value
     * @param string $notificationLanguage
     * @return \StructType\TLWebPmsReservationExtensions
     */
    public function setNotificationLanguage($notificationLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($notificationLanguage) && !is_string($notificationLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notificationLanguage, true), gettype($notificationLanguage)), __LINE__);
        }
        $this->notificationLanguage = $notificationLanguage;
        return $this;
    }
    /**
     * Get extraStayOverrideIndicator value
     * @return bool|null
     */
    public function getExtraStayOverrideIndicator()
    {
        return $this->extraStayOverrideIndicator;
    }
    /**
     * Set extraStayOverrideIndicator value
     * @param bool $extraStayOverrideIndicator
     * @return \StructType\TLWebPmsReservationExtensions
     */
    public function setExtraStayOverrideIndicator($extraStayOverrideIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($extraStayOverrideIndicator) && !is_bool($extraStayOverrideIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($extraStayOverrideIndicator, true), gettype($extraStayOverrideIndicator)), __LINE__);
        }
        $this->extraStayOverrideIndicator = $extraStayOverrideIndicator;
        return $this;
    }
    /**
     * Get taxOverrideIndicator value
     * @return bool|null
     */
    public function getTaxOverrideIndicator()
    {
        return $this->taxOverrideIndicator;
    }
    /**
     * Set taxOverrideIndicator value
     * @param bool $taxOverrideIndicator
     * @return \StructType\TLWebPmsReservationExtensions
     */
    public function setTaxOverrideIndicator($taxOverrideIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxOverrideIndicator) && !is_bool($taxOverrideIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxOverrideIndicator, true), gettype($taxOverrideIndicator)), __LINE__);
        }
        $this->taxOverrideIndicator = $taxOverrideIndicator;
        return $this;
    }
    /**
     * Get isTlAcquiring value
     * @return bool|null
     */
    public function getIsTlAcquiring()
    {
        return $this->isTlAcquiring;
    }
    /**
     * Set isTlAcquiring value
     * @param bool $isTlAcquiring
     * @return \StructType\TLWebPmsReservationExtensions
     */
    public function setIsTlAcquiring($isTlAcquiring = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTlAcquiring) && !is_bool($isTlAcquiring)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTlAcquiring, true), gettype($isTlAcquiring)), __LINE__);
        }
        $this->isTlAcquiring = $isTlAcquiring;
        return $this;
    }
    /**
     * Get penaltyCurrencyId value
     * @return string|null
     */
    public function getPenaltyCurrencyId()
    {
        return $this->penaltyCurrencyId;
    }
    /**
     * Set penaltyCurrencyId value
     * @param string $penaltyCurrencyId
     * @return \StructType\TLWebPmsReservationExtensions
     */
    public function setPenaltyCurrencyId($penaltyCurrencyId = null)
    {
        // validation for constraint: string
        if (!is_null($penaltyCurrencyId) && !is_string($penaltyCurrencyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($penaltyCurrencyId, true), gettype($penaltyCurrencyId)), __LINE__);
        }
        $this->penaltyCurrencyId = $penaltyCurrencyId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TLWebPmsReservationExtensions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
