<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Shelter StructType
 * @subpackage Structs
 */
class Shelter extends AbstractStructBase
{
    /**
     * The agent
     * @var string
     */
    public $agent;
    /**
     * The debtor
     * @var string
     */
    public $debtor;
    /**
     * The contract
     * @var string
     */
    public $contract;
    /**
     * The payer
     * @var string
     */
    public $payer;
    /**
     * The paymentMethod
     * @var string
     */
    public $paymentMethod;
    /**
     * Constructor method for Shelter
     * @uses Shelter::setAgent()
     * @uses Shelter::setDebtor()
     * @uses Shelter::setContract()
     * @uses Shelter::setPayer()
     * @uses Shelter::setPaymentMethod()
     * @param string $agent
     * @param string $debtor
     * @param string $contract
     * @param string $payer
     * @param string $paymentMethod
     */
    public function __construct($agent = null, $debtor = null, $contract = null, $payer = null, $paymentMethod = null)
    {
        $this
            ->setAgent($agent)
            ->setDebtor($debtor)
            ->setContract($contract)
            ->setPayer($payer)
            ->setPaymentMethod($paymentMethod);
    }
    /**
     * Get agent value
     * @return string|null
     */
    public function getAgent()
    {
        return $this->agent;
    }
    /**
     * Set agent value
     * @param string $agent
     * @return \StructType\Shelter
     */
    public function setAgent($agent = null)
    {
        // validation for constraint: string
        if (!is_null($agent) && !is_string($agent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agent, true), gettype($agent)), __LINE__);
        }
        $this->agent = $agent;
        return $this;
    }
    /**
     * Get debtor value
     * @return string|null
     */
    public function getDebtor()
    {
        return $this->debtor;
    }
    /**
     * Set debtor value
     * @param string $debtor
     * @return \StructType\Shelter
     */
    public function setDebtor($debtor = null)
    {
        // validation for constraint: string
        if (!is_null($debtor) && !is_string($debtor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($debtor, true), gettype($debtor)), __LINE__);
        }
        $this->debtor = $debtor;
        return $this;
    }
    /**
     * Get contract value
     * @return string|null
     */
    public function getContract()
    {
        return $this->contract;
    }
    /**
     * Set contract value
     * @param string $contract
     * @return \StructType\Shelter
     */
    public function setContract($contract = null)
    {
        // validation for constraint: string
        if (!is_null($contract) && !is_string($contract)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract, true), gettype($contract)), __LINE__);
        }
        $this->contract = $contract;
        return $this;
    }
    /**
     * Get payer value
     * @return string|null
     */
    public function getPayer()
    {
        return $this->payer;
    }
    /**
     * Set payer value
     * @param string $payer
     * @return \StructType\Shelter
     */
    public function setPayer($payer = null)
    {
        // validation for constraint: string
        if (!is_null($payer) && !is_string($payer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payer, true), gettype($payer)), __LINE__);
        }
        $this->payer = $payer;
        return $this;
    }
    /**
     * Get paymentMethod value
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return $this->paymentMethod;
    }
    /**
     * Set paymentMethod value
     * @param string $paymentMethod
     * @return \StructType\Shelter
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethod) && !is_string($paymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethod, true), gettype($paymentMethod)), __LINE__);
        }
        $this->paymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Shelter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
