<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomStayType StructType
 * @subpackage Structs
 */
class RoomStayType extends AbstractStructBase
{
    /**
     * The RoomTypes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRoomTypeType
     */
    public $RoomTypes;
    /**
     * The RatePlans
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRoomStayTypeRatePlan
     */
    public $RatePlans;
    /**
     * The RoomRates
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRoomStayTypeRoomRate
     */
    public $RoomRates;
    /**
     * The GuestCounts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfGuestCountTypeGuestCount
     */
    public $GuestCounts;
    /**
     * The TimeSpan
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeSpanType
     */
    public $TimeSpan;
    /**
     * The Guarantee
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GuaranteeType[]
     */
    public $Guarantee;
    /**
     * The DepositPayments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment
     */
    public $DepositPayments;
    /**
     * The CancelPenalties
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CancelPenaltiesType
     */
    public $CancelPenalties;
    /**
     * The Total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TotalType
     */
    public $Total;
    /**
     * The BasicPropertyInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BasicPropertyInfo
     */
    public $BasicPropertyInfo;
    /**
     * Constructor method for RoomStayType
     * @uses RoomStayType::setRoomTypes()
     * @uses RoomStayType::setRatePlans()
     * @uses RoomStayType::setRoomRates()
     * @uses RoomStayType::setGuestCounts()
     * @uses RoomStayType::setTimeSpan()
     * @uses RoomStayType::setGuarantee()
     * @uses RoomStayType::setDepositPayments()
     * @uses RoomStayType::setCancelPenalties()
     * @uses RoomStayType::setTotal()
     * @uses RoomStayType::setBasicPropertyInfo()
     * @param \ArrayType\ArrayOfRoomTypeType $roomTypes
     * @param \ArrayType\ArrayOfRoomStayTypeRatePlan $ratePlans
     * @param \ArrayType\ArrayOfRoomStayTypeRoomRate $roomRates
     * @param \ArrayType\ArrayOfGuestCountTypeGuestCount $guestCounts
     * @param \StructType\DateTimeSpanType $timeSpan
     * @param \StructType\GuaranteeType[] $guarantee
     * @param \ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment $depositPayments
     * @param \StructType\CancelPenaltiesType $cancelPenalties
     * @param \StructType\TotalType $total
     * @param \StructType\BasicPropertyInfo $basicPropertyInfo
     */
    public function __construct(\ArrayType\ArrayOfRoomTypeType $roomTypes = null, \ArrayType\ArrayOfRoomStayTypeRatePlan $ratePlans = null, \ArrayType\ArrayOfRoomStayTypeRoomRate $roomRates = null, \ArrayType\ArrayOfGuestCountTypeGuestCount $guestCounts = null, \StructType\DateTimeSpanType $timeSpan = null, array $guarantee = array(), \ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment $depositPayments = null, \StructType\CancelPenaltiesType $cancelPenalties = null, \StructType\TotalType $total = null, \StructType\BasicPropertyInfo $basicPropertyInfo = null)
    {
        $this
            ->setRoomTypes($roomTypes)
            ->setRatePlans($ratePlans)
            ->setRoomRates($roomRates)
            ->setGuestCounts($guestCounts)
            ->setTimeSpan($timeSpan)
            ->setGuarantee($guarantee)
            ->setDepositPayments($depositPayments)
            ->setCancelPenalties($cancelPenalties)
            ->setTotal($total)
            ->setBasicPropertyInfo($basicPropertyInfo);
    }
    /**
     * Get RoomTypes value
     * @return \ArrayType\ArrayOfRoomTypeType|null
     */
    public function getRoomTypes()
    {
        return $this->RoomTypes;
    }
    /**
     * Set RoomTypes value
     * @param \ArrayType\ArrayOfRoomTypeType $roomTypes
     * @return \StructType\RoomStayType
     */
    public function setRoomTypes(\ArrayType\ArrayOfRoomTypeType $roomTypes = null)
    {
        $this->RoomTypes = $roomTypes;
        return $this;
    }
    /**
     * Get RatePlans value
     * @return \ArrayType\ArrayOfRoomStayTypeRatePlan|null
     */
    public function getRatePlans()
    {
        return $this->RatePlans;
    }
    /**
     * Set RatePlans value
     * @param \ArrayType\ArrayOfRoomStayTypeRatePlan $ratePlans
     * @return \StructType\RoomStayType
     */
    public function setRatePlans(\ArrayType\ArrayOfRoomStayTypeRatePlan $ratePlans = null)
    {
        $this->RatePlans = $ratePlans;
        return $this;
    }
    /**
     * Get RoomRates value
     * @return \ArrayType\ArrayOfRoomStayTypeRoomRate|null
     */
    public function getRoomRates()
    {
        return $this->RoomRates;
    }
    /**
     * Set RoomRates value
     * @param \ArrayType\ArrayOfRoomStayTypeRoomRate $roomRates
     * @return \StructType\RoomStayType
     */
    public function setRoomRates(\ArrayType\ArrayOfRoomStayTypeRoomRate $roomRates = null)
    {
        $this->RoomRates = $roomRates;
        return $this;
    }
    /**
     * Get GuestCounts value
     * @return \ArrayType\ArrayOfGuestCountTypeGuestCount|null
     */
    public function getGuestCounts()
    {
        return $this->GuestCounts;
    }
    /**
     * Set GuestCounts value
     * @param \ArrayType\ArrayOfGuestCountTypeGuestCount $guestCounts
     * @return \StructType\RoomStayType
     */
    public function setGuestCounts(\ArrayType\ArrayOfGuestCountTypeGuestCount $guestCounts = null)
    {
        $this->GuestCounts = $guestCounts;
        return $this;
    }
    /**
     * Get TimeSpan value
     * @return \StructType\DateTimeSpanType|null
     */
    public function getTimeSpan()
    {
        return $this->TimeSpan;
    }
    /**
     * Set TimeSpan value
     * @param \StructType\DateTimeSpanType $timeSpan
     * @return \StructType\RoomStayType
     */
    public function setTimeSpan(\StructType\DateTimeSpanType $timeSpan = null)
    {
        $this->TimeSpan = $timeSpan;
        return $this;
    }
    /**
     * Get Guarantee value
     * @return \StructType\GuaranteeType[]|null
     */
    public function getGuarantee()
    {
        return $this->Guarantee;
    }
    /**
     * This method is responsible for validating the values passed to the setGuarantee method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuarantee method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGuaranteeForArrayConstraintsFromSetGuarantee(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomStayTypeGuaranteeItem) {
            // validation for constraint: itemType
            if (!$roomStayTypeGuaranteeItem instanceof \StructType\GuaranteeType) {
                $invalidValues[] = is_object($roomStayTypeGuaranteeItem) ? get_class($roomStayTypeGuaranteeItem) : sprintf('%s(%s)', gettype($roomStayTypeGuaranteeItem), var_export($roomStayTypeGuaranteeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Guarantee property can only contain items of type \StructType\GuaranteeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Guarantee value
     * @throws \InvalidArgumentException
     * @param \StructType\GuaranteeType[] $guarantee
     * @return \StructType\RoomStayType
     */
    public function setGuarantee(array $guarantee = array())
    {
        // validation for constraint: array
        if ('' !== ($guaranteeArrayErrorMessage = self::validateGuaranteeForArrayConstraintsFromSetGuarantee($guarantee))) {
            throw new \InvalidArgumentException($guaranteeArrayErrorMessage, __LINE__);
        }
        $this->Guarantee = $guarantee;
        return $this;
    }
    /**
     * Add item to Guarantee value
     * @throws \InvalidArgumentException
     * @param \StructType\GuaranteeType $item
     * @return \StructType\RoomStayType
     */
    public function addToGuarantee(\StructType\GuaranteeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GuaranteeType) {
            throw new \InvalidArgumentException(sprintf('The Guarantee property can only contain items of type \StructType\GuaranteeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Guarantee[] = $item;
        return $this;
    }
    /**
     * Get DepositPayments value
     * @return \ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment|null
     */
    public function getDepositPayments()
    {
        return $this->DepositPayments;
    }
    /**
     * Set DepositPayments value
     * @param \ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment $depositPayments
     * @return \StructType\RoomStayType
     */
    public function setDepositPayments(\ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment $depositPayments = null)
    {
        $this->DepositPayments = $depositPayments;
        return $this;
    }
    /**
     * Get CancelPenalties value
     * @return \StructType\CancelPenaltiesType|null
     */
    public function getCancelPenalties()
    {
        return $this->CancelPenalties;
    }
    /**
     * Set CancelPenalties value
     * @param \StructType\CancelPenaltiesType $cancelPenalties
     * @return \StructType\RoomStayType
     */
    public function setCancelPenalties(\StructType\CancelPenaltiesType $cancelPenalties = null)
    {
        $this->CancelPenalties = $cancelPenalties;
        return $this;
    }
    /**
     * Get Total value
     * @return \StructType\TotalType|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param \StructType\TotalType $total
     * @return \StructType\RoomStayType
     */
    public function setTotal(\StructType\TotalType $total = null)
    {
        $this->Total = $total;
        return $this;
    }
    /**
     * Get BasicPropertyInfo value
     * @return \StructType\BasicPropertyInfo|null
     */
    public function getBasicPropertyInfo()
    {
        return $this->BasicPropertyInfo;
    }
    /**
     * Set BasicPropertyInfo value
     * @param \StructType\BasicPropertyInfo $basicPropertyInfo
     * @return \StructType\RoomStayType
     */
    public function setBasicPropertyInfo(\StructType\BasicPropertyInfo $basicPropertyInfo = null)
    {
        $this->BasicPropertyInfo = $basicPropertyInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomStayType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
