<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Room StructType
 * @subpackage Structs
 */
class Room extends AbstractStructBase
{
    /**
     * The RoomType
     * @var string
     */
    public $RoomType;
    /**
     * The RoomTypeCode
     * @var string
     */
    public $RoomTypeCode;
    /**
     * The RoomCategory
     * @var string
     */
    public $RoomCategory;
    /**
     * The InvBlockCode
     * @var string
     */
    public $InvBlockCode;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * Constructor method for Room
     * @uses Room::setRoomType()
     * @uses Room::setRoomTypeCode()
     * @uses Room::setRoomCategory()
     * @uses Room::setInvBlockCode()
     * @uses Room::setQuantity()
     * @param string $roomType
     * @param string $roomTypeCode
     * @param string $roomCategory
     * @param string $invBlockCode
     * @param int $quantity
     */
    public function __construct($roomType = null, $roomTypeCode = null, $roomCategory = null, $invBlockCode = null, $quantity = null)
    {
        $this
            ->setRoomType($roomType)
            ->setRoomTypeCode($roomTypeCode)
            ->setRoomCategory($roomCategory)
            ->setInvBlockCode($invBlockCode)
            ->setQuantity($quantity);
    }
    /**
     * Get RoomType value
     * @return string|null
     */
    public function getRoomType()
    {
        return $this->RoomType;
    }
    /**
     * Set RoomType value
     * @param string $roomType
     * @return \StructType\Room
     */
    public function setRoomType($roomType = null)
    {
        // validation for constraint: string
        if (!is_null($roomType) && !is_string($roomType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomType, true), gettype($roomType)), __LINE__);
        }
        $this->RoomType = $roomType;
        return $this;
    }
    /**
     * Get RoomTypeCode value
     * @return string|null
     */
    public function getRoomTypeCode()
    {
        return $this->RoomTypeCode;
    }
    /**
     * Set RoomTypeCode value
     * @param string $roomTypeCode
     * @return \StructType\Room
     */
    public function setRoomTypeCode($roomTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomTypeCode) && !is_string($roomTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomTypeCode, true), gettype($roomTypeCode)), __LINE__);
        }
        $this->RoomTypeCode = $roomTypeCode;
        return $this;
    }
    /**
     * Get RoomCategory value
     * @return string|null
     */
    public function getRoomCategory()
    {
        return $this->RoomCategory;
    }
    /**
     * Set RoomCategory value
     * @param string $roomCategory
     * @return \StructType\Room
     */
    public function setRoomCategory($roomCategory = null)
    {
        // validation for constraint: string
        if (!is_null($roomCategory) && !is_string($roomCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomCategory, true), gettype($roomCategory)), __LINE__);
        }
        $this->RoomCategory = $roomCategory;
        return $this;
    }
    /**
     * Get InvBlockCode value
     * @return string|null
     */
    public function getInvBlockCode()
    {
        return $this->InvBlockCode;
    }
    /**
     * Set InvBlockCode value
     * @param string $invBlockCode
     * @return \StructType\Room
     */
    public function setInvBlockCode($invBlockCode = null)
    {
        // validation for constraint: string
        if (!is_null($invBlockCode) && !is_string($invBlockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invBlockCode, true), gettype($invBlockCode)), __LINE__);
        }
        $this->InvBlockCode = $invBlockCode;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\Room
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Room
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
