<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RateAmountMessages StructType
 * @subpackage Structs
 */
class RateAmountMessages extends AbstractStructBase
{
    /**
     * The RateAmountMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RateAmountMessageType[]
     */
    public $RateAmountMessage;
    /**
     * The HotelCode
     * @var string
     */
    public $HotelCode;
    /**
     * The HotelName
     * @var string
     */
    public $HotelName;
    /**
     * Constructor method for RateAmountMessages
     * @uses RateAmountMessages::setRateAmountMessage()
     * @uses RateAmountMessages::setHotelCode()
     * @uses RateAmountMessages::setHotelName()
     * @param \StructType\RateAmountMessageType[] $rateAmountMessage
     * @param string $hotelCode
     * @param string $hotelName
     */
    public function __construct(array $rateAmountMessage = array(), $hotelCode = null, $hotelName = null)
    {
        $this
            ->setRateAmountMessage($rateAmountMessage)
            ->setHotelCode($hotelCode)
            ->setHotelName($hotelName);
    }
    /**
     * Get RateAmountMessage value
     * @return \StructType\RateAmountMessageType[]|null
     */
    public function getRateAmountMessage()
    {
        return $this->RateAmountMessage;
    }
    /**
     * This method is responsible for validating the values passed to the setRateAmountMessage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRateAmountMessage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRateAmountMessageForArrayConstraintsFromSetRateAmountMessage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rateAmountMessagesRateAmountMessageItem) {
            // validation for constraint: itemType
            if (!$rateAmountMessagesRateAmountMessageItem instanceof \StructType\RateAmountMessageType) {
                $invalidValues[] = is_object($rateAmountMessagesRateAmountMessageItem) ? get_class($rateAmountMessagesRateAmountMessageItem) : sprintf('%s(%s)', gettype($rateAmountMessagesRateAmountMessageItem), var_export($rateAmountMessagesRateAmountMessageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RateAmountMessage property can only contain items of type \StructType\RateAmountMessageType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RateAmountMessage value
     * @throws \InvalidArgumentException
     * @param \StructType\RateAmountMessageType[] $rateAmountMessage
     * @return \StructType\RateAmountMessages
     */
    public function setRateAmountMessage(array $rateAmountMessage = array())
    {
        // validation for constraint: array
        if ('' !== ($rateAmountMessageArrayErrorMessage = self::validateRateAmountMessageForArrayConstraintsFromSetRateAmountMessage($rateAmountMessage))) {
            throw new \InvalidArgumentException($rateAmountMessageArrayErrorMessage, __LINE__);
        }
        $this->RateAmountMessage = $rateAmountMessage;
        return $this;
    }
    /**
     * Add item to RateAmountMessage value
     * @throws \InvalidArgumentException
     * @param \StructType\RateAmountMessageType $item
     * @return \StructType\RateAmountMessages
     */
    public function addToRateAmountMessage(\StructType\RateAmountMessageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RateAmountMessageType) {
            throw new \InvalidArgumentException(sprintf('The RateAmountMessage property can only contain items of type \StructType\RateAmountMessageType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RateAmountMessage[] = $item;
        return $this;
    }
    /**
     * Get HotelCode value
     * @return string|null
     */
    public function getHotelCode()
    {
        return $this->HotelCode;
    }
    /**
     * Set HotelCode value
     * @param string $hotelCode
     * @return \StructType\RateAmountMessages
     */
    public function setHotelCode($hotelCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCode) && !is_string($hotelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCode, true), gettype($hotelCode)), __LINE__);
        }
        $this->HotelCode = $hotelCode;
        return $this;
    }
    /**
     * Get HotelName value
     * @return string|null
     */
    public function getHotelName()
    {
        return $this->HotelName;
    }
    /**
     * Set HotelName value
     * @param string $hotelName
     * @return \StructType\RateAmountMessages
     */
    public function setHotelName($hotelName = null)
    {
        // validation for constraint: string
        if (!is_null($hotelName) && !is_string($hotelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelName, true), gettype($hotelName)), __LINE__);
        }
        $this->HotelName = $hotelName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RateAmountMessages
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
