<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Policy StructType
 * @subpackage Structs
 */
class Policy extends AbstractStructBase
{
    /**
     * The CheckInTime
     * @var string
     */
    public $CheckInTime;
    /**
     * The CheckOutTime
     * @var string
     */
    public $CheckOutTime;
    /**
     * Constructor method for Policy
     * @uses Policy::setCheckInTime()
     * @uses Policy::setCheckOutTime()
     * @param string $checkInTime
     * @param string $checkOutTime
     */
    public function __construct($checkInTime = null, $checkOutTime = null)
    {
        $this
            ->setCheckInTime($checkInTime)
            ->setCheckOutTime($checkOutTime);
    }
    /**
     * Get CheckInTime value
     * @return string|null
     */
    public function getCheckInTime()
    {
        return $this->CheckInTime;
    }
    /**
     * Set CheckInTime value
     * @param string $checkInTime
     * @return \StructType\Policy
     */
    public function setCheckInTime($checkInTime = null)
    {
        // validation for constraint: string
        if (!is_null($checkInTime) && !is_string($checkInTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkInTime, true), gettype($checkInTime)), __LINE__);
        }
        $this->CheckInTime = $checkInTime;
        return $this;
    }
    /**
     * Get CheckOutTime value
     * @return string|null
     */
    public function getCheckOutTime()
    {
        return $this->CheckOutTime;
    }
    /**
     * Set CheckOutTime value
     * @param string $checkOutTime
     * @return \StructType\Policy
     */
    public function setCheckOutTime($checkOutTime = null)
    {
        // validation for constraint: string
        if (!is_null($checkOutTime) && !is_string($checkOutTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkOutTime, true), gettype($checkOutTime)), __LINE__);
        }
        $this->CheckOutTime = $checkOutTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Policy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
