<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentFormType StructType
 * @subpackage Structs
 */
class PaymentFormType extends AbstractStructBase
{
    /**
     * The TPA_Extentions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentFormType_ExtensionsType
     */
    public $TPA_Extentions;
    /**
     * The BankAcct
     * Meta informations extracted from the WSDL
     * - choice: BankAcct | Cash | DirectBill | LoyaltyRedemption | MiscChargeOrder | PaymentCard | Ticket | Voucher
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BankAcctType
     */
    public $BankAcct;
    /**
     * The Cash
     * Meta informations extracted from the WSDL
     * - choice: BankAcct | Cash | DirectBill | LoyaltyRedemption | MiscChargeOrder | PaymentCard | Ticket | Voucher
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Cash
     */
    public $Cash;
    /**
     * The DirectBill
     * Meta informations extracted from the WSDL
     * - choice: BankAcct | Cash | DirectBill | LoyaltyRedemption | MiscChargeOrder | PaymentCard | Ticket | Voucher
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DirectBillType
     */
    public $DirectBill;
    /**
     * The LoyaltyRedemption
     * Meta informations extracted from the WSDL
     * - choice: BankAcct | Cash | DirectBill | LoyaltyRedemption | MiscChargeOrder | PaymentCard | Ticket | Voucher
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LoyaltyRedemption
     */
    public $LoyaltyRedemption;
    /**
     * The MiscChargeOrder
     * Meta informations extracted from the WSDL
     * - choice: BankAcct | Cash | DirectBill | LoyaltyRedemption | MiscChargeOrder | PaymentCard | Ticket | Voucher
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MiscChargeOrder
     */
    public $MiscChargeOrder;
    /**
     * The PaymentCard
     * Meta informations extracted from the WSDL
     * - choice: BankAcct | Cash | DirectBill | LoyaltyRedemption | MiscChargeOrder | PaymentCard | Ticket | Voucher
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentCardType
     */
    public $PaymentCard;
    /**
     * The Ticket
     * Meta informations extracted from the WSDL
     * - choice: BankAcct | Cash | DirectBill | LoyaltyRedemption | MiscChargeOrder | PaymentCard | Ticket | Voucher
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Ticket
     */
    public $Ticket;
    /**
     * The Voucher
     * Meta informations extracted from the WSDL
     * - choice: BankAcct | Cash | DirectBill | LoyaltyRedemption | MiscChargeOrder | PaymentCard | Ticket | Voucher
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Voucher
     */
    public $Voucher;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The CostCenterID
     * @var string
     */
    public $CostCenterID;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * The PaymentTransactionTypeCode
     * @var string
     */
    public $PaymentTransactionTypeCode;
    /**
     * The GuaranteeIndicator
     * @var bool
     */
    public $GuaranteeIndicator;
    /**
     * The GuaranteeTypeCode
     * @var string
     */
    public $GuaranteeTypeCode;
    /**
     * The GuaranteeID
     * @var string
     */
    public $GuaranteeID;
    /**
     * The Remark
     * @var string
     */
    public $Remark;
    /**
     * Constructor method for PaymentFormType
     * @uses PaymentFormType::setTPA_Extentions()
     * @uses PaymentFormType::setBankAcct()
     * @uses PaymentFormType::setCash()
     * @uses PaymentFormType::setDirectBill()
     * @uses PaymentFormType::setLoyaltyRedemption()
     * @uses PaymentFormType::setMiscChargeOrder()
     * @uses PaymentFormType::setPaymentCard()
     * @uses PaymentFormType::setTicket()
     * @uses PaymentFormType::setVoucher()
     * @uses PaymentFormType::setShareSynchInd()
     * @uses PaymentFormType::setShareMarketInd()
     * @uses PaymentFormType::setCostCenterID()
     * @uses PaymentFormType::setRPH()
     * @uses PaymentFormType::setPaymentTransactionTypeCode()
     * @uses PaymentFormType::setGuaranteeIndicator()
     * @uses PaymentFormType::setGuaranteeTypeCode()
     * @uses PaymentFormType::setGuaranteeID()
     * @uses PaymentFormType::setRemark()
     * @param \StructType\PaymentFormType_ExtensionsType $tPA_Extentions
     * @param \StructType\BankAcctType $bankAcct
     * @param \StructType\Cash $cash
     * @param \StructType\DirectBillType $directBill
     * @param \StructType\LoyaltyRedemption $loyaltyRedemption
     * @param \StructType\MiscChargeOrder $miscChargeOrder
     * @param \StructType\PaymentCardType $paymentCard
     * @param \StructType\Ticket $ticket
     * @param \StructType\Voucher $voucher
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $costCenterID
     * @param string $rPH
     * @param string $paymentTransactionTypeCode
     * @param bool $guaranteeIndicator
     * @param string $guaranteeTypeCode
     * @param string $guaranteeID
     * @param string $remark
     */
    public function __construct(\StructType\PaymentFormType_ExtensionsType $tPA_Extentions = null, \StructType\BankAcctType $bankAcct = null, \StructType\Cash $cash = null, \StructType\DirectBillType $directBill = null, \StructType\LoyaltyRedemption $loyaltyRedemption = null, \StructType\MiscChargeOrder $miscChargeOrder = null, \StructType\PaymentCardType $paymentCard = null, \StructType\Ticket $ticket = null, \StructType\Voucher $voucher = null, $shareSynchInd = null, $shareMarketInd = null, $costCenterID = null, $rPH = null, $paymentTransactionTypeCode = null, $guaranteeIndicator = null, $guaranteeTypeCode = null, $guaranteeID = null, $remark = null)
    {
        $this
            ->setTPA_Extentions($tPA_Extentions)
            ->setBankAcct($bankAcct)
            ->setCash($cash)
            ->setDirectBill($directBill)
            ->setLoyaltyRedemption($loyaltyRedemption)
            ->setMiscChargeOrder($miscChargeOrder)
            ->setPaymentCard($paymentCard)
            ->setTicket($ticket)
            ->setVoucher($voucher)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setCostCenterID($costCenterID)
            ->setRPH($rPH)
            ->setPaymentTransactionTypeCode($paymentTransactionTypeCode)
            ->setGuaranteeIndicator($guaranteeIndicator)
            ->setGuaranteeTypeCode($guaranteeTypeCode)
            ->setGuaranteeID($guaranteeID)
            ->setRemark($remark);
    }
    /**
     * Get TPA_Extentions value
     * @return \StructType\PaymentFormType_ExtensionsType|null
     */
    public function getTPA_Extentions()
    {
        return $this->TPA_Extentions;
    }
    /**
     * Set TPA_Extentions value
     * @param \StructType\PaymentFormType_ExtensionsType $tPA_Extentions
     * @return \StructType\PaymentFormType
     */
    public function setTPA_Extentions(\StructType\PaymentFormType_ExtensionsType $tPA_Extentions = null)
    {
        $this->TPA_Extentions = $tPA_Extentions;
        return $this;
    }
    /**
     * Get BankAcct value
     * @return \StructType\BankAcctType|null
     */
    public function getBankAcct()
    {
        return isset($this->BankAcct) ? $this->BankAcct : null;
    }
    /**
     * This method is responsible for validating the value passed to the setBankAcct method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBankAcct method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBankAcctForChoiceConstraintsFromSetBankAcct($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Cash',
            'DirectBill',
            'LoyaltyRedemption',
            'MiscChargeOrder',
            'PaymentCard',
            'Ticket',
            'Voucher',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property BankAcct can\'t be set as the property %s is already set. Only one property must be set among these properties: BankAcct, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set BankAcct value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BankAcctType $bankAcct
     * @return \StructType\PaymentFormType
     */
    public function setBankAcct(\StructType\BankAcctType $bankAcct = null)
    {
        // validation for constraint: choice(BankAcct, Cash, DirectBill, LoyaltyRedemption, MiscChargeOrder, PaymentCard, Ticket, Voucher)
        if ('' !== ($bankAcctChoiceErrorMessage = self::validateBankAcctForChoiceConstraintsFromSetBankAcct($bankAcct))) {
            throw new \InvalidArgumentException($bankAcctChoiceErrorMessage, __LINE__);
        }
        if (is_null($bankAcct) || (is_array($bankAcct) && empty($bankAcct))) {
            unset($this->BankAcct);
        } else {
            $this->BankAcct = $bankAcct;
        }
        return $this;
    }
    /**
     * Get Cash value
     * @return \StructType\Cash|null
     */
    public function getCash()
    {
        return isset($this->Cash) ? $this->Cash : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCash method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCash method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCashForChoiceConstraintsFromSetCash($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BankAcct',
            'DirectBill',
            'LoyaltyRedemption',
            'MiscChargeOrder',
            'PaymentCard',
            'Ticket',
            'Voucher',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Cash can\'t be set as the property %s is already set. Only one property must be set among these properties: Cash, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Cash value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Cash $cash
     * @return \StructType\PaymentFormType
     */
    public function setCash(\StructType\Cash $cash = null)
    {
        // validation for constraint: choice(BankAcct, Cash, DirectBill, LoyaltyRedemption, MiscChargeOrder, PaymentCard, Ticket, Voucher)
        if ('' !== ($cashChoiceErrorMessage = self::validateCashForChoiceConstraintsFromSetCash($cash))) {
            throw new \InvalidArgumentException($cashChoiceErrorMessage, __LINE__);
        }
        if (is_null($cash) || (is_array($cash) && empty($cash))) {
            unset($this->Cash);
        } else {
            $this->Cash = $cash;
        }
        return $this;
    }
    /**
     * Get DirectBill value
     * @return \StructType\DirectBillType|null
     */
    public function getDirectBill()
    {
        return isset($this->DirectBill) ? $this->DirectBill : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDirectBill method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDirectBill method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDirectBillForChoiceConstraintsFromSetDirectBill($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BankAcct',
            'Cash',
            'LoyaltyRedemption',
            'MiscChargeOrder',
            'PaymentCard',
            'Ticket',
            'Voucher',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DirectBill can\'t be set as the property %s is already set. Only one property must be set among these properties: DirectBill, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DirectBill value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DirectBillType $directBill
     * @return \StructType\PaymentFormType
     */
    public function setDirectBill(\StructType\DirectBillType $directBill = null)
    {
        // validation for constraint: choice(BankAcct, Cash, DirectBill, LoyaltyRedemption, MiscChargeOrder, PaymentCard, Ticket, Voucher)
        if ('' !== ($directBillChoiceErrorMessage = self::validateDirectBillForChoiceConstraintsFromSetDirectBill($directBill))) {
            throw new \InvalidArgumentException($directBillChoiceErrorMessage, __LINE__);
        }
        if (is_null($directBill) || (is_array($directBill) && empty($directBill))) {
            unset($this->DirectBill);
        } else {
            $this->DirectBill = $directBill;
        }
        return $this;
    }
    /**
     * Get LoyaltyRedemption value
     * @return \StructType\LoyaltyRedemption|null
     */
    public function getLoyaltyRedemption()
    {
        return isset($this->LoyaltyRedemption) ? $this->LoyaltyRedemption : null;
    }
    /**
     * This method is responsible for validating the value passed to the setLoyaltyRedemption method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLoyaltyRedemption method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateLoyaltyRedemptionForChoiceConstraintsFromSetLoyaltyRedemption($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BankAcct',
            'Cash',
            'DirectBill',
            'MiscChargeOrder',
            'PaymentCard',
            'Ticket',
            'Voucher',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property LoyaltyRedemption can\'t be set as the property %s is already set. Only one property must be set among these properties: LoyaltyRedemption, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set LoyaltyRedemption value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\LoyaltyRedemption $loyaltyRedemption
     * @return \StructType\PaymentFormType
     */
    public function setLoyaltyRedemption(\StructType\LoyaltyRedemption $loyaltyRedemption = null)
    {
        // validation for constraint: choice(BankAcct, Cash, DirectBill, LoyaltyRedemption, MiscChargeOrder, PaymentCard, Ticket, Voucher)
        if ('' !== ($loyaltyRedemptionChoiceErrorMessage = self::validateLoyaltyRedemptionForChoiceConstraintsFromSetLoyaltyRedemption($loyaltyRedemption))) {
            throw new \InvalidArgumentException($loyaltyRedemptionChoiceErrorMessage, __LINE__);
        }
        if (is_null($loyaltyRedemption) || (is_array($loyaltyRedemption) && empty($loyaltyRedemption))) {
            unset($this->LoyaltyRedemption);
        } else {
            $this->LoyaltyRedemption = $loyaltyRedemption;
        }
        return $this;
    }
    /**
     * Get MiscChargeOrder value
     * @return \StructType\MiscChargeOrder|null
     */
    public function getMiscChargeOrder()
    {
        return isset($this->MiscChargeOrder) ? $this->MiscChargeOrder : null;
    }
    /**
     * This method is responsible for validating the value passed to the setMiscChargeOrder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMiscChargeOrder method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateMiscChargeOrderForChoiceConstraintsFromSetMiscChargeOrder($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BankAcct',
            'Cash',
            'DirectBill',
            'LoyaltyRedemption',
            'PaymentCard',
            'Ticket',
            'Voucher',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property MiscChargeOrder can\'t be set as the property %s is already set. Only one property must be set among these properties: MiscChargeOrder, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set MiscChargeOrder value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MiscChargeOrder $miscChargeOrder
     * @return \StructType\PaymentFormType
     */
    public function setMiscChargeOrder(\StructType\MiscChargeOrder $miscChargeOrder = null)
    {
        // validation for constraint: choice(BankAcct, Cash, DirectBill, LoyaltyRedemption, MiscChargeOrder, PaymentCard, Ticket, Voucher)
        if ('' !== ($miscChargeOrderChoiceErrorMessage = self::validateMiscChargeOrderForChoiceConstraintsFromSetMiscChargeOrder($miscChargeOrder))) {
            throw new \InvalidArgumentException($miscChargeOrderChoiceErrorMessage, __LINE__);
        }
        if (is_null($miscChargeOrder) || (is_array($miscChargeOrder) && empty($miscChargeOrder))) {
            unset($this->MiscChargeOrder);
        } else {
            $this->MiscChargeOrder = $miscChargeOrder;
        }
        return $this;
    }
    /**
     * Get PaymentCard value
     * @return \StructType\PaymentCardType|null
     */
    public function getPaymentCard()
    {
        return isset($this->PaymentCard) ? $this->PaymentCard : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPaymentCard method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentCard method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePaymentCardForChoiceConstraintsFromSetPaymentCard($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BankAcct',
            'Cash',
            'DirectBill',
            'LoyaltyRedemption',
            'MiscChargeOrder',
            'Ticket',
            'Voucher',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PaymentCard can\'t be set as the property %s is already set. Only one property must be set among these properties: PaymentCard, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PaymentCard value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentCardType $paymentCard
     * @return \StructType\PaymentFormType
     */
    public function setPaymentCard(\StructType\PaymentCardType $paymentCard = null)
    {
        // validation for constraint: choice(BankAcct, Cash, DirectBill, LoyaltyRedemption, MiscChargeOrder, PaymentCard, Ticket, Voucher)
        if ('' !== ($paymentCardChoiceErrorMessage = self::validatePaymentCardForChoiceConstraintsFromSetPaymentCard($paymentCard))) {
            throw new \InvalidArgumentException($paymentCardChoiceErrorMessage, __LINE__);
        }
        if (is_null($paymentCard) || (is_array($paymentCard) && empty($paymentCard))) {
            unset($this->PaymentCard);
        } else {
            $this->PaymentCard = $paymentCard;
        }
        return $this;
    }
    /**
     * Get Ticket value
     * @return \StructType\Ticket|null
     */
    public function getTicket()
    {
        return isset($this->Ticket) ? $this->Ticket : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTicket method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTicket method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTicketForChoiceConstraintsFromSetTicket($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BankAcct',
            'Cash',
            'DirectBill',
            'LoyaltyRedemption',
            'MiscChargeOrder',
            'PaymentCard',
            'Voucher',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Ticket can\'t be set as the property %s is already set. Only one property must be set among these properties: Ticket, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Ticket value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Ticket $ticket
     * @return \StructType\PaymentFormType
     */
    public function setTicket(\StructType\Ticket $ticket = null)
    {
        // validation for constraint: choice(BankAcct, Cash, DirectBill, LoyaltyRedemption, MiscChargeOrder, PaymentCard, Ticket, Voucher)
        if ('' !== ($ticketChoiceErrorMessage = self::validateTicketForChoiceConstraintsFromSetTicket($ticket))) {
            throw new \InvalidArgumentException($ticketChoiceErrorMessage, __LINE__);
        }
        if (is_null($ticket) || (is_array($ticket) && empty($ticket))) {
            unset($this->Ticket);
        } else {
            $this->Ticket = $ticket;
        }
        return $this;
    }
    /**
     * Get Voucher value
     * @return \StructType\Voucher|null
     */
    public function getVoucher()
    {
        return isset($this->Voucher) ? $this->Voucher : null;
    }
    /**
     * This method is responsible for validating the value passed to the setVoucher method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVoucher method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateVoucherForChoiceConstraintsFromSetVoucher($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BankAcct',
            'Cash',
            'DirectBill',
            'LoyaltyRedemption',
            'MiscChargeOrder',
            'PaymentCard',
            'Ticket',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Voucher can\'t be set as the property %s is already set. Only one property must be set among these properties: Voucher, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Voucher value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Voucher $voucher
     * @return \StructType\PaymentFormType
     */
    public function setVoucher(\StructType\Voucher $voucher = null)
    {
        // validation for constraint: choice(BankAcct, Cash, DirectBill, LoyaltyRedemption, MiscChargeOrder, PaymentCard, Ticket, Voucher)
        if ('' !== ($voucherChoiceErrorMessage = self::validateVoucherForChoiceConstraintsFromSetVoucher($voucher))) {
            throw new \InvalidArgumentException($voucherChoiceErrorMessage, __LINE__);
        }
        if (is_null($voucher) || (is_array($voucher) && empty($voucher))) {
            unset($this->Voucher);
        } else {
            $this->Voucher = $voucher;
        }
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \StructType\PaymentFormType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareSynchInd, true), gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \StructType\PaymentFormType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareMarketInd, true), gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get CostCenterID value
     * @return string|null
     */
    public function getCostCenterID()
    {
        return $this->CostCenterID;
    }
    /**
     * Set CostCenterID value
     * @param string $costCenterID
     * @return \StructType\PaymentFormType
     */
    public function setCostCenterID($costCenterID = null)
    {
        // validation for constraint: string
        if (!is_null($costCenterID) && !is_string($costCenterID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($costCenterID, true), gettype($costCenterID)), __LINE__);
        }
        $this->CostCenterID = $costCenterID;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\PaymentFormType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get PaymentTransactionTypeCode value
     * @return string|null
     */
    public function getPaymentTransactionTypeCode()
    {
        return $this->PaymentTransactionTypeCode;
    }
    /**
     * Set PaymentTransactionTypeCode value
     * @param string $paymentTransactionTypeCode
     * @return \StructType\PaymentFormType
     */
    public function setPaymentTransactionTypeCode($paymentTransactionTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTransactionTypeCode) && !is_string($paymentTransactionTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTransactionTypeCode, true), gettype($paymentTransactionTypeCode)), __LINE__);
        }
        $this->PaymentTransactionTypeCode = $paymentTransactionTypeCode;
        return $this;
    }
    /**
     * Get GuaranteeIndicator value
     * @return bool|null
     */
    public function getGuaranteeIndicator()
    {
        return $this->GuaranteeIndicator;
    }
    /**
     * Set GuaranteeIndicator value
     * @param bool $guaranteeIndicator
     * @return \StructType\PaymentFormType
     */
    public function setGuaranteeIndicator($guaranteeIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($guaranteeIndicator) && !is_bool($guaranteeIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($guaranteeIndicator, true), gettype($guaranteeIndicator)), __LINE__);
        }
        $this->GuaranteeIndicator = $guaranteeIndicator;
        return $this;
    }
    /**
     * Get GuaranteeTypeCode value
     * @return string|null
     */
    public function getGuaranteeTypeCode()
    {
        return $this->GuaranteeTypeCode;
    }
    /**
     * Set GuaranteeTypeCode value
     * @param string $guaranteeTypeCode
     * @return \StructType\PaymentFormType
     */
    public function setGuaranteeTypeCode($guaranteeTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($guaranteeTypeCode) && !is_string($guaranteeTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guaranteeTypeCode, true), gettype($guaranteeTypeCode)), __LINE__);
        }
        $this->GuaranteeTypeCode = $guaranteeTypeCode;
        return $this;
    }
    /**
     * Get GuaranteeID value
     * @return string|null
     */
    public function getGuaranteeID()
    {
        return $this->GuaranteeID;
    }
    /**
     * Set GuaranteeID value
     * @param string $guaranteeID
     * @return \StructType\PaymentFormType
     */
    public function setGuaranteeID($guaranteeID = null)
    {
        // validation for constraint: string
        if (!is_null($guaranteeID) && !is_string($guaranteeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guaranteeID, true), gettype($guaranteeID)), __LINE__);
        }
        $this->GuaranteeID = $guaranteeID;
        return $this;
    }
    /**
     * Get Remark value
     * @return string|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * Set Remark value
     * @param string $remark
     * @return \StructType\PaymentFormType
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentFormType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
