<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OxiReservationExt StructType
 * @subpackage Structs
 */
class OxiReservationExt extends AbstractStructBase
{
    /**
     * The roomStayIds
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $roomStayIds;
    /**
     * The comments
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $comments;
    /**
     * The OxiCashlessPaymentInvoice
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OxiCashlessPaymentInvoice[]
     */
    public $OxiCashlessPaymentInvoice;
    /**
     * The agentProfileId
     * @var string
     */
    public $agentProfileId;
    /**
     * The agentProfileName
     * @var string
     */
    public $agentProfileName;
    /**
     * The companyProfileId
     * @var string
     */
    public $companyProfileId;
    /**
     * The companyProfileName
     * @var string
     */
    public $companyProfileName;
    /**
     * The groupProfileId
     * @var string
     */
    public $groupProfileId;
    /**
     * The groupProfileName
     * @var string
     */
    public $groupProfileName;
    /**
     * The sourceProfileId
     * @var string
     */
    public $sourceProfileId;
    /**
     * The sourceProfileName
     * @var string
     */
    public $sourceProfileName;
    /**
     * The resTypeCode
     * @var string
     */
    public $resTypeCode;
    /**
     * The creditCardRequired
     * @var bool
     */
    public $creditCardRequired;
    /**
     * The paymentCode
     * @var string
     */
    public $paymentCode;
    /**
     * The marketCode
     * @var string
     */
    public $marketCode;
    /**
     * The sourceCode
     * @var string
     */
    public $sourceCode;
    /**
     * The originCode
     * @var string
     */
    public $originCode;
    /**
     * Constructor method for OxiReservationExt
     * @uses OxiReservationExt::setRoomStayIds()
     * @uses OxiReservationExt::setComments()
     * @uses OxiReservationExt::setOxiCashlessPaymentInvoice()
     * @uses OxiReservationExt::setAgentProfileId()
     * @uses OxiReservationExt::setAgentProfileName()
     * @uses OxiReservationExt::setCompanyProfileId()
     * @uses OxiReservationExt::setCompanyProfileName()
     * @uses OxiReservationExt::setGroupProfileId()
     * @uses OxiReservationExt::setGroupProfileName()
     * @uses OxiReservationExt::setSourceProfileId()
     * @uses OxiReservationExt::setSourceProfileName()
     * @uses OxiReservationExt::setResTypeCode()
     * @uses OxiReservationExt::setCreditCardRequired()
     * @uses OxiReservationExt::setPaymentCode()
     * @uses OxiReservationExt::setMarketCode()
     * @uses OxiReservationExt::setSourceCode()
     * @uses OxiReservationExt::setOriginCode()
     * @param int[] $roomStayIds
     * @param string[] $comments
     * @param \StructType\OxiCashlessPaymentInvoice[] $oxiCashlessPaymentInvoice
     * @param string $agentProfileId
     * @param string $agentProfileName
     * @param string $companyProfileId
     * @param string $companyProfileName
     * @param string $groupProfileId
     * @param string $groupProfileName
     * @param string $sourceProfileId
     * @param string $sourceProfileName
     * @param string $resTypeCode
     * @param bool $creditCardRequired
     * @param string $paymentCode
     * @param string $marketCode
     * @param string $sourceCode
     * @param string $originCode
     */
    public function __construct(array $roomStayIds = array(), array $comments = array(), array $oxiCashlessPaymentInvoice = array(), $agentProfileId = null, $agentProfileName = null, $companyProfileId = null, $companyProfileName = null, $groupProfileId = null, $groupProfileName = null, $sourceProfileId = null, $sourceProfileName = null, $resTypeCode = null, $creditCardRequired = null, $paymentCode = null, $marketCode = null, $sourceCode = null, $originCode = null)
    {
        $this
            ->setRoomStayIds($roomStayIds)
            ->setComments($comments)
            ->setOxiCashlessPaymentInvoice($oxiCashlessPaymentInvoice)
            ->setAgentProfileId($agentProfileId)
            ->setAgentProfileName($agentProfileName)
            ->setCompanyProfileId($companyProfileId)
            ->setCompanyProfileName($companyProfileName)
            ->setGroupProfileId($groupProfileId)
            ->setGroupProfileName($groupProfileName)
            ->setSourceProfileId($sourceProfileId)
            ->setSourceProfileName($sourceProfileName)
            ->setResTypeCode($resTypeCode)
            ->setCreditCardRequired($creditCardRequired)
            ->setPaymentCode($paymentCode)
            ->setMarketCode($marketCode)
            ->setSourceCode($sourceCode)
            ->setOriginCode($originCode);
    }
    /**
     * Get roomStayIds value
     * @return int[]|null
     */
    public function getRoomStayIds()
    {
        return $this->roomStayIds;
    }
    /**
     * This method is responsible for validating the values passed to the setRoomStayIds method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoomStayIds method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomStayIdsForArrayConstraintsFromSetRoomStayIds(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $oxiReservationExtRoomStayIdsItem) {
            // validation for constraint: itemType
            if (!(is_int($oxiReservationExtRoomStayIdsItem) || ctype_digit($oxiReservationExtRoomStayIdsItem))) {
                $invalidValues[] = is_object($oxiReservationExtRoomStayIdsItem) ? get_class($oxiReservationExtRoomStayIdsItem) : sprintf('%s(%s)', gettype($oxiReservationExtRoomStayIdsItem), var_export($oxiReservationExtRoomStayIdsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The roomStayIds property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set roomStayIds value
     * @throws \InvalidArgumentException
     * @param int[] $roomStayIds
     * @return \StructType\OxiReservationExt
     */
    public function setRoomStayIds(array $roomStayIds = array())
    {
        // validation for constraint: array
        if ('' !== ($roomStayIdsArrayErrorMessage = self::validateRoomStayIdsForArrayConstraintsFromSetRoomStayIds($roomStayIds))) {
            throw new \InvalidArgumentException($roomStayIdsArrayErrorMessage, __LINE__);
        }
        $this->roomStayIds = $roomStayIds;
        return $this;
    }
    /**
     * Add item to roomStayIds value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\OxiReservationExt
     */
    public function addToRoomStayIds($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The roomStayIds property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->roomStayIds[] = $item;
        return $this;
    }
    /**
     * Get comments value
     * @return string[]|null
     */
    public function getComments()
    {
        return $this->comments;
    }
    /**
     * This method is responsible for validating the values passed to the setComments method
     * This method is willingly generated in order to preserve the one-line inline validation within the setComments method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommentsForArrayConstraintsFromSetComments(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $oxiReservationExtCommentsItem) {
            // validation for constraint: itemType
            if (!is_string($oxiReservationExtCommentsItem)) {
                $invalidValues[] = is_object($oxiReservationExtCommentsItem) ? get_class($oxiReservationExtCommentsItem) : sprintf('%s(%s)', gettype($oxiReservationExtCommentsItem), var_export($oxiReservationExtCommentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The comments property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set comments value
     * @throws \InvalidArgumentException
     * @param string[] $comments
     * @return \StructType\OxiReservationExt
     */
    public function setComments(array $comments = array())
    {
        // validation for constraint: array
        if ('' !== ($commentsArrayErrorMessage = self::validateCommentsForArrayConstraintsFromSetComments($comments))) {
            throw new \InvalidArgumentException($commentsArrayErrorMessage, __LINE__);
        }
        $this->comments = $comments;
        return $this;
    }
    /**
     * Add item to comments value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\OxiReservationExt
     */
    public function addToComments($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The comments property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->comments[] = $item;
        return $this;
    }
    /**
     * Get OxiCashlessPaymentInvoice value
     * @return \StructType\OxiCashlessPaymentInvoice[]|null
     */
    public function getOxiCashlessPaymentInvoice()
    {
        return $this->OxiCashlessPaymentInvoice;
    }
    /**
     * This method is responsible for validating the values passed to the setOxiCashlessPaymentInvoice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOxiCashlessPaymentInvoice method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOxiCashlessPaymentInvoiceForArrayConstraintsFromSetOxiCashlessPaymentInvoice(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $oxiReservationExtOxiCashlessPaymentInvoiceItem) {
            // validation for constraint: itemType
            if (!$oxiReservationExtOxiCashlessPaymentInvoiceItem instanceof \StructType\OxiCashlessPaymentInvoice) {
                $invalidValues[] = is_object($oxiReservationExtOxiCashlessPaymentInvoiceItem) ? get_class($oxiReservationExtOxiCashlessPaymentInvoiceItem) : sprintf('%s(%s)', gettype($oxiReservationExtOxiCashlessPaymentInvoiceItem), var_export($oxiReservationExtOxiCashlessPaymentInvoiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OxiCashlessPaymentInvoice property can only contain items of type \StructType\OxiCashlessPaymentInvoice, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OxiCashlessPaymentInvoice value
     * @throws \InvalidArgumentException
     * @param \StructType\OxiCashlessPaymentInvoice[] $oxiCashlessPaymentInvoice
     * @return \StructType\OxiReservationExt
     */
    public function setOxiCashlessPaymentInvoice(array $oxiCashlessPaymentInvoice = array())
    {
        // validation for constraint: array
        if ('' !== ($oxiCashlessPaymentInvoiceArrayErrorMessage = self::validateOxiCashlessPaymentInvoiceForArrayConstraintsFromSetOxiCashlessPaymentInvoice($oxiCashlessPaymentInvoice))) {
            throw new \InvalidArgumentException($oxiCashlessPaymentInvoiceArrayErrorMessage, __LINE__);
        }
        $this->OxiCashlessPaymentInvoice = $oxiCashlessPaymentInvoice;
        return $this;
    }
    /**
     * Add item to OxiCashlessPaymentInvoice value
     * @throws \InvalidArgumentException
     * @param \StructType\OxiCashlessPaymentInvoice $item
     * @return \StructType\OxiReservationExt
     */
    public function addToOxiCashlessPaymentInvoice(\StructType\OxiCashlessPaymentInvoice $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OxiCashlessPaymentInvoice) {
            throw new \InvalidArgumentException(sprintf('The OxiCashlessPaymentInvoice property can only contain items of type \StructType\OxiCashlessPaymentInvoice, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OxiCashlessPaymentInvoice[] = $item;
        return $this;
    }
    /**
     * Get agentProfileId value
     * @return string|null
     */
    public function getAgentProfileId()
    {
        return $this->agentProfileId;
    }
    /**
     * Set agentProfileId value
     * @param string $agentProfileId
     * @return \StructType\OxiReservationExt
     */
    public function setAgentProfileId($agentProfileId = null)
    {
        // validation for constraint: string
        if (!is_null($agentProfileId) && !is_string($agentProfileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentProfileId, true), gettype($agentProfileId)), __LINE__);
        }
        $this->agentProfileId = $agentProfileId;
        return $this;
    }
    /**
     * Get agentProfileName value
     * @return string|null
     */
    public function getAgentProfileName()
    {
        return $this->agentProfileName;
    }
    /**
     * Set agentProfileName value
     * @param string $agentProfileName
     * @return \StructType\OxiReservationExt
     */
    public function setAgentProfileName($agentProfileName = null)
    {
        // validation for constraint: string
        if (!is_null($agentProfileName) && !is_string($agentProfileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentProfileName, true), gettype($agentProfileName)), __LINE__);
        }
        $this->agentProfileName = $agentProfileName;
        return $this;
    }
    /**
     * Get companyProfileId value
     * @return string|null
     */
    public function getCompanyProfileId()
    {
        return $this->companyProfileId;
    }
    /**
     * Set companyProfileId value
     * @param string $companyProfileId
     * @return \StructType\OxiReservationExt
     */
    public function setCompanyProfileId($companyProfileId = null)
    {
        // validation for constraint: string
        if (!is_null($companyProfileId) && !is_string($companyProfileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyProfileId, true), gettype($companyProfileId)), __LINE__);
        }
        $this->companyProfileId = $companyProfileId;
        return $this;
    }
    /**
     * Get companyProfileName value
     * @return string|null
     */
    public function getCompanyProfileName()
    {
        return $this->companyProfileName;
    }
    /**
     * Set companyProfileName value
     * @param string $companyProfileName
     * @return \StructType\OxiReservationExt
     */
    public function setCompanyProfileName($companyProfileName = null)
    {
        // validation for constraint: string
        if (!is_null($companyProfileName) && !is_string($companyProfileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyProfileName, true), gettype($companyProfileName)), __LINE__);
        }
        $this->companyProfileName = $companyProfileName;
        return $this;
    }
    /**
     * Get groupProfileId value
     * @return string|null
     */
    public function getGroupProfileId()
    {
        return $this->groupProfileId;
    }
    /**
     * Set groupProfileId value
     * @param string $groupProfileId
     * @return \StructType\OxiReservationExt
     */
    public function setGroupProfileId($groupProfileId = null)
    {
        // validation for constraint: string
        if (!is_null($groupProfileId) && !is_string($groupProfileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupProfileId, true), gettype($groupProfileId)), __LINE__);
        }
        $this->groupProfileId = $groupProfileId;
        return $this;
    }
    /**
     * Get groupProfileName value
     * @return string|null
     */
    public function getGroupProfileName()
    {
        return $this->groupProfileName;
    }
    /**
     * Set groupProfileName value
     * @param string $groupProfileName
     * @return \StructType\OxiReservationExt
     */
    public function setGroupProfileName($groupProfileName = null)
    {
        // validation for constraint: string
        if (!is_null($groupProfileName) && !is_string($groupProfileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupProfileName, true), gettype($groupProfileName)), __LINE__);
        }
        $this->groupProfileName = $groupProfileName;
        return $this;
    }
    /**
     * Get sourceProfileId value
     * @return string|null
     */
    public function getSourceProfileId()
    {
        return $this->sourceProfileId;
    }
    /**
     * Set sourceProfileId value
     * @param string $sourceProfileId
     * @return \StructType\OxiReservationExt
     */
    public function setSourceProfileId($sourceProfileId = null)
    {
        // validation for constraint: string
        if (!is_null($sourceProfileId) && !is_string($sourceProfileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceProfileId, true), gettype($sourceProfileId)), __LINE__);
        }
        $this->sourceProfileId = $sourceProfileId;
        return $this;
    }
    /**
     * Get sourceProfileName value
     * @return string|null
     */
    public function getSourceProfileName()
    {
        return $this->sourceProfileName;
    }
    /**
     * Set sourceProfileName value
     * @param string $sourceProfileName
     * @return \StructType\OxiReservationExt
     */
    public function setSourceProfileName($sourceProfileName = null)
    {
        // validation for constraint: string
        if (!is_null($sourceProfileName) && !is_string($sourceProfileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceProfileName, true), gettype($sourceProfileName)), __LINE__);
        }
        $this->sourceProfileName = $sourceProfileName;
        return $this;
    }
    /**
     * Get resTypeCode value
     * @return string|null
     */
    public function getResTypeCode()
    {
        return $this->resTypeCode;
    }
    /**
     * Set resTypeCode value
     * @param string $resTypeCode
     * @return \StructType\OxiReservationExt
     */
    public function setResTypeCode($resTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($resTypeCode) && !is_string($resTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resTypeCode, true), gettype($resTypeCode)), __LINE__);
        }
        $this->resTypeCode = $resTypeCode;
        return $this;
    }
    /**
     * Get creditCardRequired value
     * @return bool|null
     */
    public function getCreditCardRequired()
    {
        return $this->creditCardRequired;
    }
    /**
     * Set creditCardRequired value
     * @param bool $creditCardRequired
     * @return \StructType\OxiReservationExt
     */
    public function setCreditCardRequired($creditCardRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($creditCardRequired) && !is_bool($creditCardRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($creditCardRequired, true), gettype($creditCardRequired)), __LINE__);
        }
        $this->creditCardRequired = $creditCardRequired;
        return $this;
    }
    /**
     * Get paymentCode value
     * @return string|null
     */
    public function getPaymentCode()
    {
        return $this->paymentCode;
    }
    /**
     * Set paymentCode value
     * @param string $paymentCode
     * @return \StructType\OxiReservationExt
     */
    public function setPaymentCode($paymentCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentCode) && !is_string($paymentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentCode, true), gettype($paymentCode)), __LINE__);
        }
        $this->paymentCode = $paymentCode;
        return $this;
    }
    /**
     * Get marketCode value
     * @return string|null
     */
    public function getMarketCode()
    {
        return $this->marketCode;
    }
    /**
     * Set marketCode value
     * @param string $marketCode
     * @return \StructType\OxiReservationExt
     */
    public function setMarketCode($marketCode = null)
    {
        // validation for constraint: string
        if (!is_null($marketCode) && !is_string($marketCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marketCode, true), gettype($marketCode)), __LINE__);
        }
        $this->marketCode = $marketCode;
        return $this;
    }
    /**
     * Get sourceCode value
     * @return string|null
     */
    public function getSourceCode()
    {
        return $this->sourceCode;
    }
    /**
     * Set sourceCode value
     * @param string $sourceCode
     * @return \StructType\OxiReservationExt
     */
    public function setSourceCode($sourceCode = null)
    {
        // validation for constraint: string
        if (!is_null($sourceCode) && !is_string($sourceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceCode, true), gettype($sourceCode)), __LINE__);
        }
        $this->sourceCode = $sourceCode;
        return $this;
    }
    /**
     * Get originCode value
     * @return string|null
     */
    public function getOriginCode()
    {
        return $this->originCode;
    }
    /**
     * Set originCode value
     * @param string $originCode
     * @return \StructType\OxiReservationExt
     */
    public function setOriginCode($originCode = null)
    {
        // validation for constraint: string
        if (!is_null($originCode) && !is_string($originCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originCode, true), gettype($originCode)), __LINE__);
        }
        $this->originCode = $originCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OxiReservationExt
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
