<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OxiCashlessPaymentInvoice StructType
 * @subpackage Structs
 */
class OxiCashlessPaymentInvoice extends AbstractStructBase
{
    /**
     * The CustomerAddress
     * @var string
     */
    public $CustomerAddress;
    /**
     * The CustomerDeJureAddress
     * @var string
     */
    public $CustomerDeJureAddress;
    /**
     * The CustomerKPP
     * @var string
     */
    public $CustomerKPP;
    /**
     * The CustomerEmail
     * @var string
     */
    public $CustomerEmail;
    /**
     * The CustomerPhoneNumber
     * @var string
     */
    public $CustomerPhoneNumber;
    /**
     * The CustomerINN
     * @var string
     */
    public $CustomerINN;
    /**
     * The CustomerCompany
     * @var string
     */
    public $CustomerCompany;
    /**
     * Constructor method for OxiCashlessPaymentInvoice
     * @uses OxiCashlessPaymentInvoice::setCustomerAddress()
     * @uses OxiCashlessPaymentInvoice::setCustomerDeJureAddress()
     * @uses OxiCashlessPaymentInvoice::setCustomerKPP()
     * @uses OxiCashlessPaymentInvoice::setCustomerEmail()
     * @uses OxiCashlessPaymentInvoice::setCustomerPhoneNumber()
     * @uses OxiCashlessPaymentInvoice::setCustomerINN()
     * @uses OxiCashlessPaymentInvoice::setCustomerCompany()
     * @param string $customerAddress
     * @param string $customerDeJureAddress
     * @param string $customerKPP
     * @param string $customerEmail
     * @param string $customerPhoneNumber
     * @param string $customerINN
     * @param string $customerCompany
     */
    public function __construct($customerAddress = null, $customerDeJureAddress = null, $customerKPP = null, $customerEmail = null, $customerPhoneNumber = null, $customerINN = null, $customerCompany = null)
    {
        $this
            ->setCustomerAddress($customerAddress)
            ->setCustomerDeJureAddress($customerDeJureAddress)
            ->setCustomerKPP($customerKPP)
            ->setCustomerEmail($customerEmail)
            ->setCustomerPhoneNumber($customerPhoneNumber)
            ->setCustomerINN($customerINN)
            ->setCustomerCompany($customerCompany);
    }
    /**
     * Get CustomerAddress value
     * @return string|null
     */
    public function getCustomerAddress()
    {
        return $this->CustomerAddress;
    }
    /**
     * Set CustomerAddress value
     * @param string $customerAddress
     * @return \StructType\OxiCashlessPaymentInvoice
     */
    public function setCustomerAddress($customerAddress = null)
    {
        // validation for constraint: string
        if (!is_null($customerAddress) && !is_string($customerAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerAddress, true), gettype($customerAddress)), __LINE__);
        }
        $this->CustomerAddress = $customerAddress;
        return $this;
    }
    /**
     * Get CustomerDeJureAddress value
     * @return string|null
     */
    public function getCustomerDeJureAddress()
    {
        return $this->CustomerDeJureAddress;
    }
    /**
     * Set CustomerDeJureAddress value
     * @param string $customerDeJureAddress
     * @return \StructType\OxiCashlessPaymentInvoice
     */
    public function setCustomerDeJureAddress($customerDeJureAddress = null)
    {
        // validation for constraint: string
        if (!is_null($customerDeJureAddress) && !is_string($customerDeJureAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerDeJureAddress, true), gettype($customerDeJureAddress)), __LINE__);
        }
        $this->CustomerDeJureAddress = $customerDeJureAddress;
        return $this;
    }
    /**
     * Get CustomerKPP value
     * @return string|null
     */
    public function getCustomerKPP()
    {
        return $this->CustomerKPP;
    }
    /**
     * Set CustomerKPP value
     * @param string $customerKPP
     * @return \StructType\OxiCashlessPaymentInvoice
     */
    public function setCustomerKPP($customerKPP = null)
    {
        // validation for constraint: string
        if (!is_null($customerKPP) && !is_string($customerKPP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerKPP, true), gettype($customerKPP)), __LINE__);
        }
        $this->CustomerKPP = $customerKPP;
        return $this;
    }
    /**
     * Get CustomerEmail value
     * @return string|null
     */
    public function getCustomerEmail()
    {
        return $this->CustomerEmail;
    }
    /**
     * Set CustomerEmail value
     * @param string $customerEmail
     * @return \StructType\OxiCashlessPaymentInvoice
     */
    public function setCustomerEmail($customerEmail = null)
    {
        // validation for constraint: string
        if (!is_null($customerEmail) && !is_string($customerEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerEmail, true), gettype($customerEmail)), __LINE__);
        }
        $this->CustomerEmail = $customerEmail;
        return $this;
    }
    /**
     * Get CustomerPhoneNumber value
     * @return string|null
     */
    public function getCustomerPhoneNumber()
    {
        return $this->CustomerPhoneNumber;
    }
    /**
     * Set CustomerPhoneNumber value
     * @param string $customerPhoneNumber
     * @return \StructType\OxiCashlessPaymentInvoice
     */
    public function setCustomerPhoneNumber($customerPhoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($customerPhoneNumber) && !is_string($customerPhoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerPhoneNumber, true), gettype($customerPhoneNumber)), __LINE__);
        }
        $this->CustomerPhoneNumber = $customerPhoneNumber;
        return $this;
    }
    /**
     * Get CustomerINN value
     * @return string|null
     */
    public function getCustomerINN()
    {
        return $this->CustomerINN;
    }
    /**
     * Set CustomerINN value
     * @param string $customerINN
     * @return \StructType\OxiCashlessPaymentInvoice
     */
    public function setCustomerINN($customerINN = null)
    {
        // validation for constraint: string
        if (!is_null($customerINN) && !is_string($customerINN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerINN, true), gettype($customerINN)), __LINE__);
        }
        $this->CustomerINN = $customerINN;
        return $this;
    }
    /**
     * Get CustomerCompany value
     * @return string|null
     */
    public function getCustomerCompany()
    {
        return $this->CustomerCompany;
    }
    /**
     * Set CustomerCompany value
     * @param string $customerCompany
     * @return \StructType\OxiCashlessPaymentInvoice
     */
    public function setCustomerCompany($customerCompany = null)
    {
        // validation for constraint: string
        if (!is_null($customerCompany) && !is_string($customerCompany)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerCompany, true), gettype($customerCompany)), __LINE__);
        }
        $this->CustomerCompany = $customerCompany;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OxiCashlessPaymentInvoice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
