<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MultimediaDescriptionType StructType
 * @subpackage Structs
 */
class MultimediaDescriptionType extends AbstractStructBase
{
    /**
     * The ImageItems
     * Meta informations extracted from the WSDL
     * - choice: ImageItems | TextItems
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ImageItemsType
     */
    public $ImageItems;
    /**
     * The TextItems
     * Meta informations extracted from the WSDL
     * - choice: ImageItems | TextItems
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TextItemsType
     */
    public $TextItems;
    /**
     * Constructor method for MultimediaDescriptionType
     * @uses MultimediaDescriptionType::setImageItems()
     * @uses MultimediaDescriptionType::setTextItems()
     * @param \StructType\ImageItemsType $imageItems
     * @param \StructType\TextItemsType $textItems
     */
    public function __construct(\StructType\ImageItemsType $imageItems = null, \StructType\TextItemsType $textItems = null)
    {
        $this
            ->setImageItems($imageItems)
            ->setTextItems($textItems);
    }
    /**
     * Get ImageItems value
     * @return \StructType\ImageItemsType|null
     */
    public function getImageItems()
    {
        return isset($this->ImageItems) ? $this->ImageItems : null;
    }
    /**
     * This method is responsible for validating the value passed to the setImageItems method
     * This method is willingly generated in order to preserve the one-line inline validation within the setImageItems method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateImageItemsForChoiceConstraintsFromSetImageItems($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'TextItems',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ImageItems can\'t be set as the property %s is already set. Only one property must be set among these properties: ImageItems, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ImageItems value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ImageItemsType $imageItems
     * @return \StructType\MultimediaDescriptionType
     */
    public function setImageItems(\StructType\ImageItemsType $imageItems = null)
    {
        // validation for constraint: choice(ImageItems, TextItems)
        if ('' !== ($imageItemsChoiceErrorMessage = self::validateImageItemsForChoiceConstraintsFromSetImageItems($imageItems))) {
            throw new \InvalidArgumentException($imageItemsChoiceErrorMessage, __LINE__);
        }
        if (is_null($imageItems) || (is_array($imageItems) && empty($imageItems))) {
            unset($this->ImageItems);
        } else {
            $this->ImageItems = $imageItems;
        }
        return $this;
    }
    /**
     * Get TextItems value
     * @return \StructType\TextItemsType|null
     */
    public function getTextItems()
    {
        return isset($this->TextItems) ? $this->TextItems : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTextItems method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTextItems method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTextItemsForChoiceConstraintsFromSetTextItems($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ImageItems',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property TextItems can\'t be set as the property %s is already set. Only one property must be set among these properties: TextItems, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set TextItems value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TextItemsType $textItems
     * @return \StructType\MultimediaDescriptionType
     */
    public function setTextItems(\StructType\TextItemsType $textItems = null)
    {
        // validation for constraint: choice(ImageItems, TextItems)
        if ('' !== ($textItemsChoiceErrorMessage = self::validateTextItemsForChoiceConstraintsFromSetTextItems($textItems))) {
            throw new \InvalidArgumentException($textItemsChoiceErrorMessage, __LINE__);
        }
        if (is_null($textItems) || (is_array($textItems) && empty($textItems))) {
            unset($this->TextItems);
        } else {
            $this->TextItems = $textItems;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MultimediaDescriptionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
