<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Language StructType
 * @subpackage Structs
 */
class Language extends AbstractStructBase
{
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * The PrimaryLangInd
     * @var bool
     */
    public $PrimaryLangInd;
    /**
     * Constructor method for Language
     * @uses Language::setLanguage()
     * @uses Language::setPrimaryLangInd()
     * @param string $language
     * @param bool $primaryLangInd
     */
    public function __construct($language = null, $primaryLangInd = null)
    {
        $this
            ->setLanguage($language)
            ->setPrimaryLangInd($primaryLangInd);
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\Language
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get PrimaryLangInd value
     * @return bool|null
     */
    public function getPrimaryLangInd()
    {
        return $this->PrimaryLangInd;
    }
    /**
     * Set PrimaryLangInd value
     * @param bool $primaryLangInd
     * @return \StructType\Language
     */
    public function setPrimaryLangInd($primaryLangInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($primaryLangInd) && !is_bool($primaryLangInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($primaryLangInd, true), gettype($primaryLangInd)), __LINE__);
        }
        $this->PrimaryLangInd = $primaryLangInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Language
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
