<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvBlockRoomType StructType
 * @subpackage Structs
 */
class InvBlockRoomType extends AbstractStructBase
{
    /**
     * The RoomTypeAllocations
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RoomTypeAllocations[]
     */
    public $RoomTypeAllocations;
    /**
     * The RatePlans
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInvBlockRoomTypeRatePlan
     */
    public $RatePlans;
    /**
     * The DaysOfWeeks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDOW_RulesType
     */
    public $DaysOfWeeks;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * The RoomTypeCode
     * @var string
     */
    public $RoomTypeCode;
    /**
     * Constructor method for InvBlockRoomType
     * @uses InvBlockRoomType::setRoomTypeAllocations()
     * @uses InvBlockRoomType::setRatePlans()
     * @uses InvBlockRoomType::setDaysOfWeeks()
     * @uses InvBlockRoomType::setStart()
     * @uses InvBlockRoomType::setDuration()
     * @uses InvBlockRoomType::setEnd()
     * @uses InvBlockRoomType::setRoomTypeCode()
     * @param \StructType\RoomTypeAllocations[] $roomTypeAllocations
     * @param \ArrayType\ArrayOfInvBlockRoomTypeRatePlan $ratePlans
     * @param \ArrayType\ArrayOfDOW_RulesType $daysOfWeeks
     * @param string $start
     * @param string $duration
     * @param string $end
     * @param string $roomTypeCode
     */
    public function __construct(array $roomTypeAllocations = array(), \ArrayType\ArrayOfInvBlockRoomTypeRatePlan $ratePlans = null, \ArrayType\ArrayOfDOW_RulesType $daysOfWeeks = null, $start = null, $duration = null, $end = null, $roomTypeCode = null)
    {
        $this
            ->setRoomTypeAllocations($roomTypeAllocations)
            ->setRatePlans($ratePlans)
            ->setDaysOfWeeks($daysOfWeeks)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end)
            ->setRoomTypeCode($roomTypeCode);
    }
    /**
     * Get RoomTypeAllocations value
     * @return \StructType\RoomTypeAllocations[]|null
     */
    public function getRoomTypeAllocations()
    {
        return $this->RoomTypeAllocations;
    }
    /**
     * This method is responsible for validating the values passed to the setRoomTypeAllocations method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoomTypeAllocations method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomTypeAllocationsForArrayConstraintsFromSetRoomTypeAllocations(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invBlockRoomTypeRoomTypeAllocationsItem) {
            // validation for constraint: itemType
            if (!$invBlockRoomTypeRoomTypeAllocationsItem instanceof \StructType\RoomTypeAllocations) {
                $invalidValues[] = is_object($invBlockRoomTypeRoomTypeAllocationsItem) ? get_class($invBlockRoomTypeRoomTypeAllocationsItem) : sprintf('%s(%s)', gettype($invBlockRoomTypeRoomTypeAllocationsItem), var_export($invBlockRoomTypeRoomTypeAllocationsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RoomTypeAllocations property can only contain items of type \StructType\RoomTypeAllocations, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RoomTypeAllocations value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomTypeAllocations[] $roomTypeAllocations
     * @return \StructType\InvBlockRoomType
     */
    public function setRoomTypeAllocations(array $roomTypeAllocations = array())
    {
        // validation for constraint: array
        if ('' !== ($roomTypeAllocationsArrayErrorMessage = self::validateRoomTypeAllocationsForArrayConstraintsFromSetRoomTypeAllocations($roomTypeAllocations))) {
            throw new \InvalidArgumentException($roomTypeAllocationsArrayErrorMessage, __LINE__);
        }
        $this->RoomTypeAllocations = $roomTypeAllocations;
        return $this;
    }
    /**
     * Add item to RoomTypeAllocations value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomTypeAllocations $item
     * @return \StructType\InvBlockRoomType
     */
    public function addToRoomTypeAllocations(\StructType\RoomTypeAllocations $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RoomTypeAllocations) {
            throw new \InvalidArgumentException(sprintf('The RoomTypeAllocations property can only contain items of type \StructType\RoomTypeAllocations, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RoomTypeAllocations[] = $item;
        return $this;
    }
    /**
     * Get RatePlans value
     * @return \ArrayType\ArrayOfInvBlockRoomTypeRatePlan|null
     */
    public function getRatePlans()
    {
        return $this->RatePlans;
    }
    /**
     * Set RatePlans value
     * @param \ArrayType\ArrayOfInvBlockRoomTypeRatePlan $ratePlans
     * @return \StructType\InvBlockRoomType
     */
    public function setRatePlans(\ArrayType\ArrayOfInvBlockRoomTypeRatePlan $ratePlans = null)
    {
        $this->RatePlans = $ratePlans;
        return $this;
    }
    /**
     * Get DaysOfWeeks value
     * @return \ArrayType\ArrayOfDOW_RulesType|null
     */
    public function getDaysOfWeeks()
    {
        return $this->DaysOfWeeks;
    }
    /**
     * Set DaysOfWeeks value
     * @param \ArrayType\ArrayOfDOW_RulesType $daysOfWeeks
     * @return \StructType\InvBlockRoomType
     */
    public function setDaysOfWeeks(\ArrayType\ArrayOfDOW_RulesType $daysOfWeeks = null)
    {
        $this->DaysOfWeeks = $daysOfWeeks;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\InvBlockRoomType
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\InvBlockRoomType
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\InvBlockRoomType
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get RoomTypeCode value
     * @return string|null
     */
    public function getRoomTypeCode()
    {
        return $this->RoomTypeCode;
    }
    /**
     * Set RoomTypeCode value
     * @param string $roomTypeCode
     * @return \StructType\InvBlockRoomType
     */
    public function setRoomTypeCode($roomTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomTypeCode) && !is_string($roomTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomTypeCode, true), gettype($roomTypeCode)), __LINE__);
        }
        $this->RoomTypeCode = $roomTypeCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvBlockRoomType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
