<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InfoItem StructType
 * @subpackage Structs
 */
class InfoItem extends AbstractStructBase
{
    /**
     * The kind
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $kind;
    /**
     * The value
     * @var string
     */
    public $value;
    /**
     * Constructor method for InfoItem
     * @uses InfoItem::setKind()
     * @uses InfoItem::setValue()
     * @param string $kind
     * @param string $value
     */
    public function __construct($kind = null, $value = null)
    {
        $this
            ->setKind($kind)
            ->setValue($value);
    }
    /**
     * Get kind value
     * @return string
     */
    public function getKind()
    {
        return $this->kind;
    }
    /**
     * Set kind value
     * @uses \EnumType\TransferInfoItemKind::valueIsValid()
     * @uses \EnumType\TransferInfoItemKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kind
     * @return \StructType\InfoItem
     */
    public function setKind($kind = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransferInfoItemKind::valueIsValid($kind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TransferInfoItemKind', is_array($kind) ? implode(', ', $kind) : var_export($kind, true), implode(', ', \EnumType\TransferInfoItemKind::getValidValues())), __LINE__);
        }
        $this->kind = $kind;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \StructType\InfoItem
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InfoItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
